/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import stirling.software.SPDF.config.EndpointInterceptor;
import stirling.software.common.model.ApplicationProperties;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private final EndpointInterceptor endpointInterceptor;
    private final ApplicationProperties applicationProperties;
    private static final Logger logger = LoggerFactory.getLogger(WebMvcConfig.class);

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.endpointInterceptor);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/assets/**"}).addResourceLocations(new String[]{"classpath:/static/assets/"}).setCacheControl(CacheControl.maxAge((long)365L, (TimeUnit)TimeUnit.DAYS).cachePublic());
        registry.addResourceHandler(new String[]{"/index.html"}).addResourceLocations(new String[]{"classpath:/static/"}).setCacheControl(CacheControl.noCache().mustRevalidate());
    }

    public void addCorsMappings(CorsRegistry registry) {
        boolean hasConfiguredOrigins;
        boolean isTauriMode = Boolean.parseBoolean(System.getProperty("STIRLING_PDF_TAURI_MODE", "false"));
        boolean bl = hasConfiguredOrigins = this.applicationProperties.getSystem() != null && this.applicationProperties.getSystem().getCorsAllowedOrigins() != null && !this.applicationProperties.getSystem().getCorsAllowedOrigins().isEmpty();
        if (isTauriMode) {
            logger.info("Tauri mode detected - enabling CORS for Tauri protocols (v1 and v2)");
            registry.addMapping("/**").allowedOriginPatterns(new String[]{"tauri://localhost", "http://tauri.localhost", "https://tauri.localhost"}).allowedMethods(new String[]{"GET", "POST", "PUT", "PATCH", "DELETE", "OPTIONS"}).allowedHeaders(new String[]{"Authorization", "Content-Type", "X-Requested-With", "Accept", "Origin", "X-API-KEY", "X-CSRF-TOKEN", "X-XSRF-TOKEN", "X-Browser-Id"}).exposedHeaders(new String[]{"WWW-Authenticate", "X-Total-Count", "X-Page-Number", "X-Page-Size", "Content-Disposition", "Content-Type"}).allowCredentials(true).maxAge(3600L);
        } else if (hasConfiguredOrigins) {
            logger.info("Configuring CORS with allowed origins: {}", (Object)this.applicationProperties.getSystem().getCorsAllowedOrigins());
            String[] allowedOrigins = this.applicationProperties.getSystem().getCorsAllowedOrigins().toArray(new String[0]);
            registry.addMapping("/**").allowedOriginPatterns(allowedOrigins).allowedMethods(new String[]{"GET", "POST", "PUT", "PATCH", "DELETE", "OPTIONS"}).allowedHeaders(new String[]{"Authorization", "Content-Type", "X-Requested-With", "Accept", "Origin", "X-API-KEY", "X-CSRF-TOKEN", "X-XSRF-TOKEN", "X-Browser-Id"}).exposedHeaders(new String[]{"WWW-Authenticate", "X-Total-Count", "X-Page-Number", "X-Page-Size", "Content-Disposition", "Content-Type"}).allowCredentials(true).maxAge(3600L);
        } else {
            logger.info("No CORS allowed origins configured in settings.yml (system.corsAllowedOrigins); allowing all origins.");
            registry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "PUT", "PATCH", "DELETE", "OPTIONS"}).allowedHeaders(new String[]{"Authorization", "Content-Type", "X-Requested-With", "Accept", "Origin", "X-API-KEY", "X-CSRF-TOKEN", "X-XSRF-TOKEN", "X-Browser-Id"}).exposedHeaders(new String[]{"WWW-Authenticate", "X-Total-Count", "X-Page-Number", "X-Page-Size", "Content-Disposition", "Content-Type"}).allowCredentials(true).maxAge(3600L);
        }
    }

    @Generated
    public WebMvcConfig(EndpointInterceptor endpointInterceptor, ApplicationProperties applicationProperties) {
        this.endpointInterceptor = endpointInterceptor;
        this.applicationProperties = applicationProperties;
    }
}

