/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Optional;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import stirling.software.SPDF.model.json.PdfJsonMetadata;

@Service
public class PdfJsonMetadataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfJsonMetadataService.class);

    public PdfJsonMetadata extractMetadata(PDDocument document) {
        PdfJsonMetadata metadata = new PdfJsonMetadata();
        PDDocumentInformation info = document.getDocumentInformation();
        if (info != null) {
            metadata.setTitle(info.getTitle());
            metadata.setAuthor(info.getAuthor());
            metadata.setSubject(info.getSubject());
            metadata.setKeywords(info.getKeywords());
            metadata.setCreator(info.getCreator());
            metadata.setProducer(info.getProducer());
            metadata.setCreationDate(this.formatCalendar(info.getCreationDate()));
            metadata.setModificationDate(this.formatCalendar(info.getModificationDate()));
            metadata.setTrapped(info.getTrapped());
        }
        metadata.setNumberOfPages(Integer.valueOf(document.getNumberOfPages()));
        return metadata;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String extractXmpMetadata(PDDocument document) {
        if (document.getDocumentCatalog() == null) {
            return null;
        }
        PDMetadata metadata = document.getDocumentCatalog().getMetadata();
        if (metadata == null) {
            return null;
        }
        try (COSInputStream inputStream = metadata.createInputStream();){
            byte[] data;
            ByteArrayOutputStream baos;
            block17: {
                String string;
                baos = new ByteArrayOutputStream();
                try {
                    inputStream.transferTo(baos);
                    data = baos.toByteArray();
                    if (data.length != 0) break block17;
                    string = null;
                }
                catch (Throwable throwable) {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                baos.close();
                return string;
            }
            String string = Base64.getEncoder().encodeToString(data);
            baos.close();
            return string;
        }
        catch (IOException ex) {
            log.debug("Failed to extract XMP metadata: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public void applyMetadata(PDDocument document, PdfJsonMetadata metadata) {
        if (metadata == null) {
            return;
        }
        PDDocumentInformation info = document.getDocumentInformation();
        info.setTitle(metadata.getTitle());
        info.setAuthor(metadata.getAuthor());
        info.setSubject(metadata.getSubject());
        info.setKeywords(metadata.getKeywords());
        info.setCreator(metadata.getCreator());
        info.setProducer(metadata.getProducer());
        if (metadata.getCreationDate() != null) {
            this.parseInstant(metadata.getCreationDate()).ifPresent(instant -> info.setCreationDate(this.toCalendar(instant)));
        }
        if (metadata.getModificationDate() != null) {
            this.parseInstant(metadata.getModificationDate()).ifPresent(instant -> info.setModificationDate(this.toCalendar(instant)));
        }
        info.setTrapped(metadata.getTrapped());
    }

    public void applyXmpMetadata(PDDocument document, String base64) {
        if (base64 == null || base64.isBlank()) {
            return;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64));){
            PDMetadata metadata = new PDMetadata(document, (InputStream)inputStream);
            document.getDocumentCatalog().setMetadata(metadata);
        }
        catch (IOException | IllegalArgumentException ex) {
            log.debug("Failed to apply XMP metadata: {}", (Object)ex.getMessage());
        }
    }

    private String formatCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.toInstant().toString();
    }

    private Optional<Instant> parseInstant(String value) {
        try {
            return Optional.of(Instant.parse(value));
        }
        catch (DateTimeParseException ex) {
            log.warn("Failed to parse instant '{}': {}", (Object)value, (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private Calendar toCalendar(Instant instant) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(instant.toEpochMilli());
        return calendar;
    }
}

