/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;

@Service
public class PdfJsonFontService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfJsonFontService.class);
    private final TempFileManager tempFileManager;
    @Value(value="${stirling.pdf.json.cff-converter.enabled:true}")
    private boolean cffConversionEnabled;
    @Value(value="${stirling.pdf.json.cff-converter.method:python}")
    private String cffConverterMethod;
    @Value(value="${stirling.pdf.json.cff-converter.python-command:/opt/venv/bin/python3}")
    private String pythonCommand;
    @Value(value="${stirling.pdf.json.cff-converter.python-script:/scripts/convert_cff_to_ttf.py}")
    private String pythonScript;
    @Value(value="${stirling.pdf.json.cff-converter.fontforge-command:fontforge}")
    private String fontforgeCommand;
    private volatile boolean pythonCffConverterAvailable;
    private volatile boolean fontForgeCffConverterAvailable;

    @PostConstruct
    private void initialiseCffConverterAvailability() {
        if (!this.cffConversionEnabled) {
            log.warn("[FONT-DEBUG] CFF conversion is DISABLED in configuration");
            this.pythonCffConverterAvailable = false;
            this.fontForgeCffConverterAvailable = false;
            return;
        }
        log.info("[FONT-DEBUG] CFF conversion enabled, checking tool availability...");
        this.pythonCffConverterAvailable = this.isCommandAvailable(this.pythonCommand);
        if (!this.pythonCffConverterAvailable) {
            log.warn("[FONT-DEBUG] Python command '{}' not found; Python CFF conversion disabled", (Object)this.pythonCommand);
        } else {
            log.info("[FONT-DEBUG] Python command '{}' is available", (Object)this.pythonCommand);
        }
        this.fontForgeCffConverterAvailable = this.isCommandAvailable(this.fontforgeCommand);
        if (!this.fontForgeCffConverterAvailable) {
            log.warn("[FONT-DEBUG] FontForge command '{}' not found; FontForge CFF conversion disabled", (Object)this.fontforgeCommand);
        } else {
            log.info("[FONT-DEBUG] FontForge command '{}' is available", (Object)this.fontforgeCommand);
        }
        log.info("[FONT-DEBUG] Selected CFF converter method: {}", (Object)this.cffConverterMethod);
    }

    public byte[] convertCffProgramToTrueType(byte[] fontBytes, String toUnicode) {
        if (!this.cffConversionEnabled || fontBytes == null || fontBytes.length == 0) {
            log.warn("[FONT-DEBUG] CFF conversion skipped: enabled={}, bytes={}", (Object)this.cffConversionEnabled, fontBytes == null ? "null" : Integer.valueOf(fontBytes.length));
            return null;
        }
        log.info("[FONT-DEBUG] Converting CFF font: {} bytes, method: {}", (Object)fontBytes.length, (Object)this.cffConverterMethod);
        if ("python".equalsIgnoreCase(this.cffConverterMethod)) {
            if (!this.pythonCffConverterAvailable) {
                log.debug("[FONT-DEBUG] Python CFF converter not available, skipping conversion");
                return null;
            }
            byte[] result = this.convertCffUsingPython(fontBytes, toUnicode);
            log.debug("[FONT-DEBUG] Python conversion result: {}", result == null ? "null" : result.length + " bytes");
            return result;
        }
        if ("fontforge".equalsIgnoreCase(this.cffConverterMethod)) {
            if (!this.fontForgeCffConverterAvailable) {
                log.debug("[FONT-DEBUG] FontForge CFF converter not available, skipping conversion");
                return null;
            }
            byte[] result = this.convertCffUsingFontForge(fontBytes);
            log.debug("[FONT-DEBUG] FontForge conversion result: {}", result == null ? "null" : result.length + " bytes");
            return result;
        }
        log.debug("[FONT-DEBUG] Unknown CFF converter method: {}, falling back to Python", (Object)this.cffConverterMethod);
        if (!this.pythonCffConverterAvailable) {
            log.debug("[FONT-DEBUG] Python CFF converter not available, skipping conversion");
            return null;
        }
        byte[] result = this.convertCffUsingPython(fontBytes, toUnicode);
        log.debug("[FONT-DEBUG] Python conversion result: {}", result == null ? "null" : result.length + " bytes");
        return result;
    }

    public String detectFontFlavor(byte[] fontBytes) {
        if (fontBytes == null || fontBytes.length < 4) {
            return null;
        }
        int signature = (fontBytes[0] & 0xFF) << 24 | (fontBytes[1] & 0xFF) << 16 | (fontBytes[2] & 0xFF) << 8 | fontBytes[3] & 0xFF;
        if (signature == 65536 || signature == 1953658213) {
            return "ttf";
        }
        if (signature == 0x4F54544F) {
            return "otf";
        }
        if (signature == 1953784678) {
            return "cff";
        }
        return null;
    }

    public String detectTrueTypeFormat(byte[] data) {
        if (data == null || data.length < 4) {
            return null;
        }
        int signature = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        if (signature == 65536) {
            return "ttf";
        }
        if (signature == 0x4F54544F) {
            return "otf";
        }
        if (signature == 1953784678) {
            return "cff";
        }
        return null;
    }

    public String validateFontTables(byte[] fontBytes) {
        if (fontBytes == null || fontBytes.length < 12) {
            return "Font program too small";
        }
        int numTables = (fontBytes[4] & 0xFF) << 8 | fontBytes[5] & 0xFF;
        if (numTables <= 0 || numTables > 512) {
            return "Invalid numTables: " + numTables;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private byte[] convertCffUsingPython(byte[] fontBytes, String toUnicode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 13 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] convertCffUsingFontForge(byte[] fontBytes) {
        if (!this.fontForgeCffConverterAvailable) {
            log.debug("FontForge CFF converter not available");
            return null;
        }
        try (TempFile inputFile = new TempFile(this.tempFileManager, ".cff");){
            byte[] data;
            TempFile outputFile;
            block22: {
                block21: {
                    block20: {
                        byte[] byArray;
                        outputFile = new TempFile(this.tempFileManager, ".ttf");
                        try {
                            Files.write(inputFile.getPath(), fontBytes, new OpenOption[0]);
                            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.CFF_CONVERTER).runCommandWithOutputHandling(Arrays.asList(this.fontforgeCommand, "-lang=ff", "-c", "Open($1); ScaleToEm(1000); SelectWorthOutputting(); SetFontOrder(2); Reencode(\"unicode\"); RoundToInt(); RemoveOverlap(); Simplify(); CorrectDirection(); Generate($2, \"\", 4+16+32); Close(); Quit()", inputFile.getAbsolutePath(), outputFile.getAbsolutePath()));
                            if (result.getRc() == 0) break block20;
                            log.warn("FontForge CFF conversion failed: {}", (Object)result.getRc());
                            byArray = null;
                        }
                        catch (Throwable throwable) {
                            try {
                                outputFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        outputFile.close();
                        return byArray;
                    }
                    if (Files.exists(outputFile.getPath(), new LinkOption[0])) break block21;
                    log.warn("FontForge CFF conversion produced no output");
                    byte[] byArray = null;
                    outputFile.close();
                    return byArray;
                }
                data = Files.readAllBytes(outputFile.getPath());
                if (data.length != 0) break block22;
                log.warn("FontForge CFF conversion returned empty output");
                byte[] byArray = null;
                outputFile.close();
                return byArray;
            }
            byte[] byArray = data;
            outputFile.close();
            return byArray;
        }
        catch (IOException | InterruptedException ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.warn("FontForge CFF conversion failed: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private boolean isCommandAvailable(String command) {
        if (command == null || command.isBlank()) {
            return false;
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
                processBuilder.command("where", command);
            } else {
                processBuilder.command("which", command);
            }
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            log.debug("Error checking for command {}: {}", (Object)command, (Object)e.getMessage());
            return false;
        }
    }

    private String[] buildPythonCommand(String input, String output, String toUnicode) {
        if (toUnicode != null) {
            return new String[]{this.pythonCommand, this.pythonScript, "--input", input, "--output", output, "--to-unicode", toUnicode};
        }
        return new String[]{this.pythonCommand, this.pythonScript, "--input", input, "--output", output};
    }

    @Generated
    public PdfJsonFontService(TempFileManager tempFileManager) {
        this.tempFileManager = tempFileManager;
    }

    @Generated
    public boolean isCffConversionEnabled() {
        return this.cffConversionEnabled;
    }

    @Generated
    public String getCffConverterMethod() {
        return this.cffConverterMethod;
    }
}

