/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.general;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.common.model.api.PDFFile;

public class OverlayPdfsRequest
extends PDFFile {
    @Schema(description="An array of PDF files to be used as overlays on the base PDF. The order in these files is applied based on the selected mode.", requiredMode=Schema.RequiredMode.REQUIRED)
    private MultipartFile[] overlayFiles;
    @Schema(description="The mode of overlaying: 'SequentialOverlay' for sequential application, 'InterleavedOverlay' for round-robin application, 'FixedRepeatOverlay' for fixed repetition based on provided counts", allowableValues={"SequentialOverlay", "InterleavedOverlay", "FixedRepeatOverlay"}, requiredMode=Schema.RequiredMode.REQUIRED)
    private String overlayMode;
    @Schema(description="An array of integers specifying the number of times each corresponding overlay file should be applied in the 'FixedRepeatOverlay' mode. This should match the length of the overlayFiles array.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private int[] counts;
    @Schema(description="Overlay position 0 is Foregound, 1 is Background", allowableValues={"0", "1"}, requiredMode=Schema.RequiredMode.REQUIRED, type="number")
    private int overlayPosition;

    @Generated
    public OverlayPdfsRequest() {
    }

    @Generated
    public MultipartFile[] getOverlayFiles() {
        return this.overlayFiles;
    }

    @Generated
    public String getOverlayMode() {
        return this.overlayMode;
    }

    @Generated
    public int[] getCounts() {
        return this.counts;
    }

    @Generated
    public int getOverlayPosition() {
        return this.overlayPosition;
    }

    @Generated
    public void setOverlayFiles(MultipartFile[] overlayFiles) {
        this.overlayFiles = overlayFiles;
    }

    @Generated
    public void setOverlayMode(String overlayMode) {
        this.overlayMode = overlayMode;
    }

    @Generated
    public void setCounts(int[] counts) {
        this.counts = counts;
    }

    @Generated
    public void setOverlayPosition(int overlayPosition) {
        this.overlayPosition = overlayPosition;
    }

    @Generated
    public String toString() {
        return "OverlayPdfsRequest(overlayFiles=" + Arrays.deepToString(this.getOverlayFiles()) + ", overlayMode=" + this.getOverlayMode() + ", counts=" + Arrays.toString(this.getCounts()) + ", overlayPosition=" + this.getOverlayPosition() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OverlayPdfsRequest)) {
            return false;
        }
        OverlayPdfsRequest other = (OverlayPdfsRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getOverlayPosition() != other.getOverlayPosition()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOverlayFiles(), other.getOverlayFiles())) {
            return false;
        }
        String this$overlayMode = this.getOverlayMode();
        String other$overlayMode = other.getOverlayMode();
        if (this$overlayMode == null ? other$overlayMode != null : !this$overlayMode.equals(other$overlayMode)) {
            return false;
        }
        return Arrays.equals(this.getCounts(), other.getCounts());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OverlayPdfsRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getOverlayPosition();
        result = result * 59 + Arrays.deepHashCode(this.getOverlayFiles());
        String $overlayMode = this.getOverlayMode();
        result = result * 59 + ($overlayMode == null ? 43 : $overlayMode.hashCode());
        result = result * 59 + Arrays.hashCode(this.getCounts());
        return result;
    }
}

