/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF;

import io.github.pixee.security.SystemCommand;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import stirling.software.common.configuration.AppConfig;
import stirling.software.common.configuration.ConfigInitializer;
import stirling.software.common.configuration.InstallationPathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.util.UrlUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableScheduling
@SpringBootApplication(scanBasePackages={"stirling.software.SPDF", "stirling.software.common", "stirling.software.proprietary"})
public class SPDFApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SPDFApplication.class);
    private static String serverPortStatic;
    private static String baseUrlStatic;
    private static String contextPathStatic;
    private final AppConfig appConfig;
    private final Environment env;
    private final ApplicationProperties applicationProperties;

    public SPDFApplication(AppConfig appConfig, Environment env, ApplicationProperties applicationProperties) {
        this.appConfig = appConfig;
        this.env = env;
        this.applicationProperties = applicationProperties;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        SpringApplication app = new SpringApplication(new Class[]{SPDFApplication.class});
        Properties props = new Properties();
        if (Boolean.parseBoolean(System.getProperty("STIRLING_PDF_DESKTOP_UI", "false"))) {
            System.setProperty("java.awt.headless", "false");
            app.setHeadless(false);
            props.put("java.awt.headless", "false");
            props.put("spring.main.web-application-type", "servlet");
            int desiredPort = 8080;
            String port = UrlUtils.findAvailablePort((int)desiredPort);
            props.put("server.port", port);
            System.setProperty("server.port", port);
            log.info("Desktop UI mode: Using port {}", (Object)port);
        }
        app.setAdditionalProfiles(SPDFApplication.getActiveProfile((String[])args));
        ConfigInitializer initializer = new ConfigInitializer();
        try {
            initializer.ensureConfigExists();
        }
        catch (IOException | URISyntaxException e) {
            log.error("Error initialising configuration", (Throwable)e);
        }
        HashMap<String, Object> propertyFiles = new HashMap<String, Object>();
        Path settingsPath = Paths.get(InstallationPathConfig.getSettingsPath(), new String[0]);
        log.info("Settings file: {}", (Object)settingsPath.toString());
        if (Files.exists(settingsPath, new LinkOption[0])) {
            propertyFiles.put("spring.config.additional-location", "file:" + settingsPath.toString());
        } else {
            log.warn("External configuration file '{}' does not exist.", (Object)settingsPath.toString());
        }
        Path customSettingsPath = Paths.get(InstallationPathConfig.getCustomSettingsPath(), new String[0]);
        log.info("Custom settings file: {}", (Object)customSettingsPath.toString());
        if (Files.exists(customSettingsPath, new LinkOption[0])) {
            Object existingLocation = propertyFiles.getOrDefault("spring.config.additional-location", "");
            if (!((String)existingLocation).isEmpty()) {
                existingLocation = (String)existingLocation + ",";
            }
            propertyFiles.put("spring.config.additional-location", (String)existingLocation + "file:" + customSettingsPath.toString());
        } else {
            log.warn("Custom configuration file '{}' does not exist.", (Object)customSettingsPath.toString());
        }
        Properties finalProps = new Properties();
        if (!propertyFiles.isEmpty()) {
            finalProps.putAll(Collections.singletonMap("spring.config.additional-location", (String)propertyFiles.get("spring.config.additional-location")));
        }
        if (!props.isEmpty()) {
            finalProps.putAll((Map<?, ?>)props);
        }
        app.setDefaultProperties(finalProps);
        app.run(args);
        try {
            Files.createDirectories(Path.of(InstallationPathConfig.getTemplatesPath(), new String[0]), new FileAttribute[0]);
            Files.createDirectories(Path.of(InstallationPathConfig.getStaticPath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Error creating directories: {}", (Object)e.getMessage());
        }
        SPDFApplication.printStartupLogs();
    }

    @PostConstruct
    public void init() {
        String browserOpenEnv;
        boolean browserOpen;
        String baseUrl = this.appConfig.getBaseUrl();
        String contextPath = this.appConfig.getContextPath();
        String serverPort = this.appConfig.getServerPort();
        baseUrlStatic = baseUrl;
        contextPathStatic = contextPath;
        serverPortStatic = serverPort;
        String url = baseUrl + ":" + SPDFApplication.getStaticPort() + contextPath;
        if (Boolean.parseBoolean(System.getProperty("STIRLING_PDF_TAURI_MODE", "false"))) {
            String parentPid = System.getenv("TAURI_PARENT_PID");
            log.info("Running in Tauri mode. Parent process PID: {}", (Object)(parentPid != null ? parentPid : "not set"));
        }
        if (Boolean.parseBoolean(System.getProperty("STIRLING_PDF_DESKTOP_UI", "false"))) {
            log.info("Desktop UI mode enabled, but WebBrowser functionality has been removed");
        }
        boolean bl = browserOpen = (browserOpenEnv = this.env.getProperty("BROWSER_OPEN")) != null && "true".equalsIgnoreCase(browserOpenEnv);
        if (browserOpen) {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                Runtime rt = Runtime.getRuntime();
                if (os.contains("win")) {
                    SystemCommand.runCommand((Runtime)rt, (String)("rundll32 url.dll,FileProtocolHandler " + url));
                } else if (os.contains("mac")) {
                    SystemCommand.runCommand((Runtime)rt, (String)("open " + url));
                } else if (os.contains("nix") || os.contains("nux")) {
                    SystemCommand.runCommand((Runtime)rt, (String)("xdg-open " + url));
                }
            }
            catch (IOException e) {
                log.error("Error opening browser: {}", (Object)e.getMessage());
            }
        }
    }

    public static void setServerPortStatic(String port) {
        serverPortStatic = "auto".equalsIgnoreCase(port) ? "0" : port;
    }

    @PreDestroy
    public void cleanup() {
    }

    @EventListener
    public void onWebServerInitialized(WebServerInitializedEvent event) {
        int actualPort = event.getWebServer().getPort();
        serverPortStatic = String.valueOf(actualPort);
        log.info("Stirling-PDF running on port: {}", (Object)actualPort);
    }

    private static void printStartupLogs() {
        log.info("Stirling-PDF Started.");
        String url = baseUrlStatic + ":" + SPDFApplication.getStaticPort() + contextPathStatic;
        log.info("Navigate to {}", (Object)url);
    }

    private static String[] getActiveProfile(String[] args) {
        if (args != null) {
            for (String arg : args) {
                String[] provided;
                if (!arg.startsWith("--spring.profiles.active=") || (provided = arg.substring(arg.indexOf(61) + 1).split(",")).length <= 0) continue;
                return provided;
            }
        }
        if (SPDFApplication.isClassPresent((String)"stirling.software.proprietary.security.configuration.SecurityConfiguration")) {
            log.info("Additional features in jar");
            return new String[]{"security"};
        }
        log.info("Without additional features in jar");
        return new String[]{"default"};
    }

    private static boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, SPDFApplication.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String getStaticBaseUrl() {
        return baseUrlStatic;
    }

    public static String getStaticPort() {
        return serverPortStatic;
    }

    public static String getStaticContextPath() {
        return contextPathStatic;
    }
}

