/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.converters.UrlToPdfRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

@ConvertApi
public class ConvertWebsiteToPDF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertWebsiteToPDF.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final RuntimePathConfig runtimePathConfig;
    private final ApplicationProperties applicationProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/url/pdf"})
    @StandardPdfResponse
    @Operation(summary="Convert a URL to a PDF", description="This endpoint fetches content from a URL and converts it to a PDF format. Input:N/A Output:PDF Type:SISO")
    public ResponseEntity<?> urlToPdf(@ModelAttribute UrlToPdfRequest request) throws IOException, InterruptedException {
        String URL2 = request.getUrlInput();
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path("/url-to-pdf");
        URI location = null;
        HttpStatus status = HttpStatus.SEE_OTHER;
        if (!this.applicationProperties.getSystem().getEnableUrlToPDF().booleanValue()) {
            location = uriComponentsBuilder.queryParam("error", new Object[]{"error.endpointDisabled"}).build().toUri();
        } else {
            boolean patternValid = RegexPatternUtils.getInstance().getHttpUrlPattern().matcher(URL2).matches();
            boolean generalValid = GeneralUtils.isValidURL((String)URL2);
            if (!patternValid && !generalValid) {
                location = uriComponentsBuilder.queryParam("error", new Object[]{"error.invalidUrlFormat"}).build().toUri();
            } else if (!GeneralUtils.isURLReachable((String)URL2)) {
                location = uriComponentsBuilder.queryParam("error", new Object[]{"error.urlNotReachable"}).build().toUri();
            }
        }
        if (location != null) {
            log.info("Redirecting to: {}", (Object)location.toString());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).location(location)).build();
        }
        Path tempOutputFile = null;
        PDDocument doc = null;
        try {
            tempOutputFile = Files.createTempFile("output_", ".pdf", new FileAttribute[0]);
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.runtimePathConfig.getWeasyPrintPath());
            command.add(URL2);
            command.add("--pdf-forms");
            command.add(tempOutputFile.toString());
            ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.WEASYPRINT).runCommandWithOutputHandling(command);
            doc = this.pdfDocumentFactory.load(tempOutputFile.toFile());
            String outputFilename = this.convertURLToFileName(URL2);
            ResponseEntity response = WebResponseUtils.pdfDocToWebResponse((PDDocument)doc, (String)outputFilename);
            if (response == null) {
                ResponseEntity responseEntity = ResponseEntity.ok((Object)new byte[0]);
                return responseEntity;
            }
            ResponseEntity responseEntity = response;
            return responseEntity;
        }
        finally {
            if (tempOutputFile != null) {
                try {
                    Files.deleteIfExists(tempOutputFile);
                }
                catch (IOException e) {
                    log.error("Error deleting temporary output file", (Throwable)e);
                }
            }
        }
    }

    private String convertURLToFileName(String url) {
        String safeName = GeneralUtils.convertToFileName((String)url);
        if (safeName == null || safeName.isBlank()) {
            try {
                URI uri = URI.create(url);
                String hostPart = uri.getHost();
                if (hostPart == null || hostPart.isBlank()) {
                    hostPart = "document";
                }
                safeName = RegexPatternUtils.getInstance().getNonAlnumUnderscorePattern().matcher(hostPart).replaceAll("_");
            }
            catch (Exception e) {
                safeName = "document";
            }
        }
        RegexPatternUtils patterns = RegexPatternUtils.getInstance();
        safeName = patterns.getNonAlnumUnderscorePattern().matcher(safeName).replaceAll("_");
        safeName = patterns.getMultipleUnderscoresPattern().matcher(safeName).replaceAll("_");
        safeName = patterns.getLeadingUnderscoresPattern().matcher(safeName).replaceAll("");
        safeName = patterns.getTrailingUnderscoresPattern().matcher(safeName).replaceAll("");
        if (safeName.isEmpty()) {
            safeName = "document";
        }
        if (safeName.length() > 50) {
            safeName = safeName.substring(0, 50);
        }
        return GeneralUtils.generateFilename((String)safeName, (String)".pdf");
    }

    @Generated
    public ConvertWebsiteToPDF(CustomPDFDocumentFactory pdfDocumentFactory, RuntimePathConfig runtimePathConfig, ApplicationProperties applicationProperties) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.runtimePathConfig = runtimePathConfig;
        this.applicationProperties = applicationProperties;
    }
}

