/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.service.PdfImageRemovalService;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class PdfImageRemovalController {
    private final PdfImageRemovalService pdfImageRemovalService;
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/remove-image-pdf"})
    @StandardPdfResponse
    @Operation(summary="Remove images from file to reduce the file size.", description="This endpoint remove images from file to reduce the file size.Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> removeImages(@ModelAttribute PDFFile file) throws IOException {
        PDDocument document = this.pdfDocumentFactory.load(file);
        PDDocument modifiedDocument = this.pdfImageRemovalService.removeImagesFromPdf(document);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        modifiedDocument.save((OutputStream)outputStream);
        modifiedDocument.close();
        String mergedFileName = GeneralUtils.generateFilename((String)file.getFileInput().getOriginalFilename(), (String)"_images_removed.pdf");
        return WebResponseUtils.bytesToWebResponse((byte[])outputStream.toByteArray(), (String)mergedFileName);
    }

    @Generated
    public PdfImageRemovalController(PdfImageRemovalService pdfImageRemovalService, CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfImageRemovalService = pdfImageRemovalService;
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

