/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import io.micrometer.common.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.util.GeneralUtils;

@Component
@Order(value=-2147483647)
public class InitialSetup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitialSetup.class);
    private final ApplicationProperties applicationProperties;
    private static boolean isNewServer = false;

    @PostConstruct
    public void init() throws IOException {
        this.initUUIDKey();
        this.initSecretKey();
        this.initEnableCSRFSecurity();
        this.initLegalUrls();
        this.initSetAppVersion();
        GeneralUtils.extractPipeline();
    }

    public void initUUIDKey() throws IOException {
        String uuid = this.applicationProperties.getAutomaticallyGenerated().getUUID();
        if (!GeneralUtils.isValidUUID((String)uuid)) {
            uuid = UUID.randomUUID().toString();
            GeneralUtils.saveKeyToSettings((String)"AutomaticallyGenerated.UUID", (Object)uuid);
            this.applicationProperties.getAutomaticallyGenerated().setUUID(uuid);
        }
    }

    public void initSecretKey() throws IOException {
        String secretKey = this.applicationProperties.getAutomaticallyGenerated().getKey();
        if (!GeneralUtils.isValidUUID((String)secretKey)) {
            secretKey = UUID.randomUUID().toString();
            GeneralUtils.saveKeyToSettings((String)"AutomaticallyGenerated.key", (Object)secretKey);
            this.applicationProperties.getAutomaticallyGenerated().setKey(secretKey);
        }
    }

    public void initEnableCSRFSecurity() throws IOException {
        Boolean csrf;
        if (GeneralUtils.isVersionHigher((String)"0.46.0", (String)this.applicationProperties.getAutomaticallyGenerated().getAppVersion()) && !(csrf = this.applicationProperties.getSecurity().getCsrfDisabled()).booleanValue()) {
            GeneralUtils.saveKeyToSettings((String)"security.csrfDisabled", (Object)false);
            GeneralUtils.saveKeyToSettings((String)"system.enableAnalytics", (Object)true);
            this.applicationProperties.getSecurity().setCsrfDisabled(Boolean.valueOf(false));
        }
    }

    public void initLegalUrls() throws IOException {
        String privacyUrl;
        String termsUrl = this.applicationProperties.getLegal().getTermsAndConditions();
        if (StringUtils.isEmpty((String)termsUrl)) {
            String defaultTermsUrl = "https://www.stirlingpdf.com/terms";
            GeneralUtils.saveKeyToSettings((String)"legal.termsAndConditions", (Object)defaultTermsUrl);
            this.applicationProperties.getLegal().setTermsAndConditions(defaultTermsUrl);
        }
        if (StringUtils.isEmpty((String)(privacyUrl = this.applicationProperties.getLegal().getPrivacyPolicy()))) {
            String defaultPrivacyUrl = "https://www.stirlingpdf.com/privacy-policy";
            GeneralUtils.saveKeyToSettings((String)"legal.privacyPolicy", (Object)defaultPrivacyUrl);
            this.applicationProperties.getLegal().setPrivacyPolicy(defaultPrivacyUrl);
        }
    }

    public void initSetAppVersion() throws IOException {
        String existingVersion = this.applicationProperties.getAutomaticallyGenerated().getAppVersion();
        isNewServer = existingVersion == null || existingVersion.isEmpty() || existingVersion.equals("0.0.0");
        String appVersion = "0.0.0";
        ClassPathResource resource = new ClassPathResource("version.properties");
        Properties props = new Properties();
        try {
            props.load(resource.getInputStream());
            appVersion = props.getProperty("version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GeneralUtils.saveKeyToSettings((String)"AutomaticallyGenerated.appVersion", (Object)appVersion);
        this.applicationProperties.getAutomaticallyGenerated().setAppVersion(appVersion);
    }

    public static boolean isNewServer() {
        return isNewServer;
    }

    @Generated
    public InitialSetup(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }
}

