/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.misc.AddAttachmentRequest;
import stirling.software.SPDF.service.AttachmentServiceInterface;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class AttachmentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final AttachmentServiceInterface pdfAttachmentService;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/add-attachments"})
    @StandardPdfResponse
    @Operation(summary="Add attachments to PDF", description="This endpoint adds attachments to a PDF. Input:PDF, Output:PDF Type:MISO")
    public ResponseEntity<byte[]> addAttachments(@ModelAttribute AddAttachmentRequest request) throws IOException {
        MultipartFile fileInput = request.getFileInput();
        List attachments = request.getAttachments();
        PDDocument document = this.pdfAttachmentService.addAttachment(this.pdfDocumentFactory.load(fileInput, false), attachments);
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)Filenames.toSimpleFileName((String)fileInput.getOriginalFilename()), (String)"_with_attachments.pdf"));
    }

    @Generated
    public AttachmentController(CustomPDFDocumentFactory pdfDocumentFactory, AttachmentServiceInterface pdfAttachmentService) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.pdfAttachmentService = pdfAttachmentService;
    }
}

