/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Map;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springframework.stereotype.Component;

@Component
public class GlobalErrorResponseCustomizer
implements GlobalOpenApiCustomizer {
    public void customise(OpenAPI openApi) {
        if (openApi.getPaths() == null) {
            return;
        }
        openApi.getPaths().forEach((path, pathItem) -> {
            if (path.startsWith("/api/v1/")) {
                this.addErrorResponsesToPathItem(pathItem);
            }
        });
    }

    private void addErrorResponsesToPathItem(PathItem pathItem) {
        if (pathItem.getPost() != null) {
            this.addStandardErrorResponses(pathItem.getPost());
        }
        if (pathItem.getPut() != null) {
            this.addStandardErrorResponses(pathItem.getPut());
        }
        if (pathItem.getPatch() != null) {
            this.addStandardErrorResponses(pathItem.getPatch());
        }
        if (pathItem.getDelete() != null) {
            this.addStandardErrorResponses(pathItem.getDelete());
        }
        if (pathItem.getGet() != null) {
            this.addStandardErrorResponses(pathItem.getGet());
        }
    }

    private void addStandardErrorResponses(Operation operation) {
        if (operation.getResponses() == null) {
            return;
        }
        if (!operation.getResponses().containsKey((Object)"400")) {
            operation.getResponses().addApiResponse("400", this.create400Response());
        }
        if (!operation.getResponses().containsKey((Object)"413")) {
            operation.getResponses().addApiResponse("413", this.create413Response());
        }
        if (!operation.getResponses().containsKey((Object)"422")) {
            operation.getResponses().addApiResponse("422", this.create422Response());
        }
        if (!operation.getResponses().containsKey((Object)"500")) {
            operation.getResponses().addApiResponse("500", this.create500Response());
        }
    }

    private ApiResponse create400Response() {
        return new ApiResponse().description("Bad request - Invalid input parameters, unsupported format, or corrupted file").content(new Content().addMediaType("application/json", new MediaType().schema(this.createErrorSchema(400, "Invalid input parameters or corrupted file", "/api/v1/example/endpoint")).example(this.createErrorExample(400, "Invalid input parameters or corrupted file", "/api/v1/example/endpoint"))));
    }

    private ApiResponse create413Response() {
        return new ApiResponse().description("Payload too large - File exceeds maximum allowed size").content(new Content().addMediaType("application/json", new MediaType().schema(this.createErrorSchema(413, "File size exceeds maximum allowed limit", "/api/v1/example/endpoint")).example(this.createErrorExample(413, "File size exceeds maximum allowed limit", "/api/v1/example/endpoint"))));
    }

    private ApiResponse create422Response() {
        return new ApiResponse().description("Unprocessable entity - File is valid but cannot be processed").content(new Content().addMediaType("application/json", new MediaType().schema(this.createErrorSchema(422, "File is valid but cannot be processed", "/api/v1/example/endpoint")).example(this.createErrorExample(422, "File is valid but cannot be processed", "/api/v1/example/endpoint"))));
    }

    private ApiResponse create500Response() {
        return new ApiResponse().description("Internal server error - Unexpected error during processing").content(new Content().addMediaType("application/json", new MediaType().schema(this.createErrorSchema(500, "Unexpected error during processing", "/api/v1/example/endpoint")).example(this.createErrorExample(500, "Unexpected error during processing", "/api/v1/example/endpoint"))));
    }

    private Schema<?> createErrorSchema(int status, String message, String path) {
        return new Schema().type("object").addProperty("status", new Schema().type("integer").example((Object)status)).addProperty("error", new Schema().type("string").example((Object)this.getErrorType(status))).addProperty("message", new Schema().type("string").example((Object)message)).addProperty("timestamp", new Schema().type("string").format("date-time").example((Object)"2024-01-15T10:30:00Z")).addProperty("path", new Schema().type("string").example((Object)path));
    }

    private Object createErrorExample(int status, String message, String path) {
        return Map.of("status", status, "error", this.getErrorType(status), "message", message, "timestamp", "2024-01-15T10:30:00Z", "path", path);
    }

    private String getErrorType(int status) {
        return switch (status) {
            case 400 -> "Bad Request";
            case 413 -> "Payload Too Large";
            case 422 -> "Unprocessable Entity";
            case 500 -> "Internal Server Error";
            default -> "Error";
        };
    }
}

