/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.utils.text;

import lombok.Generated;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stirling.software.SPDF.utils.text.TextEncodingHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class WidthCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WidthCalculator.class);
    private static final int FONT_SCALE_FACTOR = 1000;

    public static float calculateAccurateWidth(PDFont font, String text, float fontSize) {
        if (font == null || text == null || text.isEmpty() || fontSize <= 0.0f) {
            return 0.0f;
        }
        if (!TextEncodingHelper.canEncodeCharacters((PDFont)font, (String)text)) {
            log.debug("Text cannot be encoded by font {}, using fallback width calculation", (Object)font.getName());
            return WidthCalculator.calculateFallbackWidth((PDFont)font, (String)text, (float)fontSize);
        }
        try {
            float rawWidth = font.getStringWidth(text);
            float scaledWidth = rawWidth / 1000.0f * fontSize;
            log.debug("Direct width calculation successful for font {}: {} -> {}", new Object[]{font.getName(), Float.valueOf(rawWidth), Float.valueOf(scaledWidth)});
            return scaledWidth;
        }
        catch (Exception e) {
            log.debug("Direct width calculation failed for font {}: {}", (Object)font.getName(), (Object)e.getMessage());
            return WidthCalculator.calculateWidthWithCharacterIteration((PDFont)font, (String)text, (float)fontSize);
        }
    }

    private static float calculateWidthWithCharacterIteration(PDFont font, String text, float fontSize) {
        try {
            float totalWidth = 0.0f;
            for (int i = 0; i < text.length(); ++i) {
                String character = text.substring(i, i + 1);
                try {
                    byte[] encoded = font.encode(character);
                    if (encoded.length > 0) {
                        int glyphCode = encoded[0] & 0xFF;
                        float glyphWidth = font.getWidth(glyphCode);
                        if (glyphWidth == 0.0f) {
                            try {
                                glyphWidth = font.getWidthFromFont(glyphCode);
                            }
                            catch (Exception e2) {
                                glyphWidth = font.getAverageFontWidth();
                            }
                        }
                        totalWidth += glyphWidth / 1000.0f * fontSize;
                        continue;
                    }
                    totalWidth += font.getAverageFontWidth() / 1000.0f * fontSize;
                    continue;
                }
                catch (Exception e2) {
                    totalWidth += font.getAverageFontWidth() / 1000.0f * fontSize;
                }
            }
            log.debug("Character iteration width calculation: {}", (Object)Float.valueOf(totalWidth));
            return totalWidth;
        }
        catch (Exception e) {
            log.debug("Character iteration failed: {}", (Object)e.getMessage());
            return WidthCalculator.calculateFallbackWidth((PDFont)font, (String)text, (float)fontSize);
        }
    }

    private static float calculateFallbackWidth(PDFont font, String text, float fontSize) {
        try {
            if (font.getFontDescriptor() != null && font.getFontDescriptor().getFontBoundingBox() != null) {
                PDRectangle bbox = font.getFontDescriptor().getFontBoundingBox();
                float avgCharWidth = bbox.getWidth() / 1000.0f * 0.6f;
                float fallbackWidth = (float)text.length() * avgCharWidth * fontSize;
                log.debug("Bounding box fallback width: {}", (Object)Float.valueOf(fallbackWidth));
                return fallbackWidth;
            }
            float avgWidth = font.getAverageFontWidth();
            float fallbackWidth = (float)text.length() * avgWidth / 1000.0f * fontSize;
            log.debug("Average width fallback: {}", (Object)Float.valueOf(fallbackWidth));
            return fallbackWidth;
        }
        catch (Exception e) {
            float conservativeWidth = (float)text.length() * 0.5f * fontSize;
            log.debug("Conservative fallback width for font {}: {}", (Object)font.getName(), (Object)Float.valueOf(conservativeWidth));
            return conservativeWidth;
        }
    }

    public static boolean isWidthCalculationReliable(PDFont font) {
        if (font == null) {
            return false;
        }
        if (font.isDamaged()) {
            log.debug("Font {} is damaged", (Object)font.getName());
            return false;
        }
        if (!TextEncodingHelper.canCalculateBasicWidths((PDFont)font)) {
            log.debug("Font {} cannot perform basic width calculations", (Object)font.getName());
            return false;
        }
        if (TextEncodingHelper.hasCustomEncoding((PDFont)font)) {
            log.debug("Font {} has custom encoding", (Object)font.getName());
            return false;
        }
        return true;
    }
}

