/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thymeleaf.util.StringUtils;
import stirling.software.SPDF.model.SignatureFile;
import stirling.software.common.configuration.InstallationPathConfig;
import stirling.software.common.util.ExceptionUtils;

@Service
public class SignatureService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignatureService.class);
    private final String SIGNATURE_BASE_PATH = InstallationPathConfig.getSignaturesPath();
    private final String ALL_USERS_FOLDER = "ALL_USERS";

    public boolean hasAccessToFile(String username, String fileName) throws IOException {
        this.validateFileName(fileName);
        Path userPath = Paths.get(this.SIGNATURE_BASE_PATH, username, fileName);
        Path allUsersPath = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS", fileName);
        return Files.exists(userPath, new LinkOption[0]) || Files.exists(allUsersPath, new LinkOption[0]);
    }

    public List<SignatureFile> getAvailableSignatures(String username) {
        Path allUsersFolder;
        Path userFolder;
        ArrayList<SignatureFile> signatures = new ArrayList<SignatureFile>();
        if (!StringUtils.isEmptyOrWhitespace((String)username) && Files.exists(userFolder = Paths.get(this.SIGNATURE_BASE_PATH, username), new LinkOption[0])) {
            try {
                signatures.addAll(this.getSignaturesFromFolder(userFolder, "Personal"));
            }
            catch (IOException e) {
                log.error("Error reading user signatures folder", (Throwable)e);
            }
        }
        if (Files.exists(allUsersFolder = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS"), new LinkOption[0])) {
            try {
                signatures.addAll(this.getSignaturesFromFolder(allUsersFolder, "Shared"));
            }
            catch (IOException e) {
                log.error("Error reading shared signatures folder", (Throwable)e);
            }
        }
        return signatures;
    }

    private List<SignatureFile> getSignaturesFromFolder(Path folder, String category) throws IOException {
        try (Stream<Path> stream = Files.list(folder);){
            List<SignatureFile> list = stream.filter(arg_0 -> this.isImageFile(arg_0)).map(path -> new SignatureFile(path.getFileName().toString(), category)).toList();
            return list;
        }
    }

    public byte[] getSignatureBytes(String username, String fileName) throws IOException {
        this.validateFileName(fileName);
        Path userPath = Paths.get(this.SIGNATURE_BASE_PATH, username, fileName);
        if (Files.exists(userPath, new LinkOption[0])) {
            return Files.readAllBytes(userPath);
        }
        Path allUsersPath = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS", fileName);
        if (Files.exists(allUsersPath, new LinkOption[0])) {
            return Files.readAllBytes(allUsersPath);
        }
        throw new FileNotFoundException("Signature file not found");
    }

    private boolean isImageFile(Path path) {
        String fileName = path.getFileName().toString().toLowerCase(Locale.ROOT);
        return fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".png") || fileName.endsWith(".gif") || fileName.endsWith(".svg");
    }

    private void validateFileName(String fileName) {
        if (fileName.contains("..") || fileName.contains("/") || fileName.contains("\\")) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidFormat", (String)"Invalid {0} format: {1}", (Object[])new Object[]{"filename", fileName});
        }
    }
}

