/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import io.github.pixee.security.BoundedLineReader;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CertificateValidationService {
    private KeyStore trustStore;

    @PostConstruct
    private void initializeTrustStore() throws Exception {
        this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.trustStore.load(null, null);
        this.loadMozillaCertificates();
    }

    private void loadMozillaCertificates() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("/certdata.txt");){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder certData = new StringBuilder();
            boolean inCert = false;
            int certCount = 0;
            while ((line = BoundedLineReader.readLine((Reader)reader, (int)5000000)) != null) {
                if (line.startsWith("CKA_VALUE MULTILINE_OCTAL")) {
                    inCert = true;
                    certData = new StringBuilder();
                    continue;
                }
                if (!inCert) continue;
                if ("END".equals(line)) {
                    inCert = false;
                    byte[] certBytes = this.parseOctalData(certData.toString());
                    if (certBytes == null) continue;
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
                    this.trustStore.setCertificateEntry("mozilla-cert-" + certCount++, cert);
                    continue;
                }
                certData.append(line).append("\n");
            }
        }
    }

    private byte[] parseOctalData(String data) {
        try {
            String[] tokens;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String token : tokens = data.split("\\\\")) {
                if ((token = token.trim()).isEmpty()) continue;
                baos.write(Integer.parseInt(token, 8));
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean validateCertificateChain(X509Certificate cert) {
        try {
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            List<X509Certificate> certList = Collections.singletonList(cert);
            CertPath certPath = cf.generateCertPath(certList);
            HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate trustCert = this.trustStore.getCertificate(aliases.nextElement());
                if (!(trustCert instanceof X509Certificate)) continue;
                X509Certificate x509Cert = (X509Certificate)trustCert;
                anchors.add(new TrustAnchor(x509Cert, null));
            }
            PKIXParameters params = new PKIXParameters(anchors);
            params.setRevocationEnabled(false);
            validator.validate(certPath, params);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean validateTrustStore(X509Certificate cert) {
        try {
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate trustCert = this.trustStore.getCertificate(aliases.nextElement());
                if (!(trustCert instanceof X509Certificate) || !cert.equals(trustCert)) continue;
                return true;
            }
            return false;
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public boolean isRevoked(X509Certificate cert) {
        try {
            cert.checkValidity();
            return false;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            return true;
        }
    }

    public boolean validateCertificateChainWithCustomCert(X509Certificate cert, X509Certificate customCert) {
        try {
            cert.verify(customCert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean validateTrustWithCustomCert(X509Certificate cert, X509Certificate customCert) {
        try {
            return cert.getIssuerX500Principal().equals(customCert.getSubjectX500Principal());
        }
        catch (Exception e) {
            return false;
        }
    }
}

