/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import io.github.pixee.security.Filenames;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PageMode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.service.AttachmentServiceInterface;
import stirling.software.common.util.AttachmentUtils;

@Service
public class AttachmentService
implements AttachmentServiceInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentService.class);
    private static final long DEFAULT_MAX_ATTACHMENT_SIZE_BYTES = 0x3200000L;
    private static final long DEFAULT_MAX_TOTAL_ATTACHMENT_SIZE_BYTES = 0xC800000L;
    private final long maxAttachmentSizeBytes;
    private final long maxTotalAttachmentSizeBytes;

    public AttachmentService() {
        this(0x3200000L, 0xC800000L);
    }

    public AttachmentService(long maxAttachmentSizeBytes, long maxTotalAttachmentSizeBytes) {
        this.maxAttachmentSizeBytes = maxAttachmentSizeBytes;
        this.maxTotalAttachmentSizeBytes = maxTotalAttachmentSizeBytes;
    }

    public PDDocument addAttachment(PDDocument document, List<MultipartFile> attachments) throws IOException {
        HashMap existingNames;
        PDEmbeddedFilesNameTreeNode embeddedFilesTree = this.getEmbeddedFilesTree(document);
        try {
            Map names = embeddedFilesTree.getNames();
            if (names == null) {
                log.debug("No existing embedded files found, creating new names map.");
                existingNames = new HashMap();
            } else {
                existingNames = new HashMap(names);
                log.debug("Embedded files: {}", existingNames.keySet());
            }
        }
        catch (IOException e) {
            log.error("Could not retrieve existing embedded files", (Throwable)e);
            throw e;
        }
        attachments.forEach(attachment -> {
            String filename = attachment.getOriginalFilename();
            try {
                PDEmbeddedFile embeddedFile = new PDEmbeddedFile(document, attachment.getInputStream());
                embeddedFile.setSize((int)attachment.getSize());
                Instant now = Instant.now();
                GregorianCalendar nowCal = GregorianCalendar.from(ZonedDateTime.ofInstant(now, ZoneId.systemDefault()));
                embeddedFile.setCreationDate((Calendar)nowCal);
                embeddedFile.setModDate((Calendar)nowCal);
                String contentType = attachment.getContentType();
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    embeddedFile.setSubtype(contentType);
                }
                PDComplexFileSpecification fileSpecification = new PDComplexFileSpecification();
                fileSpecification.setFile(filename);
                fileSpecification.setFileUnicode(filename);
                fileSpecification.setFileDescription("Embedded attachment: " + filename);
                fileSpecification.setEmbeddedFile(embeddedFile);
                fileSpecification.setEmbeddedFileUnicode(embeddedFile);
                existingNames.put(filename, fileSpecification);
                log.info("Added attachment: {} ({} bytes)", (Object)filename, (Object)attachment.getSize());
            }
            catch (IOException e) {
                log.warn("Failed to create embedded file for attachment: {}", (Object)filename, (Object)e);
            }
        });
        embeddedFilesTree.setNames(existingNames);
        AttachmentUtils.setCatalogViewerPreferences((PDDocument)document, (PageMode)PageMode.USE_ATTACHMENTS);
        return document;
    }

    public Optional<byte[]> extractAttachments(PDDocument document) throws IOException {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        if (catalog == null) {
            return Optional.empty();
        }
        PDDocumentNameDictionary documentNames = catalog.getNames();
        if (documentNames == null) {
            return Optional.empty();
        }
        PDEmbeddedFilesNameTreeNode embeddedFilesTree = documentNames.getEmbeddedFiles();
        if (embeddedFilesTree == null) {
            return Optional.empty();
        }
        LinkedHashMap embeddedFiles = new LinkedHashMap();
        this.collectEmbeddedFiles((PDNameTreeNode)embeddedFilesTree, embeddedFiles);
        if (embeddedFiles.isEmpty()) {
            return Optional.empty();
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Optional<byte[]> optional;
            ZipOutputStream zipOutputStream;
            block22: {
                zipOutputStream = new ZipOutputStream(baos);
                try {
                    HashSet usedNames = new HashSet();
                    boolean hasExtractedAttachments = false;
                    long totalBytesWritten = 0L;
                    for (Map.Entry entry : embeddedFiles.entrySet()) {
                        PDComplexFileSpecification fileSpecification = (PDComplexFileSpecification)entry.getValue();
                        PDEmbeddedFile embeddedFile = this.getEmbeddedFile((PDFileSpecification)fileSpecification);
                        if (embeddedFile == null) {
                            log.debug("Skipping attachment {} because embedded file was null", entry.getKey());
                            continue;
                        }
                        String filename = this.determineFilename((String)entry.getKey(), fileSpecification);
                        filename = Filenames.toSimpleFileName((String)filename);
                        String sanitizedFilename = this.sanitizeFilename(filename);
                        Optional attachmentData = this.readAttachmentData(embeddedFile);
                        if (attachmentData.isEmpty()) {
                            log.warn("Skipping attachment '{}' because it exceeds the size limit of {} bytes", (Object)sanitizedFilename, (Object)this.maxAttachmentSizeBytes);
                            continue;
                        }
                        byte[] data = (byte[])attachmentData.get();
                        if (this.maxTotalAttachmentSizeBytes > 0L && (long)data.length + totalBytesWritten > this.maxTotalAttachmentSizeBytes) {
                            log.warn("Skipping attachment '{}' because the total size would exceed {} bytes", (Object)sanitizedFilename, (Object)this.maxTotalAttachmentSizeBytes);
                            continue;
                        }
                        String uniqueFilename = this.ensureUniqueFilename(sanitizedFilename, usedNames);
                        ZipEntry zipEntry = new ZipEntry(uniqueFilename);
                        if (embeddedFile.getModDate() != null) {
                            zipEntry.setLastModifiedTime(FileTime.from(embeddedFile.getModDate().toInstant()));
                        }
                        if (embeddedFile.getCreationDate() != null) {
                            zipEntry.setCreationTime(FileTime.from(embeddedFile.getCreationDate().toInstant()));
                        }
                        zipEntry.setSize(data.length);
                        zipOutputStream.putNextEntry(zipEntry);
                        zipOutputStream.write(data);
                        zipOutputStream.closeEntry();
                        hasExtractedAttachments = true;
                        totalBytesWritten += (long)data.length;
                        log.info("Extracted attachment '{}' ({} bytes)", (Object)uniqueFilename, (Object)data.length);
                    }
                    zipOutputStream.finish();
                    if (hasExtractedAttachments) break block22;
                    optional = Optional.empty();
                }
                catch (Throwable throwable) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                zipOutputStream.close();
                return optional;
            }
            optional = Optional.of(baos.toByteArray());
            zipOutputStream.close();
            return optional;
        }
    }

    private String sanitizeFilename(String candidate) {
        String sanitized = Filenames.toSimpleFileName((String)candidate);
        if (StringUtils.isBlank((CharSequence)sanitized)) {
            sanitized = this.generateDefaultFilename();
        }
        return sanitized;
    }

    private String generateDefaultFilename() {
        return "unknown_attachment_" + System.currentTimeMillis();
    }

    /*
     * Exception decompiling
     */
    private Optional<byte[]> readAttachmentData(PDEmbeddedFile embeddedFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void collectEmbeddedFiles(PDNameTreeNode<PDComplexFileSpecification> node, Map<String, PDComplexFileSpecification> collector) throws IOException {
        List kids;
        if (node == null) {
            return;
        }
        Map names = node.getNames();
        if (names != null) {
            collector.putAll(names);
        }
        if ((kids = node.getKids()) != null) {
            for (PDNameTreeNode kid : kids) {
                this.collectEmbeddedFiles(kid, collector);
            }
        }
    }

    private PDEmbeddedFile getEmbeddedFile(PDFileSpecification fileSpecification) {
        if (!(fileSpecification instanceof PDComplexFileSpecification)) {
            return null;
        }
        PDComplexFileSpecification complexSpecification = (PDComplexFileSpecification)fileSpecification;
        if (complexSpecification.getEmbeddedFileUnicode() != null) {
            return complexSpecification.getEmbeddedFileUnicode();
        }
        if (complexSpecification.getEmbeddedFile() != null) {
            return complexSpecification.getEmbeddedFile();
        }
        if (complexSpecification.getEmbeddedFileDos() != null) {
            return complexSpecification.getEmbeddedFileDos();
        }
        if (complexSpecification.getEmbeddedFileMac() != null) {
            return complexSpecification.getEmbeddedFileMac();
        }
        return complexSpecification.getEmbeddedFileUnix();
    }

    private String determineFilename(String key, PDComplexFileSpecification specification) {
        if (specification == null) {
            return this.fallbackFilename(key);
        }
        String name = specification.getFileUnicode();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = specification.getFilename();
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = specification.getFile();
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = key;
        }
        return this.fallbackFilename(name);
    }

    private String fallbackFilename(String candidate) {
        if (StringUtils.isBlank((CharSequence)candidate)) {
            return "unknown_attachment_" + System.currentTimeMillis();
        }
        return candidate;
    }

    private String ensureUniqueFilename(String filename, Set<String> usedNames) {
        String baseName = filename;
        String extension = "";
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            baseName = filename.substring(0, lastDot);
            extension = filename.substring(lastDot);
        }
        Object uniqueName = filename;
        int counter = 1;
        while (usedNames.contains(uniqueName)) {
            uniqueName = baseName + "_" + counter + extension;
            ++counter;
        }
        usedNames.add((String)uniqueName);
        return uniqueName;
    }

    private PDEmbeddedFilesNameTreeNode getEmbeddedFilesTree(PDDocument document) {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDDocumentNameDictionary documentNames = catalog.getNames();
        if (documentNames == null) {
            documentNames = new PDDocumentNameDictionary(catalog);
        }
        catalog.setNames(documentNames);
        PDEmbeddedFilesNameTreeNode embeddedFilesTree = documentNames.getEmbeddedFiles();
        if (embeddedFilesTree == null) {
            embeddedFilesTree = new PDEmbeddedFilesNameTreeNode();
            documentNames.setEmbeddedFiles(embeddedFilesTree);
        }
        return embeddedFilesTree;
    }
}

