/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.security;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.common.model.api.PDFFile;

public class SignPDFWithCertRequest
extends PDFFile {
    @Schema(description="The type of the digital certificate", allowableValues={"PEM", "PKCS12", "PFX", "JKS"}, requiredMode=Schema.RequiredMode.REQUIRED)
    private String certType;
    @Schema(description="The private key for the digital certificate (required for PEM type certificates, supports .pem, .der, or .key files)")
    private MultipartFile privateKeyFile;
    @Schema(description="The digital certificate (required for PEM type certificates, supports .pem, .der, .crt, or .cer files)")
    private MultipartFile certFile;
    @Schema(description="The PKCS12/PFX keystore file (required for PKCS12 or PFX type certificates)")
    private MultipartFile p12File;
    @Schema(description="The JKS keystore file (Java Key Store)")
    private MultipartFile jksFile;
    @Schema(description="The password for the keystore or the private key", format="password")
    private String password;
    @Schema(description="Whether to visually show the signature in the PDF file", defaultValue="false", requiredMode=Schema.RequiredMode.REQUIRED)
    private Boolean showSignature;
    @Schema(description="The reason for signing the PDF", defaultValue="Signed by SPDF")
    private String reason;
    @Schema(description="The location where the PDF is signed", defaultValue="SPDF")
    private String location;
    @Schema(description="The name of the signer", defaultValue="SPDF")
    private String name;
    @Schema(description="The page number where the signature should be visible. This is required if showSignature is set to true", defaultValue="1")
    private Integer pageNumber;
    @Schema(description="Whether to visually show a signature logo along with the signature", defaultValue="true", requiredMode=Schema.RequiredMode.REQUIRED)
    private Boolean showLogo;

    @Generated
    public SignPDFWithCertRequest() {
    }

    @Generated
    public String getCertType() {
        return this.certType;
    }

    @Generated
    public MultipartFile getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    @Generated
    public MultipartFile getCertFile() {
        return this.certFile;
    }

    @Generated
    public MultipartFile getP12File() {
        return this.p12File;
    }

    @Generated
    public MultipartFile getJksFile() {
        return this.jksFile;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getShowSignature() {
        return this.showSignature;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @Generated
    public Boolean getShowLogo() {
        return this.showLogo;
    }

    @Generated
    public void setCertType(String certType) {
        this.certType = certType;
    }

    @Generated
    public void setPrivateKeyFile(MultipartFile privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    @Generated
    public void setCertFile(MultipartFile certFile) {
        this.certFile = certFile;
    }

    @Generated
    public void setP12File(MultipartFile p12File) {
        this.p12File = p12File;
    }

    @Generated
    public void setJksFile(MultipartFile jksFile) {
        this.jksFile = jksFile;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setShowSignature(Boolean showSignature) {
        this.showSignature = showSignature;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Generated
    public void setShowLogo(Boolean showLogo) {
        this.showLogo = showLogo;
    }

    @Generated
    public String toString() {
        return "SignPDFWithCertRequest(certType=" + this.getCertType() + ", privateKeyFile=" + String.valueOf(this.getPrivateKeyFile()) + ", certFile=" + String.valueOf(this.getCertFile()) + ", p12File=" + String.valueOf(this.getP12File()) + ", jksFile=" + String.valueOf(this.getJksFile()) + ", password=" + this.getPassword() + ", showSignature=" + this.getShowSignature() + ", reason=" + this.getReason() + ", location=" + this.getLocation() + ", name=" + this.getName() + ", pageNumber=" + this.getPageNumber() + ", showLogo=" + this.getShowLogo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignPDFWithCertRequest)) {
            return false;
        }
        SignPDFWithCertRequest other = (SignPDFWithCertRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$showSignature = this.getShowSignature();
        Boolean other$showSignature = other.getShowSignature();
        if (this$showSignature == null ? other$showSignature != null : !((Object)this$showSignature).equals(other$showSignature)) {
            return false;
        }
        Integer this$pageNumber = this.getPageNumber();
        Integer other$pageNumber = other.getPageNumber();
        if (this$pageNumber == null ? other$pageNumber != null : !((Object)this$pageNumber).equals(other$pageNumber)) {
            return false;
        }
        Boolean this$showLogo = this.getShowLogo();
        Boolean other$showLogo = other.getShowLogo();
        if (this$showLogo == null ? other$showLogo != null : !((Object)this$showLogo).equals(other$showLogo)) {
            return false;
        }
        String this$certType = this.getCertType();
        String other$certType = other.getCertType();
        if (this$certType == null ? other$certType != null : !this$certType.equals(other$certType)) {
            return false;
        }
        MultipartFile this$privateKeyFile = this.getPrivateKeyFile();
        MultipartFile other$privateKeyFile = other.getPrivateKeyFile();
        if (this$privateKeyFile == null ? other$privateKeyFile != null : !this$privateKeyFile.equals(other$privateKeyFile)) {
            return false;
        }
        MultipartFile this$certFile = this.getCertFile();
        MultipartFile other$certFile = other.getCertFile();
        if (this$certFile == null ? other$certFile != null : !this$certFile.equals(other$certFile)) {
            return false;
        }
        MultipartFile this$p12File = this.getP12File();
        MultipartFile other$p12File = other.getP12File();
        if (this$p12File == null ? other$p12File != null : !this$p12File.equals(other$p12File)) {
            return false;
        }
        MultipartFile this$jksFile = this.getJksFile();
        MultipartFile other$jksFile = other.getJksFile();
        if (this$jksFile == null ? other$jksFile != null : !this$jksFile.equals(other$jksFile)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignPDFWithCertRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $showSignature = this.getShowSignature();
        result = result * 59 + ($showSignature == null ? 43 : ((Object)$showSignature).hashCode());
        Integer $pageNumber = this.getPageNumber();
        result = result * 59 + ($pageNumber == null ? 43 : ((Object)$pageNumber).hashCode());
        Boolean $showLogo = this.getShowLogo();
        result = result * 59 + ($showLogo == null ? 43 : ((Object)$showLogo).hashCode());
        String $certType = this.getCertType();
        result = result * 59 + ($certType == null ? 43 : $certType.hashCode());
        MultipartFile $privateKeyFile = this.getPrivateKeyFile();
        result = result * 59 + ($privateKeyFile == null ? 43 : $privateKeyFile.hashCode());
        MultipartFile $certFile = this.getCertFile();
        result = result * 59 + ($certFile == null ? 43 : $certFile.hashCode());
        MultipartFile $p12File = this.getP12File();
        result = result * 59 + ($p12File == null ? 43 : $p12File.hashCode());
        MultipartFile $jksFile = this.getJksFile();
        result = result * 59 + ($jksFile == null ? 43 : $jksFile.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

