/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.security;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import stirling.software.common.model.api.PDFFile;

public class AddPasswordRequest
extends PDFFile {
    @Schema(description="The owner password to be added to the PDF file (Restricts what can be done with the document once it is opened)", format="password")
    private String ownerPassword;
    @Schema(description="The password to be added to the PDF file (Restricts the opening of the document itself.)", format="password")
    private String password;
    @Schema(description="The length of the encryption key", allowableValues={"40", "128", "256"}, defaultValue="256", requiredMode=Schema.RequiredMode.REQUIRED)
    private int keyLength = 256;
    @Schema(description="Whether document assembly is prevented", defaultValue="false")
    private Boolean preventAssembly;
    @Schema(description="Whether content extraction is prevented", defaultValue="false")
    private Boolean preventExtractContent;
    @Schema(description="Whether content extraction for accessibility is prevented", defaultValue="false")
    private Boolean preventExtractForAccessibility;
    @Schema(description="Whether form filling is prevented", defaultValue="false")
    private Boolean preventFillInForm;
    @Schema(description="Whether document modification is prevented", defaultValue="false")
    private Boolean preventModify;
    @Schema(description="Whether modification of annotations is prevented", defaultValue="false")
    private Boolean preventModifyAnnotations;
    @Schema(description="Whether printing of the document is prevented", defaultValue="false")
    private Boolean preventPrinting;
    @Schema(description="Whether faithful printing is prevented", defaultValue="false")
    private Boolean preventPrintingFaithful;

    @Generated
    public AddPasswordRequest() {
    }

    @Generated
    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public int getKeyLength() {
        return this.keyLength;
    }

    @Generated
    public Boolean getPreventAssembly() {
        return this.preventAssembly;
    }

    @Generated
    public Boolean getPreventExtractContent() {
        return this.preventExtractContent;
    }

    @Generated
    public Boolean getPreventExtractForAccessibility() {
        return this.preventExtractForAccessibility;
    }

    @Generated
    public Boolean getPreventFillInForm() {
        return this.preventFillInForm;
    }

    @Generated
    public Boolean getPreventModify() {
        return this.preventModify;
    }

    @Generated
    public Boolean getPreventModifyAnnotations() {
        return this.preventModifyAnnotations;
    }

    @Generated
    public Boolean getPreventPrinting() {
        return this.preventPrinting;
    }

    @Generated
    public Boolean getPreventPrintingFaithful() {
        return this.preventPrintingFaithful;
    }

    @Generated
    public void setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setKeyLength(int keyLength) {
        this.keyLength = keyLength;
    }

    @Generated
    public void setPreventAssembly(Boolean preventAssembly) {
        this.preventAssembly = preventAssembly;
    }

    @Generated
    public void setPreventExtractContent(Boolean preventExtractContent) {
        this.preventExtractContent = preventExtractContent;
    }

    @Generated
    public void setPreventExtractForAccessibility(Boolean preventExtractForAccessibility) {
        this.preventExtractForAccessibility = preventExtractForAccessibility;
    }

    @Generated
    public void setPreventFillInForm(Boolean preventFillInForm) {
        this.preventFillInForm = preventFillInForm;
    }

    @Generated
    public void setPreventModify(Boolean preventModify) {
        this.preventModify = preventModify;
    }

    @Generated
    public void setPreventModifyAnnotations(Boolean preventModifyAnnotations) {
        this.preventModifyAnnotations = preventModifyAnnotations;
    }

    @Generated
    public void setPreventPrinting(Boolean preventPrinting) {
        this.preventPrinting = preventPrinting;
    }

    @Generated
    public void setPreventPrintingFaithful(Boolean preventPrintingFaithful) {
        this.preventPrintingFaithful = preventPrintingFaithful;
    }

    @Generated
    public String toString() {
        return "AddPasswordRequest(ownerPassword=" + this.getOwnerPassword() + ", password=" + this.getPassword() + ", keyLength=" + this.getKeyLength() + ", preventAssembly=" + this.getPreventAssembly() + ", preventExtractContent=" + this.getPreventExtractContent() + ", preventExtractForAccessibility=" + this.getPreventExtractForAccessibility() + ", preventFillInForm=" + this.getPreventFillInForm() + ", preventModify=" + this.getPreventModify() + ", preventModifyAnnotations=" + this.getPreventModifyAnnotations() + ", preventPrinting=" + this.getPreventPrinting() + ", preventPrintingFaithful=" + this.getPreventPrintingFaithful() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPasswordRequest)) {
            return false;
        }
        AddPasswordRequest other = (AddPasswordRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getKeyLength() != other.getKeyLength()) {
            return false;
        }
        Boolean this$preventAssembly = this.getPreventAssembly();
        Boolean other$preventAssembly = other.getPreventAssembly();
        if (this$preventAssembly == null ? other$preventAssembly != null : !((Object)this$preventAssembly).equals(other$preventAssembly)) {
            return false;
        }
        Boolean this$preventExtractContent = this.getPreventExtractContent();
        Boolean other$preventExtractContent = other.getPreventExtractContent();
        if (this$preventExtractContent == null ? other$preventExtractContent != null : !((Object)this$preventExtractContent).equals(other$preventExtractContent)) {
            return false;
        }
        Boolean this$preventExtractForAccessibility = this.getPreventExtractForAccessibility();
        Boolean other$preventExtractForAccessibility = other.getPreventExtractForAccessibility();
        if (this$preventExtractForAccessibility == null ? other$preventExtractForAccessibility != null : !((Object)this$preventExtractForAccessibility).equals(other$preventExtractForAccessibility)) {
            return false;
        }
        Boolean this$preventFillInForm = this.getPreventFillInForm();
        Boolean other$preventFillInForm = other.getPreventFillInForm();
        if (this$preventFillInForm == null ? other$preventFillInForm != null : !((Object)this$preventFillInForm).equals(other$preventFillInForm)) {
            return false;
        }
        Boolean this$preventModify = this.getPreventModify();
        Boolean other$preventModify = other.getPreventModify();
        if (this$preventModify == null ? other$preventModify != null : !((Object)this$preventModify).equals(other$preventModify)) {
            return false;
        }
        Boolean this$preventModifyAnnotations = this.getPreventModifyAnnotations();
        Boolean other$preventModifyAnnotations = other.getPreventModifyAnnotations();
        if (this$preventModifyAnnotations == null ? other$preventModifyAnnotations != null : !((Object)this$preventModifyAnnotations).equals(other$preventModifyAnnotations)) {
            return false;
        }
        Boolean this$preventPrinting = this.getPreventPrinting();
        Boolean other$preventPrinting = other.getPreventPrinting();
        if (this$preventPrinting == null ? other$preventPrinting != null : !((Object)this$preventPrinting).equals(other$preventPrinting)) {
            return false;
        }
        Boolean this$preventPrintingFaithful = this.getPreventPrintingFaithful();
        Boolean other$preventPrintingFaithful = other.getPreventPrintingFaithful();
        if (this$preventPrintingFaithful == null ? other$preventPrintingFaithful != null : !((Object)this$preventPrintingFaithful).equals(other$preventPrintingFaithful)) {
            return false;
        }
        String this$ownerPassword = this.getOwnerPassword();
        String other$ownerPassword = other.getOwnerPassword();
        if (this$ownerPassword == null ? other$ownerPassword != null : !this$ownerPassword.equals(other$ownerPassword)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddPasswordRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getKeyLength();
        Boolean $preventAssembly = this.getPreventAssembly();
        result = result * 59 + ($preventAssembly == null ? 43 : ((Object)$preventAssembly).hashCode());
        Boolean $preventExtractContent = this.getPreventExtractContent();
        result = result * 59 + ($preventExtractContent == null ? 43 : ((Object)$preventExtractContent).hashCode());
        Boolean $preventExtractForAccessibility = this.getPreventExtractForAccessibility();
        result = result * 59 + ($preventExtractForAccessibility == null ? 43 : ((Object)$preventExtractForAccessibility).hashCode());
        Boolean $preventFillInForm = this.getPreventFillInForm();
        result = result * 59 + ($preventFillInForm == null ? 43 : ((Object)$preventFillInForm).hashCode());
        Boolean $preventModify = this.getPreventModify();
        result = result * 59 + ($preventModify == null ? 43 : ((Object)$preventModify).hashCode());
        Boolean $preventModifyAnnotations = this.getPreventModifyAnnotations();
        result = result * 59 + ($preventModifyAnnotations == null ? 43 : ((Object)$preventModifyAnnotations).hashCode());
        Boolean $preventPrinting = this.getPreventPrinting();
        result = result * 59 + ($preventPrinting == null ? 43 : ((Object)$preventPrinting).hashCode());
        Boolean $preventPrintingFaithful = this.getPreventPrintingFaithful();
        result = result * 59 + ($preventPrintingFaithful == null ? 43 : ((Object)$preventPrintingFaithful).hashCode());
        String $ownerPassword = this.getOwnerPassword();
        result = result * 59 + ($ownerPassword == null ? 43 : $ownerPassword.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }
}

