/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.misc;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.misc.ScannerEffectRequest;

public class ScannerEffectRequest {
    @Schema(description="PDF file to process", requiredMode=Schema.RequiredMode.REQUIRED, type="string", format="binary")
    @NotNull(message="File input is required")
    private @NotNull(message="File input is required") MultipartFile fileInput;
    @Schema(description="Scan quality preset", example="high")
    @NotNull(message="Quality is required")
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="Quality is required") ScannerEffectRequest.Quality quality = Quality.high;
    @Schema(description="Rotation preset", example="none")
    @NotNull(message="Rotation is required")
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="Rotation is required") ScannerEffectRequest.Rotation rotation = Rotation.slight;
    @Schema(description="Colorspace for output image", example="grayscale")
    private Colorspace colorspace = Colorspace.grayscale;
    @Schema(description="Border thickness in pixels", example="20")
    private int border = 20;
    @Schema(description="Base rotation in degrees", example="0")
    private int rotate = 0;
    @Schema(description="Random rotation variance in degrees", example="2")
    private int rotateVariance = 2;
    @Schema(description="Brightness multiplier (1.0 = no change)", example="1.0")
    private float brightness = 1.0f;
    @Schema(description="Contrast multiplier (1.0 = no change)", example="1.0")
    private float contrast = 1.0f;
    @Schema(description="Blur amount (0 = none, higher = more blur)", example="1.0")
    private float blur = 1.0f;
    @Schema(description="Noise amount (0 = none, higher = more noise)", example="8.0")
    private float noise = 8.0f;
    @Schema(description="Simulate yellowed paper", example="false")
    private boolean yellowish = false;
    @Schema(description="Rendering resolution in DPI", example="300")
    private int resolution = 300;
    @Schema(description="Whether advanced settings are enabled", example="false")
    private boolean advancedEnabled = false;

    public int getRotationValue() {
        return switch (this.rotation.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> 0;
            case 1 -> 2;
            case 2 -> 5;
            case 3 -> 8;
        };
    }

    public void applyHighQualityPreset() {
        this.blur = 0.1f;
        this.noise = 1.0f;
        this.brightness = 1.03f;
        this.contrast = 1.06f;
        this.resolution = 150;
    }

    public void applyMediumQualityPreset() {
        this.blur = 0.1f;
        this.noise = 1.0f;
        this.brightness = 1.06f;
        this.contrast = 1.12f;
        this.resolution = 100;
    }

    public void applyLowQualityPreset() {
        this.blur = 0.9f;
        this.noise = 2.5f;
        this.brightness = 1.08f;
        this.contrast = 1.15f;
        this.resolution = 75;
    }

    @Generated
    public ScannerEffectRequest() {
    }

    @Generated
    public MultipartFile getFileInput() {
        return this.fileInput;
    }

    @Generated
    public Quality getQuality() {
        return this.quality;
    }

    @Generated
    public Rotation getRotation() {
        return this.rotation;
    }

    @Generated
    public Colorspace getColorspace() {
        return this.colorspace;
    }

    @Generated
    public int getBorder() {
        return this.border;
    }

    @Generated
    public int getRotate() {
        return this.rotate;
    }

    @Generated
    public int getRotateVariance() {
        return this.rotateVariance;
    }

    @Generated
    public float getBrightness() {
        return this.brightness;
    }

    @Generated
    public float getContrast() {
        return this.contrast;
    }

    @Generated
    public float getBlur() {
        return this.blur;
    }

    @Generated
    public float getNoise() {
        return this.noise;
    }

    @Generated
    public boolean isYellowish() {
        return this.yellowish;
    }

    @Generated
    public int getResolution() {
        return this.resolution;
    }

    @Generated
    public boolean isAdvancedEnabled() {
        return this.advancedEnabled;
    }

    @Generated
    public void setFileInput(MultipartFile fileInput) {
        this.fileInput = fileInput;
    }

    @Generated
    public void setQuality(Quality quality) {
        this.quality = quality;
    }

    @Generated
    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setColorspace(Colorspace colorspace) {
        this.colorspace = colorspace;
    }

    @Generated
    public void setBorder(int border) {
        this.border = border;
    }

    @Generated
    public void setRotate(int rotate) {
        this.rotate = rotate;
    }

    @Generated
    public void setRotateVariance(int rotateVariance) {
        this.rotateVariance = rotateVariance;
    }

    @Generated
    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    @Generated
    public void setContrast(float contrast) {
        this.contrast = contrast;
    }

    @Generated
    public void setBlur(float blur) {
        this.blur = blur;
    }

    @Generated
    public void setNoise(float noise) {
        this.noise = noise;
    }

    @Generated
    public void setYellowish(boolean yellowish) {
        this.yellowish = yellowish;
    }

    @Generated
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    @Generated
    public void setAdvancedEnabled(boolean advancedEnabled) {
        this.advancedEnabled = advancedEnabled;
    }

    @Generated
    public String toString() {
        return "ScannerEffectRequest(fileInput=" + String.valueOf(this.getFileInput()) + ", quality=" + String.valueOf(this.getQuality()) + ", rotation=" + String.valueOf(this.getRotation()) + ", colorspace=" + String.valueOf(this.getColorspace()) + ", border=" + this.getBorder() + ", rotate=" + this.getRotate() + ", rotateVariance=" + this.getRotateVariance() + ", brightness=" + this.getBrightness() + ", contrast=" + this.getContrast() + ", blur=" + this.getBlur() + ", noise=" + this.getNoise() + ", yellowish=" + this.isYellowish() + ", resolution=" + this.getResolution() + ", advancedEnabled=" + this.isAdvancedEnabled() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScannerEffectRequest)) {
            return false;
        }
        ScannerEffectRequest other = (ScannerEffectRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getBorder() != other.getBorder()) {
            return false;
        }
        if (this.getRotate() != other.getRotate()) {
            return false;
        }
        if (this.getRotateVariance() != other.getRotateVariance()) {
            return false;
        }
        if (Float.compare(this.getBrightness(), other.getBrightness()) != 0) {
            return false;
        }
        if (Float.compare(this.getContrast(), other.getContrast()) != 0) {
            return false;
        }
        if (Float.compare(this.getBlur(), other.getBlur()) != 0) {
            return false;
        }
        if (Float.compare(this.getNoise(), other.getNoise()) != 0) {
            return false;
        }
        if (this.isYellowish() != other.isYellowish()) {
            return false;
        }
        if (this.getResolution() != other.getResolution()) {
            return false;
        }
        if (this.isAdvancedEnabled() != other.isAdvancedEnabled()) {
            return false;
        }
        MultipartFile this$fileInput = this.getFileInput();
        MultipartFile other$fileInput = other.getFileInput();
        if (this$fileInput == null ? other$fileInput != null : !this$fileInput.equals(other$fileInput)) {
            return false;
        }
        Quality this$quality = this.getQuality();
        Quality other$quality = other.getQuality();
        if (this$quality == null ? other$quality != null : !this$quality.equals(other$quality)) {
            return false;
        }
        Rotation this$rotation = this.getRotation();
        Rotation other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        Colorspace this$colorspace = this.getColorspace();
        Colorspace other$colorspace = other.getColorspace();
        return !(this$colorspace == null ? other$colorspace != null : !this$colorspace.equals(other$colorspace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScannerEffectRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBorder();
        result = result * 59 + this.getRotate();
        result = result * 59 + this.getRotateVariance();
        result = result * 59 + Float.floatToIntBits(this.getBrightness());
        result = result * 59 + Float.floatToIntBits(this.getContrast());
        result = result * 59 + Float.floatToIntBits(this.getBlur());
        result = result * 59 + Float.floatToIntBits(this.getNoise());
        result = result * 59 + (this.isYellowish() ? 79 : 97);
        result = result * 59 + this.getResolution();
        result = result * 59 + (this.isAdvancedEnabled() ? 79 : 97);
        MultipartFile $fileInput = this.getFileInput();
        result = result * 59 + ($fileInput == null ? 43 : $fileInput.hashCode());
        Quality $quality = this.getQuality();
        result = result * 59 + ($quality == null ? 43 : $quality.hashCode());
        Rotation $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        Colorspace $colorspace = this.getColorspace();
        result = result * 59 + ($colorspace == null ? 43 : $colorspace.hashCode());
        return result;
    }
}

