/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import stirling.software.common.model.ApplicationProperties;

@Service
public class UploadLimitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadLimitService.class);
    @Autowired
    private ApplicationProperties applicationProperties;

    public long getUploadLimit() {
        long value;
        String raw;
        String string = raw = this.applicationProperties.getSystem().getFileUploadLimit() != null ? this.applicationProperties.getSystem().getFileUploadLimit() : "";
        if (raw == null || raw.isEmpty()) {
            return 0L;
        }
        String s = raw.trim();
        String upper = s.toUpperCase(Locale.ROOT);
        if (upper.length() < 3) {
            return 0L;
        }
        String unit = upper.substring(upper.length() - 2);
        if (!(unit.equals("KB") || unit.equals("MB") || unit.equals("GB"))) {
            return 0L;
        }
        String numPart = upper.substring(0, upper.length() - 2);
        if (numPart.length() > 3) {
            return 0L;
        }
        for (int i = 0; i < numPart.length(); ++i) {
            char c = numPart.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return 0L;
        }
        try {
            value = Long.parseLong(numPart);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        return switch (unit) {
            case "KB" -> value * 1024L;
            case "MB" -> value * 1024L * 1024L;
            case "GB" -> value * 1024L * 1024L * 1024L;
            default -> 0L;
        };
    }

    public String getReadableUploadLimit() {
        return this.humanReadableByteCount(this.getUploadLimit());
    }

    private String humanReadableByteCount(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "B";
        return String.format(Locale.ROOT, "%.1f %s", (double)bytes / Math.pow(1024.0, exp), pre);
    }
}

