/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import stirling.software.SPDF.service.SignatureService;
import stirling.software.common.service.UserServiceInterface;

@Controller
@RequestMapping(value={"/api/v1/general"})
public class SignatureController {
    private final SignatureService signatureService;
    private final UserServiceInterface userService;

    public SignatureController(SignatureService signatureService, @Autowired(required=false) UserServiceInterface userService) {
        this.signatureService = signatureService;
        this.userService = userService;
    }

    @GetMapping(value={"/sign/{fileName}"})
    public ResponseEntity<byte[]> getSignature(@PathVariable(name="fileName") String fileName) throws IOException {
        String username = "NON_SECURITY_USER";
        if (this.userService != null) {
            username = this.userService.getCurrentUsername();
        }
        if (!this.signatureService.hasAccessToFile(username, fileName)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        byte[] imageBytes = this.signatureService.getSignatureBytes(username, fileName);
        Optional mediaType = MediaTypeFactory.getMediaType((String)fileName);
        if (mediaType.isPresent() && ((MediaType)mediaType.get()).toString().startsWith("image/")) {
            return ResponseEntity.ok().contentType((MediaType)mediaType.get()).body((Object)imageBytes);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
    }
}

