/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.util.CheckProgramInstall;

@Controller
@Tag(name="Misc", description="Miscellaneous APIs")
public class OtherWebController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtherWebController.class);
    private final ApplicationProperties applicationProperties;
    private final RuntimePathConfig runtimePathConfig;

    @GetMapping(value={"/compress-pdf"})
    @Hidden
    public String compressPdfForm(Model model) {
        model.addAttribute("currentPage", (Object)"compress-pdf");
        return "misc/compress-pdf";
    }

    @GetMapping(value={"/replace-and-invert-color-pdf"})
    @Hidden
    public String replaceAndInvertColorPdfForm(Model model) {
        model.addAttribute("currentPage", (Object)"replace-invert-color-pdf");
        return "misc/replace-color";
    }

    @GetMapping(value={"/extract-image-scans"})
    @Hidden
    public ModelAndView extractImageScansForm() {
        ModelAndView modelAndView = new ModelAndView("misc/extract-image-scans");
        boolean isPython = CheckProgramInstall.isPythonAvailable();
        modelAndView.addObject("isPython", (Object)isPython);
        modelAndView.addObject("currentPage", (Object)"extract-image-scans");
        return modelAndView;
    }

    @GetMapping(value={"/show-javascript"})
    @Hidden
    public String extractJavascriptForm(Model model) {
        model.addAttribute("currentPage", (Object)"show-javascript");
        return "misc/show-javascript";
    }

    @GetMapping(value={"/stamp"})
    @Hidden
    public String stampForm(Model model) {
        model.addAttribute("currentPage", (Object)"stamp");
        return "misc/stamp";
    }

    @GetMapping(value={"/add-page-numbers"})
    @Hidden
    public String addPageNumbersForm(Model model) {
        model.addAttribute("currentPage", (Object)"add-page-numbers");
        return "misc/add-page-numbers";
    }

    @GetMapping(value={"/scanner-effect"})
    @Hidden
    public String scannerEffectForm(Model model) {
        model.addAttribute("currentPage", (Object)"scanner-effect");
        return "misc/scanner-effect";
    }

    @GetMapping(value={"/extract-images"})
    @Hidden
    public String extractImagesForm(Model model) {
        model.addAttribute("currentPage", (Object)"extract-images");
        return "misc/extract-images";
    }

    @GetMapping(value={"/flatten"})
    @Hidden
    public String flattenForm(Model model) {
        model.addAttribute("currentPage", (Object)"flatten");
        return "misc/flatten";
    }

    @GetMapping(value={"/change-metadata"})
    @Hidden
    public String addWatermarkForm(Model model) {
        model.addAttribute("currentPage", (Object)"change-metadata");
        return "misc/change-metadata";
    }

    @GetMapping(value={"/unlock-pdf-forms"})
    @Hidden
    public String unlockPDFForms(Model model) {
        model.addAttribute("currentPage", (Object)"unlock-pdf-forms");
        return "misc/unlock-pdf-forms";
    }

    @GetMapping(value={"/compare"})
    @Hidden
    public String compareForm(Model model) {
        model.addAttribute("currentPage", (Object)"compare");
        return "misc/compare";
    }

    @GetMapping(value={"/print-file"})
    @Hidden
    public String printFileForm(Model model) {
        model.addAttribute("currentPage", (Object)"print-file");
        return "misc/print-file";
    }

    public List<String> getAvailableTesseractLanguages() {
        String tessdataDir = this.runtimePathConfig.getTessDataPath();
        File[] files = new File(tessdataDir).listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> file.getName().endsWith(".traineddata")).map(file -> file.getName().replace(".traineddata", "")).filter(lang -> !"osd".equalsIgnoreCase((String)lang)).sorted().toList();
    }

    @GetMapping(value={"/ocr-pdf"})
    @Hidden
    public ModelAndView ocrPdfPage() {
        ModelAndView modelAndView = new ModelAndView("misc/ocr-pdf");
        List languages = this.getAvailableTesseractLanguages();
        modelAndView.addObject("languages", (Object)languages);
        modelAndView.addObject("currentPage", (Object)"ocr-pdf");
        return modelAndView;
    }

    @GetMapping(value={"/add-image"})
    @Hidden
    public String overlayImage(Model model) {
        model.addAttribute("currentPage", (Object)"add-image");
        return "misc/add-image";
    }

    @GetMapping(value={"/adjust-contrast"})
    @Hidden
    public String contrast(Model model) {
        model.addAttribute("currentPage", (Object)"adjust-contrast");
        return "misc/adjust-contrast";
    }

    @GetMapping(value={"/repair"})
    @Hidden
    public String repairForm(Model model) {
        model.addAttribute("currentPage", (Object)"repair");
        return "misc/repair";
    }

    @GetMapping(value={"/remove-blanks"})
    @Hidden
    public String removeBlanksForm(Model model) {
        model.addAttribute("currentPage", (Object)"remove-blanks");
        return "misc/remove-blanks";
    }

    @GetMapping(value={"/remove-annotations"})
    @Hidden
    public String removeAnnotationsForm(Model model) {
        model.addAttribute("currentPage", (Object)"remove-annotations");
        return "misc/remove-annotations";
    }

    @GetMapping(value={"/auto-crop"})
    @Hidden
    public String autoCropForm(Model model) {
        model.addAttribute("currentPage", (Object)"auto-crop");
        return "misc/auto-crop";
    }

    @GetMapping(value={"/auto-rename"})
    @Hidden
    public String autoRenameForm(Model model) {
        model.addAttribute("currentPage", (Object)"auto-rename");
        return "misc/auto-rename";
    }

    @GetMapping(value={"/add-attachments"})
    @Hidden
    public String attachmentsForm(Model model) {
        model.addAttribute("currentPage", (Object)"add-attachments");
        return "misc/add-attachments";
    }

    @GetMapping(value={"/extract-attachments"})
    @Hidden
    public String extractAttachmentsForm(Model model) {
        model.addAttribute("currentPage", (Object)"extract-attachments");
        return "misc/extract-attachments";
    }

    @Generated
    public OtherWebController(ApplicationProperties applicationProperties, RuntimePathConfig runtimePathConfig) {
        this.applicationProperties = applicationProperties;
        this.runtimePathConfig = runtimePathConfig;
    }
}

