/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Hidden;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import stirling.software.common.model.ApplicationProperties;

@Controller
public class HomeWebController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeWebController.class);
    private final ApplicationProperties applicationProperties;

    @GetMapping(value={"/about"})
    @Hidden
    public String gameForm(Model model) {
        model.addAttribute("currentPage", (Object)"about");
        return "about";
    }

    @GetMapping(value={"/licenses"})
    @Hidden
    public String licensesForm(Model model) {
        model.addAttribute("currentPage", (Object)"licenses");
        ClassPathResource resource = new ClassPathResource("static/3rdPartyLicenses.json");
        try {
            InputStream is = resource.getInputStream();
            String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            ObjectMapper mapper = new ObjectMapper();
            Map data = (Map)mapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            model.addAttribute("dependencies", data.get("dependencies"));
        }
        catch (IOException e) {
            log.error("exception", (Throwable)e);
        }
        return "licenses";
    }

    @GetMapping(value={"/releases"})
    public String getReleaseNotes(Model model) {
        return "releases";
    }

    @GetMapping(value={"/"})
    public String home(Model model) {
        model.addAttribute("currentPage", (Object)"home");
        String showSurvey = System.getenv("SHOW_SURVEY");
        boolean showSurveyValue = showSurvey == null || "true".equalsIgnoreCase(showSurvey);
        model.addAttribute("showSurveyFromDocker", (Object)showSurveyValue);
        return "home";
    }

    @GetMapping(value={"/home"})
    public String root(Model model) {
        return "redirect:/";
    }

    @GetMapping(value={"/home-legacy"})
    public String redirectHomeLegacy() {
        return "redirect:/";
    }

    @GetMapping(value={"/robots.txt"}, produces={"text/plain"})
    @ResponseBody
    @Hidden
    public String getRobotsTxt() {
        boolean allowGoogle = this.applicationProperties.getSystem().isGooglevisibility();
        if (allowGoogle) {
            return "User-agent: Googlebot\nAllow: /\n\nUser-agent: *\nAllow: /";
        }
        return "User-agent: Googlebot\nDisallow: /\n\nUser-agent: *\nDisallow: /";
    }

    @Generated
    public HomeWebController(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }
}

