/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import stirling.software.SPDF.controller.web.GeneralWebController;
import stirling.software.SPDF.service.SignatureService;
import stirling.software.common.configuration.InstallationPathConfig;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.service.UserServiceInterface;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;

@Controller
@Tag(name="General", description="General APIs")
public class GeneralWebController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneralWebController.class);
    private final SignatureService signatureService;
    private final UserServiceInterface userService;
    private final ResourceLoader resourceLoader;
    private final RuntimePathConfig runtimePathConfig;

    public GeneralWebController(SignatureService signatureService, @Autowired(required=false) UserServiceInterface userService, ResourceLoader resourceLoader, RuntimePathConfig runtimePathConfig) {
        this.signatureService = signatureService;
        this.userService = userService;
        this.resourceLoader = resourceLoader;
        this.runtimePathConfig = runtimePathConfig;
    }

    @GetMapping(value={"/pipeline"})
    @Hidden
    public String pipelineForm(Model model) {
        model.addAttribute("currentPage", (Object)"pipeline");
        ArrayList<String> pipelineConfigs = new ArrayList<String>();
        ArrayList pipelineConfigsWithNames = new ArrayList();
        if (new File(this.runtimePathConfig.getPipelineDefaultWebUiConfigs()).exists()) {
            try (Stream<Path> paths = Files.walk(Paths.get(this.runtimePathConfig.getPipelineDefaultWebUiConfigs(), new String[0]), new FileVisitOption[0]);){
                List<Path> jsonFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).toList();
                for (Path jsonFile : jsonFiles) {
                    String content = Files.readString(jsonFile, StandardCharsets.UTF_8);
                    pipelineConfigs.add(content);
                }
                for (String config : pipelineConfigs) {
                    Map jsonContent = (Map)new ObjectMapper().readValue(config, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    String name = (String)jsonContent.get("name");
                    if (name == null || name.isEmpty()) {
                        String filename = jsonFiles.get(pipelineConfigs.indexOf(config)).getFileName().toString();
                        name = filename.substring(0, filename.lastIndexOf(46));
                    }
                    HashMap<String, String> configWithName = new HashMap<String, String>();
                    configWithName.put("json", config);
                    configWithName.put("name", name);
                    pipelineConfigsWithNames.add(configWithName);
                }
            }
            catch (IOException e) {
                log.error("exception", (Throwable)e);
            }
        }
        if (pipelineConfigsWithNames.isEmpty()) {
            HashMap<String, String> configWithName = new HashMap<String, String>();
            configWithName.put("json", "");
            configWithName.put("name", "No preloaded configs found");
            pipelineConfigsWithNames.add(configWithName);
        }
        model.addAttribute("pipelineConfigsWithNames", pipelineConfigsWithNames);
        model.addAttribute("pipelineConfigs", pipelineConfigs);
        return "pipeline";
    }

    @GetMapping(value={"/merge-pdfs"})
    @Hidden
    public String mergePdfForm(Model model) {
        model.addAttribute("currentPage", (Object)"merge-pdfs");
        return "merge-pdfs";
    }

    @GetMapping(value={"/split-pdf-by-sections"})
    @Hidden
    public String splitPdfBySections(Model model) {
        model.addAttribute("currentPage", (Object)"split-pdf-by-sections");
        return "split-pdf-by-sections";
    }

    @GetMapping(value={"/split-pdf-by-chapters"})
    @Hidden
    public String splitPdfByChapters(Model model) {
        model.addAttribute("currentPage", (Object)"split-pdf-by-chapters");
        return "split-pdf-by-chapters";
    }

    @GetMapping(value={"/view-pdf"})
    @Hidden
    public String ViewPdfForm2(Model model) {
        model.addAttribute("currentPage", (Object)"view-pdf");
        return "view-pdf";
    }

    @GetMapping(value={"/edit-table-of-contents"})
    @Hidden
    public String editTableOfContents(Model model) {
        model.addAttribute("currentPage", (Object)"edit-table-of-contents");
        return "edit-table-of-contents";
    }

    @GetMapping(value={"/multi-tool"})
    @Hidden
    public String multiToolForm(Model model) {
        model.addAttribute("currentPage", (Object)"multi-tool");
        return "multi-tool";
    }

    @GetMapping(value={"/remove-pages"})
    @Hidden
    public String pageDeleter(Model model) {
        model.addAttribute("currentPage", (Object)"remove-pages");
        return "remove-pages";
    }

    @GetMapping(value={"/pdf-organizer"})
    @Hidden
    public String pageOrganizer(Model model) {
        model.addAttribute("currentPage", (Object)"pdf-organizer");
        return "pdf-organizer";
    }

    @GetMapping(value={"/extract-page"})
    @Hidden
    public String extractPages(Model model) {
        model.addAttribute("currentPage", (Object)"extract-page");
        return "extract-page";
    }

    @GetMapping(value={"/pdf-to-single-page"})
    @Hidden
    public String pdfToSinglePage(Model model) {
        model.addAttribute("currentPage", (Object)"pdf-to-single-page");
        return "pdf-to-single-page";
    }

    @GetMapping(value={"/rotate-pdf"})
    @Hidden
    public String rotatePdfForm(Model model) {
        model.addAttribute("currentPage", (Object)"rotate-pdf");
        return "rotate-pdf";
    }

    @GetMapping(value={"/split-pdfs"})
    @Hidden
    public String splitPdfForm(Model model) {
        model.addAttribute("currentPage", (Object)"split-pdfs");
        return "split-pdfs";
    }

    @GetMapping(value={"/sign"})
    @Hidden
    public String signForm(Model model) {
        String username = "";
        if (this.userService != null) {
            username = this.userService.getCurrentUsername();
        }
        List signatures = this.signatureService.getAvailableSignatures(username);
        model.addAttribute("currentPage", (Object)"sign");
        model.addAttribute("fonts", (Object)this.getFontNames());
        model.addAttribute("signatures", (Object)signatures);
        return "sign";
    }

    @GetMapping(value={"/multi-page-layout"})
    @Hidden
    public String multiPageLayoutForm(Model model) {
        model.addAttribute("currentPage", (Object)"multi-page-layout");
        return "multi-page-layout";
    }

    @GetMapping(value={"/scale-pages"})
    @Hidden
    public String scalePagesFrom(Model model) {
        model.addAttribute("currentPage", (Object)"scale-pages");
        return "scale-pages";
    }

    @GetMapping(value={"/split-by-size-or-count"})
    @Hidden
    public String splitBySizeOrCount(Model model) {
        model.addAttribute("currentPage", (Object)"split-by-size-or-count");
        return "split-by-size-or-count";
    }

    @GetMapping(value={"/overlay-pdf"})
    @Hidden
    public String overlayPdf(Model model) {
        model.addAttribute("currentPage", (Object)"overlay-pdf");
        return "overlay-pdf";
    }

    private List<FontResource> getFontNames() {
        ArrayList<FontResource> fontNames = new ArrayList<FontResource>();
        fontNames.addAll(this.getFontNamesFromLocation("classpath:static/fonts/*.woff2"));
        fontNames.addAll(this.getFontNamesFromLocation("file:" + InstallationPathConfig.getStaticPath() + "fonts" + File.separator + "*"));
        return fontNames;
    }

    private List<FontResource> getFontNamesFromLocation(String locationPattern) {
        try {
            Resource[] resources = GeneralUtils.getResourcesFromLocationPattern((String)locationPattern, (ResourceLoader)this.resourceLoader);
            return Arrays.stream(resources).map(resource -> {
                try {
                    int lastDotIndex;
                    String filename = resource.getFilename();
                    if (filename != null && (lastDotIndex = filename.lastIndexOf(46)) != -1) {
                        String name = filename.substring(0, lastDotIndex);
                        String extension = filename.substring(lastDotIndex + 1);
                        return new FontResource(this, name, extension);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw ExceptionUtils.createRuntimeException((String)"error.fontLoadingFailed", (String)"Error processing font file", (Exception)e, (Object[])new Object[0]);
                }
            }).filter(Objects::nonNull).toList();
        }
        catch (Exception e) {
            throw ExceptionUtils.createRuntimeException((String)"error.fontDirectoryReadFailed", (String)"Failed to read font directory", (Exception)e, (Object[])new Object[0]);
        }
    }

    public String getFormatFromExtension(String extension) {
        return switch (extension) {
            case "ttf" -> "truetype";
            case "woff" -> "woff";
            case "woff2" -> "woff2";
            case "eot" -> "embedded-opentype";
            case "svg" -> "svg";
            default -> "";
        };
    }

    @GetMapping(value={"/crop"})
    @Hidden
    public String cropForm(Model model) {
        model.addAttribute("currentPage", (Object)"crop");
        return "crop";
    }

    @GetMapping(value={"/auto-split-pdf"})
    @Hidden
    public String autoSPlitPDFForm(Model model) {
        model.addAttribute("currentPage", (Object)"auto-split-pdf");
        return "auto-split-pdf";
    }

    @GetMapping(value={"/remove-image-pdf"})
    @Hidden
    public String removeImagePdfForm(Model model) {
        model.addAttribute("currentPage", (Object)"remove-image-pdf");
        return "remove-image-pdf";
    }
}

