/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.security.SignatureValidationRequest;
import stirling.software.SPDF.model.api.security.SignatureValidationResult;
import stirling.software.SPDF.service.CertificateValidationService;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;

@RestController
@RequestMapping(value={"/api/v1/security"})
@Tag(name="Security", description="Security APIs")
public class ValidateSignatureController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final CertificateValidationService certValidationService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MultipartFile.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Operation(summary="Validate PDF Digital Signature", description="Validates the digital signatures in a PDF file against default or custom certificates. Input:PDF Output:JSON Type:SISO")
    @PostMapping(value={"/validate-signature"}, consumes={"multipart/form-data"})
    public ResponseEntity<List<SignatureValidationResult>> validateSignature(@ModelAttribute SignatureValidationRequest request) throws IOException {
        ArrayList<SignatureValidationResult> results = new ArrayList<SignatureValidationResult>();
        MultipartFile file = request.getFileInput();
        MultipartFile certFile = request.getCertFile();
        X509Certificate customCert = null;
        if (certFile != null && !certFile.isEmpty()) {
            try (ByteArrayInputStream certStream = new ByteArrayInputStream(certFile.getBytes());){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                customCert = (X509Certificate)cf.generateCertificate(certStream);
            }
            catch (CertificateException e) {
                throw ExceptionUtils.createRuntimeException((String)"error.invalidFormat", (String)"Invalid {0} format: {1}", (Exception)e, (Object[])new Object[]{"certificate file", e.getMessage()});
            }
        }
        try (PDDocument document = this.pdfDocumentFactory.load(file.getInputStream());){
            List signatures = document.getSignatureDictionaries();
            for (PDSignature sig : signatures) {
                SignatureValidationResult result = new SignatureValidationResult();
                try {
                    byte[] signedContent = sig.getSignedContent(file.getInputStream());
                    byte[] signatureBytes = sig.getContents(file.getInputStream());
                    CMSProcessableByteArray content = new CMSProcessableByteArray(signedContent);
                    CMSSignedData signedData = new CMSSignedData((CMSProcessable)content, signatureBytes);
                    Store certStore = signedData.getCertificates();
                    SignerInformationStore signerStore = signedData.getSignerInfos();
                    for (SignerInformation signer : signerStore.getSigners()) {
                        X509CertificateHolder certHolder = (X509CertificateHolder)certStore.getMatches((Selector)signer.getSID()).iterator().next();
                        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
                        boolean isValid = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert));
                        result.setValid(isValid);
                        result.setChainValid(customCert != null ? this.certValidationService.validateCertificateChainWithCustomCert(cert, customCert) : this.certValidationService.validateCertificateChain(cert));
                        result.setTrustValid(customCert != null ? this.certValidationService.validateTrustWithCustomCert(cert, customCert) : this.certValidationService.validateTrustStore(cert));
                        result.setNotRevoked(!this.certValidationService.isRevoked(cert));
                        result.setNotExpired(Instant.now().isBefore(cert.getNotAfter().toInstant()));
                        result.setSignerName(sig.getName());
                        result.setSignatureDate(sig.getSignDate().toInstant().toString());
                        result.setReason(sig.getReason());
                        result.setLocation(sig.getLocation());
                        result.setIssuerDN(cert.getIssuerX500Principal().getName());
                        result.setSubjectDN(cert.getSubjectX500Principal().getName());
                        result.setSerialNumber(cert.getSerialNumber().toString(16));
                        result.setValidFrom(cert.getNotBefore().toString());
                        result.setValidUntil(cert.getNotAfter().toString());
                        result.setSignatureAlgorithm(cert.getSigAlgName());
                        try {
                            result.setKeySize(((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength());
                        }
                        catch (Exception e) {
                            result.setKeySize(0);
                        }
                        result.setVersion(String.valueOf(cert.getVersion()));
                        ArrayList<String> keyUsages = new ArrayList<String>();
                        boolean[] keyUsageFlags = cert.getKeyUsage();
                        if (keyUsageFlags != null) {
                            String[] keyUsageLabels = new String[]{"Digital Signature", "Non-Repudiation", "Key Encipherment", "Data Encipherment", "Key Agreement", "Certificate Signing", "CRL Signing", "Encipher Only", "Decipher Only"};
                            for (int i = 0; i < keyUsageFlags.length; ++i) {
                                if (!keyUsageFlags[i]) continue;
                                keyUsages.add(keyUsageLabels[i]);
                            }
                        }
                        result.setKeyUsages(keyUsages);
                        result.setSelfSigned(cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal()));
                    }
                }
                catch (Exception e) {
                    result.setValid(false);
                    result.setErrorMessage("Signature validation failed: " + e.getMessage());
                }
                results.add(result);
            }
        }
        return ResponseEntity.ok(results);
    }

    @Generated
    public ValidateSignatureController(CustomPDFDocumentFactory pdfDocumentFactory, CertificateValidationService certValidationService) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.certValidationService = certValidationService;
    }
}

