/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/security"})
@Tag(name="Security", description="Security APIs")
public class RemoveCertSignController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @PostMapping(consumes={"multipart/form-data"}, value={"/remove-cert-sign"})
    @Operation(summary="Remove digital signature from PDF", description="This endpoint accepts a PDF file and returns the PDF file without the digital signature. Input:PDF, Output:PDF Type:SISO")
    public ResponseEntity<byte[]> removeCertSignPDF(@ModelAttribute PDFFile request) throws Exception {
        List<PDField> fieldsToRemove;
        MultipartFile pdf = request.getFileInput();
        PDDocument document = this.pdfDocumentFactory.load(pdf);
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDAcroForm acroForm = catalog.getAcroForm();
        if (acroForm != null && !(fieldsToRemove = acroForm.getFields().stream().filter(field -> field instanceof PDSignatureField).toList()).isEmpty()) {
            acroForm.flatten(fieldsToRemove, false);
        }
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)pdf.getOriginalFilename(), (String)"_unsigned.pdf"));
    }

    @Generated
    public RemoveCertSignController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

