/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.Color;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.security.RedactController;
import stirling.software.SPDF.model.PDFText;
import stirling.software.SPDF.model.api.security.ManualRedactPdfRequest;
import stirling.software.SPDF.model.api.security.RedactPdfRequest;
import stirling.software.SPDF.pdf.TextFinder;
import stirling.software.SPDF.utils.text.TextEncodingHelper;
import stirling.software.SPDF.utils.text.TextFinderUtils;
import stirling.software.SPDF.utils.text.WidthCalculator;
import stirling.software.common.model.api.security.RedactionArea;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PdfUtils;
import stirling.software.common.util.WebResponseUtils;
import stirling.software.common.util.propertyeditor.StringToArrayListPropertyEditor;

@RestController
@RequestMapping(value={"/api/v1/security"})
@Tag(name="Security", description="Security APIs")
public class RedactController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedactController.class);
    private static final float DEFAULT_TEXT_PADDING_MULTIPLIER = 0.6f;
    private static final float PRECISION_THRESHOLD = 0.001f;
    private static final int FONT_SCALE_FACTOR = 1000;
    private static final float REDACTION_WIDTH_REDUCTION_FACTOR = 0.9f;
    private static final Set<String> TEXT_SHOWING_OPERATORS = Set.of("Tj", "TJ", "'", "\"");
    private static final COSString EMPTY_COS_STRING = new COSString("");
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    private String removeFileExtension(String filename) {
        return GeneralUtils.removeExtension((String)filename);
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(List.class, "redactions", (PropertyEditor)new StringToArrayListPropertyEditor());
    }

    @PostMapping(value={"/redact"}, consumes={"multipart/form-data"})
    @Operation(summary="Redact PDF manually", description="This endpoint redacts content from a PDF file based on manually specified areas. Users can specify areas to redact and optionally convert the PDF to an image. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> redactPDF(@ModelAttribute ManualRedactPdfRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        List redactionAreas = request.getRedactions();
        PDDocument document = this.pdfDocumentFactory.load(file);
        PDPageTree allPages = document.getDocumentCatalog().getPages();
        this.redactPages(request, document, allPages);
        this.redactAreas(redactionAreas, document, allPages);
        if (Boolean.TRUE.equals(request.getConvertPDFToImage())) {
            try (PDDocument convertedPdf = PdfUtils.convertPdfToPdfImage((PDDocument)document);){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                convertedPdf.save((OutputStream)baos);
                byte[] pdfContent = baos.toByteArray();
                ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)(this.removeFileExtension(Objects.requireNonNull(Filenames.toSimpleFileName((String)file.getOriginalFilename()))) + "_redacted.pdf"));
                return responseEntity;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        document.save((OutputStream)baos);
        byte[] pdfContent = baos.toByteArray();
        ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)(this.removeFileExtension(Objects.requireNonNull(Filenames.toSimpleFileName((String)file.getOriginalFilename()))) + "_redacted.pdf"));
        return responseEntity;
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private void redactAreas(List<RedactionArea> redactionAreas, PDDocument document, PDPageTree allPages) throws IOException {
        if (redactionAreas == null || redactionAreas.isEmpty()) {
            return;
        }
        HashMap<Integer, List> redactionsByPage = new HashMap<Integer, List>();
        for (RedactionArea redactionArea : redactionAreas) {
            if (redactionArea.getPage() == null || redactionArea.getPage() <= 0 || redactionArea.getHeight() == null || redactionArea.getHeight() <= 0.0 || redactionArea.getWidth() == null || redactionArea.getWidth() <= 0.0) continue;
            redactionsByPage.computeIfAbsent(redactionArea.getPage(), k -> new ArrayList()).add(redactionArea);
        }
        for (Map.Entry entry : redactionsByPage.entrySet()) {
            Integer pageNumber = (Integer)entry.getKey();
            List areasForPage = (List)entry.getValue();
            if (pageNumber > allPages.getCount()) continue;
            PDPage page = allPages.get(pageNumber - 1);
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                contentStream.saveGraphicsState();
                for (RedactionArea redactionArea : areasForPage) {
                    Color redactColor = this.decodeOrDefault(redactionArea.getColor());
                    contentStream.setNonStrokingColor(redactColor);
                    float x = redactionArea.getX().floatValue();
                    float y = redactionArea.getY().floatValue();
                    float width = redactionArea.getWidth().floatValue();
                    float height = redactionArea.getHeight().floatValue();
                    float pdfY = page.getBBox().getHeight() - y - height;
                    contentStream.addRect(x, pdfY, width, height);
                    contentStream.fill();
                }
                contentStream.restoreGraphicsState();
            }
        }
    }

    private void redactPages(ManualRedactPdfRequest request, PDDocument document, PDPageTree allPages) throws IOException {
        Color redactColor = this.decodeOrDefault(request.getPageRedactionColor());
        List pageNumbers = this.getPageNumbers(request, allPages.getCount());
        for (Integer pageNumber : pageNumbers) {
            PDPage page = allPages.get(pageNumber.intValue());
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                contentStream.setNonStrokingColor(redactColor);
                PDRectangle box = page.getBBox();
                contentStream.addRect(0.0f, 0.0f, box.getWidth(), box.getHeight());
                contentStream.fill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redactFoundText(PDDocument document, List<PDFText> blocks, float customPadding, Color redactColor, boolean isTextRemovalMode) throws IOException {
        PDPageTree allPages = document.getDocumentCatalog().getPages();
        HashMap<Integer, List> blocksByPage = new HashMap<Integer, List>();
        for (PDFText pDFText : blocks) {
            blocksByPage.computeIfAbsent(pDFText.getPageIndex(), k -> new ArrayList()).add(pDFText);
        }
        for (Map.Entry entry : blocksByPage.entrySet()) {
            Integer pageIndex = (Integer)entry.getKey();
            List pageBlocks = (List)entry.getValue();
            if (pageIndex >= allPages.getCount()) continue;
            PDPage page = allPages.get(pageIndex.intValue());
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                contentStream.saveGraphicsState();
                try {
                    contentStream.setNonStrokingColor(redactColor);
                    PDRectangle pageBox = page.getBBox();
                    for (PDFText block : pageBlocks) {
                        float boxX;
                        float boxWidth;
                        float padding = (block.getY2() - block.getY1()) * 0.6f + customPadding;
                        float originalWidth = block.getX2() - block.getX1();
                        if (isTextRemovalMode) {
                            boxWidth = originalWidth * 0.9f;
                            float widthReduction = originalWidth - boxWidth;
                            boxX = block.getX1() + widthReduction / 2.0f;
                        } else {
                            boxWidth = originalWidth;
                            boxX = block.getX1();
                        }
                        contentStream.addRect(boxX, pageBox.getHeight() - block.getY2() - padding, boxWidth, block.getY2() - block.getY1() + 2.0f * padding);
                    }
                    contentStream.fill();
                }
                finally {
                    contentStream.restoreGraphicsState();
                }
            }
        }
    }

    String createPlaceholderWithFont(String originalWord, PDFont font) {
        if (originalWord == null || originalWord.isEmpty()) {
            return originalWord;
        }
        if (font != null && TextEncodingHelper.isFontSubset((String)font.getName())) {
            try {
                float originalWidth = this.safeGetStringWidth(font, originalWord) / 1000.0f;
                return this.createAlternativePlaceholder(originalWord, originalWidth, font, 1.0f);
            }
            catch (Exception e) {
                log.debug("Subset font placeholder creation failed for {}: {}", (Object)font.getName(), (Object)e.getMessage());
                return "";
            }
        }
        return " ".repeat(originalWord.length());
    }

    String createPlaceholderWithWidth(String originalWord, float targetWidth, PDFont font, float fontSize) {
        if (originalWord == null || originalWord.isEmpty()) {
            return originalWord;
        }
        if (font == null || fontSize <= 0.0f) {
            return " ".repeat(originalWord.length());
        }
        try {
            if (!WidthCalculator.isWidthCalculationReliable((PDFont)font)) {
                log.debug("Font {} unreliable for width calculation, using simple placeholder", (Object)font.getName());
                return " ".repeat(originalWord.length());
            }
            if (TextEncodingHelper.isFontSubset((String)font.getName())) {
                return this.createSubsetFontPlaceholder(originalWord, targetWidth, font, fontSize);
            }
            float spaceWidth = WidthCalculator.calculateAccurateWidth((PDFont)font, (String)" ", (float)fontSize);
            if (spaceWidth <= 0.0f) {
                return this.createAlternativePlaceholder(originalWord, targetWidth, font, fontSize);
            }
            int spaceCount = Math.max(1, Math.round(targetWidth / spaceWidth));
            int maxSpaces = Math.max(originalWord.length() * 2, Math.round(targetWidth / spaceWidth * 1.5f));
            spaceCount = Math.min(spaceCount, maxSpaces);
            return " ".repeat(spaceCount);
        }
        catch (Exception e) {
            log.debug("Enhanced placeholder creation failed: {}", (Object)e.getMessage());
            return this.createAlternativePlaceholder(originalWord, targetWidth, font, fontSize);
        }
    }

    private String createSubsetFontPlaceholder(String originalWord, float targetWidth, PDFont font, float fontSize) {
        try {
            log.debug("Subset font {} - trying to find replacement characters", (Object)font.getName());
            String result = this.createAlternativePlaceholder(originalWord, targetWidth, font, fontSize);
            if (result.isEmpty()) {
                log.debug("Subset font {} has no suitable replacement characters, using empty string", (Object)font.getName());
            }
            return result;
        }
        catch (Exception e) {
            log.debug("Subset font placeholder creation failed: {}", (Object)e.getMessage());
            return "";
        }
    }

    private String createAlternativePlaceholder(String originalWord, float targetWidth, PDFont font, float fontSize) {
        try {
            float spaceWidth;
            String[] alternatives = new String[]{" ", ".", "-", "_", "~", "\u00b0", "\u00b7"};
            if (TextEncodingHelper.fontSupportsCharacter((PDFont)font, (String)" ") && (spaceWidth = this.safeGetStringWidth(font, " ") / 1000.0f * fontSize) > 0.0f) {
                int spaceCount = Math.max(1, Math.round(targetWidth / spaceWidth));
                int maxSpaces = originalWord.length() * 2;
                spaceCount = Math.min(spaceCount, maxSpaces);
                log.debug("Using spaces for font {}", (Object)font.getName());
                return " ".repeat(spaceCount);
            }
            for (String altChar : alternatives) {
                if (" ".equals(altChar)) continue;
                try {
                    float charWidth;
                    if (!TextEncodingHelper.fontSupportsCharacter((PDFont)font, (String)altChar) || !((charWidth = this.safeGetStringWidth(font, altChar) / 1000.0f * fontSize) > 0.0f)) continue;
                    int charCount = Math.max(1, Math.round(targetWidth / charWidth));
                    int maxChars = originalWord.length() * 2;
                    charCount = Math.min(charCount, maxChars);
                    log.debug("Using character '{}' for width calculation but spaces for placeholder in font {}", (Object)altChar, (Object)font.getName());
                    return " ".repeat(charCount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            log.debug("All placeholder alternatives failed for font {}, using empty string", (Object)font.getName());
            return "";
        }
        catch (Exception e) {
            log.debug("Alternative placeholder creation failed: {}", (Object)e.getMessage());
            return "";
        }
    }

    void writeFilteredContentStream(PDDocument document, PDPage page, List<Object> tokens) throws IOException {
        PDStream newStream = new PDStream(document);
        try {
            try (OutputStream out = newStream.createOutputStream();){
                ContentStreamWriter writer = new ContentStreamWriter(out);
                writer.writeTokens(tokens);
            }
            page.setContents(newStream);
        }
        catch (IOException e) {
            throw new IOException("Failed to write filtered content stream to page", e);
        }
    }

    Color decodeOrDefault(String hex) {
        if (hex == null) {
            return Color.BLACK;
        }
        Object colorString = hex.startsWith("#") ? hex : "#" + hex;
        try {
            return Color.decode((String)colorString);
        }
        catch (NumberFormatException e) {
            return Color.BLACK;
        }
    }

    boolean isTextShowingOperator(String opName) {
        return TEXT_SHOWING_OPERATORS.contains(opName);
    }

    private List<Integer> getPageNumbers(ManualRedactPdfRequest request, int pagesCount) {
        String pageNumbersInput = request.getPageNumbers();
        String[] parsedPageNumbers = pageNumbersInput != null ? pageNumbersInput.split(",") : new String[]{};
        List pageNumbers = GeneralUtils.parsePageList((String[])parsedPageNumbers, (int)pagesCount, (boolean)false);
        Collections.sort(pageNumbers);
        return pageNumbers;
    }

    @PostMapping(value={"/auto-redact"}, consumes={"multipart/form-data"})
    @Operation(summary="Redact PDF automatically", description="This endpoint automatically redacts text from a PDF file based on specified patterns. Users can provide text patterns to redact, with options for regex and whole word matching. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> redactPdf(@ModelAttribute RedactPdfRequest request) {
        String[] listOfText = request.getListOfText().split("\n");
        boolean useRegex = Boolean.TRUE.equals(request.getUseRegex());
        boolean wholeWordSearchBool = Boolean.TRUE.equals(request.getWholeWordSearch());
        if (listOfText.length == 0 || listOfText.length == 1 && listOfText[0].trim().isEmpty()) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.redaction.no.patterns", (String)"No text patterns provided for redaction", (Object[])new Object[0]);
        }
        PDDocument document = null;
        PDDocument fallbackDocument = null;
        try {
            boolean fallbackToBoxOnlyMode;
            if (request.getFileInput() == null) {
                log.error("File input is null");
                throw ExceptionUtils.createFileNullOrEmptyException();
            }
            document = this.pdfDocumentFactory.load(request.getFileInput());
            if (document == null) {
                log.error("Failed to load PDF document");
                throw ExceptionUtils.createPdfCorruptedException((String)"during redaction", (Exception)new IOException("Failed to load PDF document"));
            }
            Map allFoundTextsByPage = this.findTextToRedact(document, listOfText, useRegex, wholeWordSearchBool);
            int totalMatches = allFoundTextsByPage.values().stream().mapToInt(List::size).sum();
            log.info("Redaction scan: {} occurrences across {} pages (patterns={}, regex={}, wholeWord={})", new Object[]{totalMatches, allFoundTextsByPage.size(), listOfText.length, useRegex, wholeWordSearchBool});
            if (allFoundTextsByPage.isEmpty()) {
                byte[] originalContent;
                log.info("No text found matching redaction patterns");
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    document.save((OutputStream)baos);
                    originalContent = baos.toByteArray();
                }
                baos = WebResponseUtils.bytesToWebResponse((byte[])originalContent, (String)(this.removeFileExtension(Objects.requireNonNull(Filenames.toSimpleFileName((String)request.getFileInput().getOriginalFilename()))) + "_redacted.pdf"));
                return baos;
            }
            try {
                fallbackToBoxOnlyMode = this.performTextReplacement(document, allFoundTextsByPage, listOfText, useRegex, wholeWordSearchBool);
            }
            catch (Exception e) {
                log.warn("Text replacement redaction failed, falling back to box-only mode: {}", (Object)e.getMessage());
                fallbackToBoxOnlyMode = true;
            }
            if (fallbackToBoxOnlyMode) {
                log.warn("Font compatibility issues detected. Using box-only redaction mode for better reliability.");
                fallbackDocument = this.pdfDocumentFactory.load(request.getFileInput());
                allFoundTextsByPage = this.findTextToRedact(fallbackDocument, listOfText, useRegex, wholeWordSearchBool);
                byte[] pdfContent = this.finalizeRedaction(fallbackDocument, allFoundTextsByPage, request.getRedactColor(), request.getCustomPadding(), request.getConvertPDFToImage(), false);
                ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)(this.removeFileExtension(Objects.requireNonNull(Filenames.toSimpleFileName((String)request.getFileInput().getOriginalFilename()))) + "_redacted.pdf"));
                return responseEntity;
            }
            byte[] pdfContent = this.finalizeRedaction(document, allFoundTextsByPage, request.getRedactColor(), request.getCustomPadding(), request.getConvertPDFToImage(), true);
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)(this.removeFileExtension(Objects.requireNonNull(Filenames.toSimpleFileName((String)request.getFileInput().getOriginalFilename()))) + "_redacted.pdf"));
            return responseEntity;
        }
        catch (Exception e) {
            log.error("Redaction operation failed: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to perform PDF redaction: " + e.getMessage(), e);
        }
        finally {
            if (document != null) {
                try {
                    if (fallbackDocument == null) {
                        document.close();
                    }
                }
                catch (IOException e) {
                    log.warn("Failed to close main document: {}", (Object)e.getMessage());
                }
            }
            if (fallbackDocument != null) {
                try {
                    fallbackDocument.close();
                }
                catch (IOException e) {
                    log.warn("Failed to close fallback document: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private Map<Integer, List<PDFText>> findTextToRedact(PDDocument document, String[] listOfText, boolean useRegex, boolean wholeWordSearch) {
        HashMap<Integer, List<PDFText>> allFoundTextsByPage = new HashMap<Integer, List<PDFText>>();
        for (String text : listOfText) {
            if ((text = text.trim()).isEmpty()) continue;
            log.debug("Searching for text: '{}' (regex: {}, wholeWord: {})", new Object[]{text, useRegex, wholeWordSearch});
            try {
                TextFinder textFinder = new TextFinder(text, useRegex, wholeWordSearch);
                textFinder.getText(document);
                List foundTexts = textFinder.getFoundTexts();
                log.debug("TextFinder found {} instances of '{}'", (Object)foundTexts.size(), (Object)text);
                for (PDFText found : foundTexts) {
                    allFoundTextsByPage.computeIfAbsent(found.getPageIndex(), k -> new ArrayList()).add(found);
                    log.debug("Added match on page {} at ({},{},{},{}): '{}'", new Object[]{found.getPageIndex(), Float.valueOf(found.getX1()), Float.valueOf(found.getY1()), Float.valueOf(found.getX2()), Float.valueOf(found.getY2()), found.getText()});
                }
            }
            catch (Exception e) {
                log.error("Error processing search term '{}': {}", (Object)text, (Object)e.getMessage());
            }
        }
        return allFoundTextsByPage;
    }

    private boolean performTextReplacement(PDDocument document, Map<Integer, List<PDFText>> allFoundTextsByPage, String[] listOfText, boolean useRegex, boolean wholeWordSearchBool) {
        if (allFoundTextsByPage.isEmpty()) {
            return false;
        }
        if (this.detectCustomEncodingFonts(document)) {
            log.warn("Custom encoded fonts detected (non-standard encodings / DictionaryEncoding / damaged fonts). Text replacement is unreliable for these fonts. Falling back to box-only redaction mode.");
            return true;
        }
        try {
            Set allSearchTerms = Arrays.stream(listOfText).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
            int pageCount = 0;
            for (PDPage page : document.getPages()) {
                ++pageCount;
                List filteredTokens = this.createTokensWithoutTargetText(document, page, allSearchTerms, useRegex, wholeWordSearchBool);
                this.writeFilteredContentStream(document, page, filteredTokens);
            }
            log.info("Successfully performed text replacement redaction on {} pages.", (Object)pageCount);
            return false;
        }
        catch (Exception e) {
            log.error("Text replacement redaction failed due to font or encoding issues. Will fall back to box-only redaction mode. Error: {}", (Object)e.getMessage());
            return true;
        }
    }

    private byte[] finalizeRedaction(PDDocument document, Map<Integer, List<PDFText>> allFoundTextsByPage, String colorString, float customPadding, Boolean convertToImage, boolean isTextRemovalMode) throws IOException {
        ArrayList<PDFText> allFoundTexts = new ArrayList<PDFText>();
        for (List<PDFText> pageTexts : allFoundTextsByPage.values()) {
            allFoundTexts.addAll(pageTexts);
        }
        if (!allFoundTexts.isEmpty()) {
            Color redactColor = this.decodeOrDefault(colorString);
            this.redactFoundText(document, allFoundTexts, customPadding, redactColor, isTextRemovalMode);
            this.cleanDocumentMetadata(document);
        }
        if (Boolean.TRUE.equals(convertToImage)) {
            try (PDDocument convertedPdf = PdfUtils.convertPdfToPdfImage((PDDocument)document);){
                this.cleanDocumentMetadata(convertedPdf);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                convertedPdf.save((OutputStream)baos);
                byte[] out = baos.toByteArray();
                log.info("Redaction finalized (image mode): {} pages \u279c {} KB", (Object)convertedPdf.getNumberOfPages(), (Object)(out.length / 1024));
                byte[] byArray = out;
                return byArray;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        document.save((OutputStream)baos);
        byte[] out = baos.toByteArray();
        log.info("Redaction finalized: {} pages \u279c {} KB", (Object)document.getNumberOfPages(), (Object)(out.length / 1024));
        return out;
    }

    private void cleanDocumentMetadata(PDDocument document) {
        try {
            PDDocumentInformation documentInfo = document.getDocumentInformation();
            if (documentInfo != null) {
                documentInfo.setAuthor(null);
                documentInfo.setSubject(null);
                documentInfo.setKeywords(null);
                documentInfo.setModificationDate(Calendar.getInstance());
                log.debug("Cleaned document metadata for security");
            }
            if (document.getDocumentCatalog() != null) {
                try {
                    document.getDocumentCatalog().setMetadata(null);
                }
                catch (Exception e) {
                    log.debug("Could not clear XMP metadata: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to clean document metadata: {}", (Object)e.getMessage());
        }
    }

    List<Object> createTokensWithoutTargetText(PDDocument document, PDPage page, Set<String> targetWords, boolean useRegex, boolean wholeWordSearch) throws IOException {
        Object token;
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        ArrayList<Object> tokens = new ArrayList<Object>();
        while ((token = parser.parseNextToken()) != null) {
            tokens.add(token);
        }
        PDResources resources = page.getResources();
        if (resources != null) {
            this.processPageXObjects(document, resources, targetWords, useRegex, wholeWordSearch);
        }
        List textSegments = this.extractTextSegments(page, tokens);
        String completeText = this.buildCompleteText(textSegments);
        List matches = this.findAllMatches(completeText, targetWords, useRegex, wholeWordSearch);
        return this.applyRedactionsToTokens(tokens, textSegments, matches);
    }

    private void processPageXObjects(PDDocument document, PDResources resources, Set<String> targetWords, boolean useRegex, boolean wholeWordSearch) {
        for (COSName xobjName : resources.getXObjectNames()) {
            try {
                PDXObject xobj = resources.getXObject(xobjName);
                if (!(xobj instanceof PDFormXObject)) continue;
                PDFormXObject formXObj = (PDFormXObject)xobj;
                this.processFormXObject(document, formXObj, targetWords, useRegex, wholeWordSearch);
                log.debug("Processed Form XObject: {}", (Object)xobjName.getName());
            }
            catch (Exception e) {
                log.warn("Failed to process XObject {}: {}", (Object)xobjName.getName(), (Object)e.getMessage());
            }
        }
    }

    private List<TextSegment> extractTextSegments(PDPage page, List<Object> tokens) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        int currentTextPos = 0;
        GraphicsState graphicsState = new GraphicsState();
        PDResources resources = page.getResources();
        for (int i = 0; i < tokens.size(); ++i) {
            Object currentToken = tokens.get(i);
            if (!(currentToken instanceof Operator)) continue;
            Operator op = (Operator)currentToken;
            String opName = op.getName();
            if ("Tf".equals(opName) && i >= 2) {
                try {
                    COSName fontName = (COSName)tokens.get(i - 2);
                    COSBase fontSizeBase = (COSBase)tokens.get(i - 1);
                    if (fontSizeBase instanceof COSNumber) {
                        COSNumber cosNumber = (COSNumber)fontSizeBase;
                        graphicsState.setFont(resources.getFont(fontName));
                        graphicsState.setFontSize(cosNumber.floatValue());
                    }
                }
                catch (IOException | ClassCastException e) {
                    log.debug("Failed to extract font and font size from Tf operator: {}", (Object)e.getMessage());
                }
            }
            currentTextPos = this.getCurrentTextPos(tokens, segments, currentTextPos, graphicsState, i, opName);
        }
        return segments;
    }

    private String buildCompleteText(List<TextSegment> segments) {
        StringBuilder sb = new StringBuilder();
        for (TextSegment segment : segments) {
            sb.append(segment.text);
        }
        return sb.toString();
    }

    private List<MatchRange> findAllMatches(String completeText, Set<String> targetWords, boolean useRegex, boolean wholeWordSearch) {
        List patterns = TextFinderUtils.createOptimizedSearchPatterns(targetWords, (boolean)useRegex, (boolean)wholeWordSearch);
        return patterns.stream().flatMap(pattern -> {
            try {
                return pattern.matcher(completeText).results();
            }
            catch (Exception e) {
                log.debug("Pattern matching failed for pattern {}: {}", (Object)pattern.pattern(), (Object)e.getMessage());
                return Stream.empty();
            }
        }).map(matchResult -> new MatchRange(matchResult.start(), matchResult.end())).sorted(Comparator.comparingInt(MatchRange::getStartPos)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> applyRedactionsToTokens(List<Object> tokens, List<TextSegment> textSegments, List<MatchRange> matches) {
        long startTime = System.currentTimeMillis();
        try {
            ArrayList<Object> newTokens = new ArrayList<Object>(tokens);
            HashMap matchesBySegment = new HashMap();
            for (MatchRange match : matches) {
                for (int i = 0; i < textSegments.size(); ++i) {
                    int overlapEnd;
                    TextSegment segment = textSegments.get(i);
                    int overlapStart = Math.max(match.startPos, segment.startPos);
                    if (overlapStart >= (overlapEnd = Math.min(match.endPos, segment.endPos))) continue;
                    matchesBySegment.computeIfAbsent(i, k -> new ArrayList()).add(match);
                }
            }
            ArrayList<ModificationTask> tasks = new ArrayList<ModificationTask>();
            for (Map.Entry entry : matchesBySegment.entrySet()) {
                int segmentIndex = (Integer)entry.getKey();
                List segmentMatches = (List)entry.getValue();
                TextSegment segment = textSegments.get(segmentIndex);
                if ("Tj".equals(segment.operatorName) || "'".equals(segment.operatorName)) {
                    String newText = this.applyRedactionsToSegmentText(segment, segmentMatches);
                    try {
                        float adjustment = this.calculateWidthAdjustment(segment, segmentMatches);
                        tasks.add(new ModificationTask(segment, newText, adjustment));
                    }
                    catch (Exception e) {
                        log.debug("Width adjustment calculation failed for segment: {}", (Object)e.getMessage());
                    }
                    continue;
                }
                if (!"TJ".equals(segment.operatorName)) continue;
                tasks.add(new ModificationTask(segment, null, 0.0f));
            }
            tasks.sort((a, b) -> Integer.compare(b.segment.tokenIndex, a.segment.tokenIndex));
            for (ModificationTask task : tasks) {
                List segmentMatches = matchesBySegment.getOrDefault(textSegments.indexOf(task.segment), Collections.emptyList());
                this.modifyTokenForRedaction(newTokens, task.segment, task.newText, task.adjustment, segmentMatches);
            }
            ArrayList<Object> arrayList = newTokens;
            return arrayList;
        }
        finally {
            long processingTime = System.currentTimeMillis() - startTime;
            log.debug("Token redaction processing completed in {} ms for {} matches", (Object)processingTime, (Object)matches.size());
        }
    }

    private String applyRedactionsToSegmentText(TextSegment segment, List<MatchRange> matches) {
        String text = segment.getText();
        if (segment.getFont() != null && !TextEncodingHelper.isTextSegmentRemovable((PDFont)segment.getFont(), (String)text)) {
            log.debug("Skipping text segment '{}' - font {} cannot process this text reliably", (Object)text, (Object)segment.getFont().getName());
            return text;
        }
        StringBuilder result = new StringBuilder(text);
        for (MatchRange match : matches) {
            int segmentStart = Math.max(0, match.getStartPos() - segment.getStartPos());
            int segmentEnd = Math.min(text.length(), match.getEndPos() - segment.getStartPos());
            if (segmentStart >= text.length() || segmentEnd <= segmentStart) continue;
            String originalPart = text.substring(segmentStart, segmentEnd);
            if (segment.getFont() != null && !TextEncodingHelper.isTextSegmentRemovable((PDFont)segment.getFont(), (String)originalPart)) {
                log.debug("Skipping text part '{}' within segment - cannot be processed reliably", (Object)originalPart);
                continue;
            }
            float originalWidth = 0.0f;
            if (segment.getFont() != null && segment.getFontSize() > 0.0f) {
                try {
                    originalWidth = this.safeGetStringWidth(segment.getFont(), originalPart) / 1000.0f * segment.getFontSize();
                }
                catch (Exception e) {
                    log.debug("Failed to calculate original width for placeholder: {}", (Object)e.getMessage());
                }
            }
            String placeholder = originalWidth > 0.0f ? this.createPlaceholderWithWidth(originalPart, originalWidth, segment.getFont(), segment.getFontSize()) : this.createPlaceholderWithFont(originalPart, segment.getFont());
            result.replace(segmentStart, segmentEnd, placeholder);
        }
        return result.toString();
    }

    private float safeGetStringWidth(PDFont font, String text) {
        if (font == null || text == null || text.isEmpty()) {
            return 0.0f;
        }
        if (!WidthCalculator.isWidthCalculationReliable((PDFont)font)) {
            log.debug("Font {} flagged as unreliable for width calculation, using fallback", (Object)font.getName());
            return this.calculateConservativeWidth(font, text);
        }
        if (!TextEncodingHelper.canEncodeCharacters((PDFont)font, (String)text)) {
            log.debug("Text cannot be encoded by font {}, using character-based fallback", (Object)font.getName());
            return this.calculateCharacterBasedWidth(font, text);
        }
        try {
            float width = font.getStringWidth(text);
            log.debug("Direct width calculation successful for '{}': {}", (Object)text, (Object)Float.valueOf(width));
            return width;
        }
        catch (Exception e) {
            log.debug("Direct width calculation failed for font {}: {}", (Object)font.getName(), (Object)e.getMessage());
            return this.calculateFallbackWidth(font, text);
        }
    }

    private float calculateCharacterBasedWidth(PDFont font, String text) {
        try {
            float totalWidth = 0.0f;
            for (int i = 0; i < text.length(); ++i) {
                String character = text.substring(i, i + 1);
                try {
                    if (!TextEncodingHelper.fontSupportsCharacter((PDFont)font, (String)character)) {
                        totalWidth += font.getAverageFontWidth();
                        continue;
                    }
                    byte[] encoded = font.encode(character);
                    if (encoded.length > 0) {
                        int glyphCode = encoded[0] & 0xFF;
                        float glyphWidth = font.getWidth(glyphCode);
                        if (glyphWidth == 0.0f) {
                            try {
                                glyphWidth = font.getWidthFromFont(glyphCode);
                            }
                            catch (Exception e2) {
                                glyphWidth = font.getAverageFontWidth();
                            }
                        }
                        totalWidth += glyphWidth;
                        continue;
                    }
                    totalWidth += font.getAverageFontWidth();
                    continue;
                }
                catch (Exception e2) {
                    totalWidth += font.getAverageFontWidth();
                }
            }
            log.debug("Character-based width calculation: {}", (Object)Float.valueOf(totalWidth));
            return totalWidth;
        }
        catch (Exception e) {
            log.debug("Character-based width calculation failed: {}", (Object)e.getMessage());
            return this.calculateConservativeWidth(font, text);
        }
    }

    private float calculateFallbackWidth(PDFont font, String text) {
        try {
            if (font.getFontDescriptor() != null && font.getFontDescriptor().getFontBoundingBox() != null) {
                PDRectangle bbox = font.getFontDescriptor().getFontBoundingBox();
                float avgCharWidth = bbox.getWidth() * 0.6f;
                float fallbackWidth = (float)text.length() * avgCharWidth;
                log.debug("Bounding box fallback width: {}", (Object)Float.valueOf(fallbackWidth));
                return fallbackWidth;
            }
            try {
                float avgWidth = font.getAverageFontWidth();
                if (avgWidth > 0.0f) {
                    float fallbackWidth = (float)text.length() * avgWidth;
                    log.debug("Average width fallback: {}", (Object)Float.valueOf(fallbackWidth));
                    return fallbackWidth;
                }
            }
            catch (Exception e2) {
                log.debug("Average font width calculation failed: {}", (Object)e2.getMessage());
            }
            return this.calculateConservativeWidth(font, text);
        }
        catch (Exception e) {
            log.debug("Fallback width calculation failed: {}", (Object)e.getMessage());
            return this.calculateConservativeWidth(font, text);
        }
    }

    private float calculateConservativeWidth(PDFont font, String text) {
        float conservativeWidth = (float)text.length() * 500.0f;
        log.debug("Conservative width estimate for font {} text '{}': {}", new Object[]{font.getName(), text, Float.valueOf(conservativeWidth)});
        return conservativeWidth;
    }

    private float calculateWidthAdjustment(TextSegment segment, List<MatchRange> matches) {
        try {
            if (segment.getFont() == null || segment.getFontSize() <= 0.0f) {
                return 0.0f;
            }
            String fontName = segment.getFont().getName();
            if (fontName != null && (fontName.contains("HOEPAP") || TextEncodingHelper.isFontSubset((String)fontName))) {
                log.debug("Skipping width adjustment for problematic/subset font: {}", (Object)fontName);
                return 0.0f;
            }
            float totalOriginal = 0.0f;
            float totalPlaceholder = 0.0f;
            String text = segment.getText();
            for (MatchRange match : matches) {
                int segStart = Math.max(0, match.getStartPos() - segment.getStartPos());
                int segEnd = Math.min(text.length(), match.getEndPos() - segment.getStartPos());
                if (segStart >= text.length() || segEnd <= segStart) continue;
                String originalPart = text.substring(segStart, segEnd);
                float originalWidth = this.safeGetStringWidth(segment.getFont(), originalPart) / 1000.0f * segment.getFontSize();
                String placeholderPart = this.createPlaceholderWithWidth(originalPart, originalWidth, segment.getFont(), segment.getFontSize());
                float origUnits = this.safeGetStringWidth(segment.getFont(), originalPart);
                float placeUnits = this.safeGetStringWidth(segment.getFont(), placeholderPart);
                float orig = origUnits / 1000.0f * segment.getFontSize();
                float place = placeUnits / 1000.0f * segment.getFontSize();
                totalOriginal += orig;
                totalPlaceholder += place;
            }
            float adjustment = totalOriginal - totalPlaceholder;
            float maxReasonableAdjustment = Math.max((float)segment.getText().length() * segment.getFontSize() * 2.0f, totalOriginal * 1.5f);
            if (Math.abs(adjustment) > maxReasonableAdjustment) {
                log.debug("Width adjustment {} seems unreasonable for text length {}, capping to 0", (Object)Float.valueOf(adjustment), (Object)segment.getText().length());
                return 0.0f;
            }
            return adjustment;
        }
        catch (Exception ex) {
            log.debug("Width adjustment failed: {}", (Object)ex.getMessage());
            return 0.0f;
        }
    }

    private void modifyTokenForRedaction(List<Object> tokens, TextSegment segment, String newText, float adjustment, List<MatchRange> matches) {
        if (segment.getTokenIndex() < 0 || segment.getTokenIndex() >= tokens.size()) {
            return;
        }
        Object token = tokens.get(segment.getTokenIndex());
        String operatorName = segment.getOperatorName();
        try {
            if (("Tj".equals(operatorName) || "'".equals(operatorName)) && token instanceof COSString) {
                if (Math.abs(adjustment) < 0.001f) {
                    if (newText.isEmpty()) {
                        tokens.set(segment.getTokenIndex(), EMPTY_COS_STRING);
                    } else {
                        tokens.set(segment.getTokenIndex(), new COSString(newText));
                    }
                } else {
                    Operator op;
                    Object object;
                    COSArray newArray = new COSArray();
                    newArray.add((COSBase)new COSString(newText));
                    if (segment.getFontSize() > 0.0f) {
                        float kerning = -adjustment / segment.getFontSize() * 1000.0f;
                        newArray.add((COSBase)new COSFloat(kerning));
                    }
                    tokens.set(segment.getTokenIndex(), newArray);
                    int operatorIndex = segment.getTokenIndex() + 1;
                    if (operatorIndex < tokens.size() && (object = tokens.get(operatorIndex)) instanceof Operator && (op = (Operator)object).getName().equals(operatorName)) {
                        tokens.set(operatorIndex, Operator.getOperator((String)"TJ"));
                    }
                }
            } else if ("TJ".equals(operatorName) && token instanceof COSArray) {
                COSArray newArray = this.createRedactedTJArray((COSArray)token, segment, matches);
                tokens.set(segment.getTokenIndex(), newArray);
            }
        }
        catch (Exception e) {
            log.debug("Token modification failed for segment at index {}: {}", (Object)segment.getTokenIndex(), (Object)e.getMessage());
        }
    }

    private COSArray createRedactedTJArray(COSArray originalArray, TextSegment segment, List<MatchRange> matches) {
        try {
            COSArray newArray = new COSArray();
            int textOffsetInSegment = 0;
            for (COSBase element : originalArray) {
                if (element instanceof COSString) {
                    COSString cosString = (COSString)element;
                    String originalText = cosString.getString();
                    if (segment.getFont() != null && !TextEncodingHelper.isTextSegmentRemovable((PDFont)segment.getFont(), (String)originalText)) {
                        log.debug("Skipping TJ text part '{}' - cannot be processed reliably with font {}", (Object)originalText, (Object)segment.getFont().getName());
                        newArray.add(element);
                        textOffsetInSegment += originalText.length();
                        continue;
                    }
                    StringBuilder newText = new StringBuilder(originalText);
                    boolean modified = false;
                    for (MatchRange match : matches) {
                        int overlapEnd;
                        int stringStartInPage = segment.getStartPos() + textOffsetInSegment;
                        int stringEndInPage = stringStartInPage + originalText.length();
                        int overlapStart = Math.max(match.getStartPos(), stringStartInPage);
                        if (overlapStart >= (overlapEnd = Math.min(match.getEndPos(), stringEndInPage))) continue;
                        int redactionStartInString = overlapStart - stringStartInPage;
                        int redactionEndInString = overlapEnd - stringStartInPage;
                        if (redactionStartInString < 0 || redactionEndInString > originalText.length()) continue;
                        String originalPart = originalText.substring(redactionStartInString, redactionEndInString);
                        if (segment.getFont() != null && !TextEncodingHelper.isTextSegmentRemovable((PDFont)segment.getFont(), (String)originalPart)) {
                            log.debug("Skipping TJ text part '{}' - cannot be redacted reliably", (Object)originalPart);
                            continue;
                        }
                        modified = true;
                        float originalWidth = 0.0f;
                        if (segment.getFont() != null && segment.getFontSize() > 0.0f) {
                            try {
                                originalWidth = this.safeGetStringWidth(segment.getFont(), originalPart) / 1000.0f * segment.getFontSize();
                            }
                            catch (Exception e) {
                                log.debug("Failed to calculate original width for TJ placeholder: {}", (Object)e.getMessage());
                            }
                        }
                        String placeholder = originalWidth > 0.0f ? this.createPlaceholderWithWidth(originalPart, originalWidth, segment.getFont(), segment.getFontSize()) : this.createPlaceholderWithFont(originalPart, segment.getFont());
                        newText.replace(redactionStartInString, redactionEndInString, placeholder);
                    }
                    String modifiedString = newText.toString();
                    newArray.add((COSBase)new COSString(modifiedString));
                    if (modified && segment.getFont() != null && segment.getFontSize() > 0.0f) {
                        try {
                            float originalWidth = this.safeGetStringWidth(segment.getFont(), originalText) / 1000.0f * segment.getFontSize();
                            float modifiedWidth = this.safeGetStringWidth(segment.getFont(), modifiedString) / 1000.0f * segment.getFontSize();
                            float adjustment = originalWidth - modifiedWidth;
                            if (Math.abs(adjustment) > 0.001f) {
                                float kerning = -adjustment / segment.getFontSize() * 1000.0f * 1.1f;
                                newArray.add((COSBase)new COSFloat(kerning));
                            }
                        }
                        catch (Exception e) {
                            log.debug("Width adjustment calculation failed for segment: {}", (Object)e.getMessage());
                        }
                    }
                    textOffsetInSegment += originalText.length();
                    continue;
                }
                newArray.add(element);
            }
            return newArray;
        }
        catch (Exception e) {
            return originalArray;
        }
    }

    private String extractTextFromToken(Object token, String operatorName) {
        return switch (operatorName) {
            case "Tj", "'" -> {
                if (token instanceof COSString) {
                    COSString cosString = (COSString)token;
                    yield cosString.getString();
                }
                yield "";
            }
            case "TJ" -> {
                if (token instanceof COSArray) {
                    COSArray cosArray = (COSArray)token;
                    StringBuilder sb = new StringBuilder();
                    for (COSBase element : cosArray) {
                        if (!(element instanceof COSString)) continue;
                        COSString cosString = (COSString)element;
                        sb.append(cosString.getString());
                    }
                    yield sb.toString();
                }
                yield "";
            }
            default -> "";
        };
    }

    private boolean detectCustomEncodingFonts(PDDocument document) {
        try {
            PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
            if (documentCatalog == null) {
                return false;
            }
            int totalFonts = 0;
            int customEncodedFonts = 0;
            int subsetFonts = 0;
            int unreliableFonts = 0;
            for (PDPage page : document.getPages()) {
                PDResources resources;
                if (TextFinderUtils.hasProblematicFonts((PDPage)page)) {
                    log.debug("Page contains fonts flagged as problematic by TextFinderUtils");
                }
                if ((resources = page.getResources()) == null) continue;
                for (COSName fontName : resources.getFontNames()) {
                    try {
                        PDFont font = resources.getFont(fontName);
                        if (font == null) continue;
                        ++totalFonts;
                        boolean isSubset = TextEncodingHelper.isFontSubset((String)font.getName());
                        boolean hasCustomEncoding = TextEncodingHelper.hasCustomEncoding((PDFont)font);
                        boolean isReliable = WidthCalculator.isWidthCalculationReliable((PDFont)font);
                        boolean canCalculateWidths = TextEncodingHelper.canCalculateBasicWidths((PDFont)font);
                        if (isSubset) {
                            ++subsetFonts;
                        }
                        if (hasCustomEncoding) {
                            ++customEncodedFonts;
                            log.debug("Font {} has custom encoding", (Object)font.getName());
                        }
                        if (!isReliable || !canCalculateWidths) {
                            ++unreliableFonts;
                            log.debug("Font {} flagged as unreliable: reliable={}, canCalculateWidths={}", new Object[]{font.getName(), isReliable, canCalculateWidths});
                        }
                        if (TextFinderUtils.validateFontReliability((PDFont)font)) continue;
                        log.debug("Font {} failed comprehensive reliability check", (Object)font.getName());
                    }
                    catch (Exception e) {
                        log.debug("Font loading/analysis failed for {}: {}", (Object)fontName.getName(), (Object)e.getMessage());
                        ++customEncodedFonts;
                        ++unreliableFonts;
                        ++totalFonts;
                    }
                }
            }
            log.info("Enhanced font analysis: {}/{} custom encoding, {}/{} subset, {}/{} unreliable fonts", new Object[]{customEncodedFonts, totalFonts, subsetFonts, totalFonts, unreliableFonts, totalFonts});
            return customEncodedFonts > 0 || unreliableFonts > 0;
        }
        catch (Exception e) {
            log.warn("Enhanced font detection analysis failed: {}", (Object)e.getMessage());
            return true;
        }
    }

    private void processFormXObject(PDDocument document, PDFormXObject formXObject, Set<String> targetWords, boolean useRegex, boolean wholeWordSearch) {
        try {
            Object token;
            PDResources xobjResources = formXObject.getResources();
            if (xobjResources == null) {
                return;
            }
            for (COSName xobjName : xobjResources.getXObjectNames()) {
                PDXObject nestedXObj = xobjResources.getXObject(xobjName);
                if (!(nestedXObj instanceof PDFormXObject)) continue;
                PDFormXObject nestedFormXObj = (PDFormXObject)nestedXObj;
                this.processFormXObject(document, nestedFormXObj, targetWords, useRegex, wholeWordSearch);
            }
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)formXObject);
            ArrayList<Object> tokens = new ArrayList<Object>();
            while ((token = parser.parseNextToken()) != null) {
                tokens.add(token);
            }
            List textSegments = this.extractTextSegmentsFromXObject(xobjResources, tokens);
            String completeText = this.buildCompleteText(textSegments);
            List matches = this.findAllMatches(completeText, targetWords, useRegex, wholeWordSearch);
            if (!matches.isEmpty()) {
                List redactedTokens = this.applyRedactionsToTokens(tokens, textSegments, matches);
                this.writeRedactedContentToXObject(document, formXObject, redactedTokens);
                log.debug("Processed {} redactions in Form XObject", (Object)matches.size());
            }
        }
        catch (Exception e) {
            log.warn("Failed to process Form XObject: {}", (Object)e.getMessage());
        }
    }

    private List<TextSegment> extractTextSegmentsFromXObject(PDResources resources, List<Object> tokens) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        int currentTextPos = 0;
        GraphicsState graphicsState = new GraphicsState();
        for (int i = 0; i < tokens.size(); ++i) {
            Object currentToken = tokens.get(i);
            if (!(currentToken instanceof Operator)) continue;
            Operator op = (Operator)currentToken;
            String opName = op.getName();
            if ("Tf".equals(opName) && i >= 2) {
                try {
                    COSName fontName = (COSName)tokens.get(i - 2);
                    COSBase fontSizeBase = (COSBase)tokens.get(i - 1);
                    if (fontSizeBase instanceof COSNumber) {
                        COSNumber cosNumber = (COSNumber)fontSizeBase;
                        graphicsState.setFont(resources.getFont(fontName));
                        graphicsState.setFontSize(cosNumber.floatValue());
                    }
                }
                catch (IOException | ClassCastException e) {
                    log.debug("Font extraction failed in XObject: {}", (Object)e.getMessage());
                }
            }
            currentTextPos = this.getCurrentTextPos(tokens, segments, currentTextPos, graphicsState, i, opName);
        }
        return segments;
    }

    private int getCurrentTextPos(List<Object> tokens, List<TextSegment> segments, int currentTextPos, GraphicsState graphicsState, int i, String opName) {
        String textContent;
        if (this.isTextShowingOperator(opName) && i > 0 && !(textContent = this.extractTextFromToken(tokens.get(i - 1), opName)).isEmpty()) {
            segments.add(new TextSegment(i - 1, opName, textContent, currentTextPos, currentTextPos + textContent.length(), graphicsState.font, graphicsState.fontSize));
            currentTextPos += textContent.length();
        }
        return currentTextPos;
    }

    private void writeRedactedContentToXObject(PDDocument document, PDFormXObject formXObject, List<Object> redactedTokens) throws IOException {
        PDStream newStream = new PDStream(document);
        try (OutputStream out = newStream.createOutputStream();){
            ContentStreamWriter writer = new ContentStreamWriter(out);
            writer.writeTokens(redactedTokens);
        }
        formXObject.getCOSObject().removeItem(COSName.CONTENTS);
        formXObject.getCOSObject().setItem(COSName.CONTENTS, (COSBase)newStream.getCOSObject());
    }

    @Generated
    public RedactController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

