/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.pipeline;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.pipeline.PipelineProcessor;
import stirling.software.SPDF.model.PipelineConfig;
import stirling.software.SPDF.model.PipelineOperation;
import stirling.software.SPDF.model.PipelineResult;
import stirling.software.SPDF.model.api.HandleDataRequest;
import stirling.software.common.service.PostHogService;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/pipeline"})
@Tag(name="Pipeline", description="Pipeline APIs")
public class PipelineController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineController.class);
    private final PipelineProcessor processor;
    private final ObjectMapper objectMapper;
    private final PostHogService postHogService;

    @PostMapping(value={"/handleData"}, consumes={"multipart/form-data"})
    public ResponseEntity<byte[]> handleData(@ModelAttribute HandleDataRequest request) throws JsonMappingException, JsonProcessingException {
        MultipartFile[] files = request.getFileInput();
        String jsonString = request.getJson();
        if (files == null) {
            return null;
        }
        PipelineConfig config = (PipelineConfig)this.objectMapper.readValue(jsonString, PipelineConfig.class);
        log.info("Received POST request to /handleData with {} files", (Object)files.length);
        List<String> operationNames = config.getOperations().stream().map(PipelineOperation::getOperation).toList();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("operations", operationNames);
        properties.put("fileCount", files.length);
        this.postHogService.captureEvent("pipeline_api_event", properties);
        try {
            List inputFiles = this.processor.generateInputFiles(files);
            if (inputFiles == null || inputFiles.isEmpty()) {
                return null;
            }
            PipelineResult result = this.processor.runPipelineAgainstFiles(inputFiles, config);
            List outputFiles = result.getOutputFiles();
            if (outputFiles != null && outputFiles.size() == 1) {
                Resource singleFile = (Resource)outputFiles.get(0);
                InputStream is = singleFile.getInputStream();
                byte[] bytes = new byte[(int)singleFile.contentLength()];
                is.read(bytes);
                is.close();
                log.info("Returning single file response...");
                return WebResponseUtils.bytesToWebResponse((byte[])bytes, (String)singleFile.getFilename(), (MediaType)MediaType.APPLICATION_OCTET_STREAM);
            }
            if (outputFiles == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(baos);
            HashMap<String, Integer> filenameCount = new HashMap<String, Integer>();
            for (Resource file : outputFiles) {
                String originalFilename;
                String filename = originalFilename = file.getFilename();
                if (filenameCount.containsKey(originalFilename)) {
                    int count = (Integer)filenameCount.get(originalFilename);
                    assert (originalFilename != null);
                    filename = GeneralUtils.generateFilename((String)originalFilename, (String)("(" + count + ")"));
                    filenameCount.put(originalFilename, count + 1);
                } else {
                    filenameCount.put(originalFilename, 1);
                }
                ZipEntry zipEntry = new ZipEntry(filename);
                zipOut.putNextEntry(zipEntry);
                InputStream is = file.getInputStream();
                byte[] bytes = new byte[(int)file.contentLength()];
                is.read(bytes);
                zipOut.write(bytes, 0, bytes.length);
                zipOut.closeEntry();
                is.close();
            }
            zipOut.close();
            log.info("Returning zipped file response...");
            return WebResponseUtils.baosToWebResponse((ByteArrayOutputStream)baos, (String)"output.zip", (MediaType)MediaType.APPLICATION_OCTET_STREAM);
        }
        catch (Exception e) {
            log.error("Error handling data: ", (Throwable)e);
            return null;
        }
    }

    @Generated
    public PipelineController(PipelineProcessor processor, ObjectMapper objectMapper, PostHogService postHogService) {
        this.processor = processor;
        this.objectMapper = objectMapper;
        this.postHogService = postHogService;
    }
}

