/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import stirling.software.SPDF.controller.api.misc.ScannerEffectController;
import stirling.software.SPDF.model.api.misc.ScannerEffectRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous PDF APIs")
public class ScannerEffectController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScannerEffectController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private static final int MAX_IMAGE_WIDTH = 8192;
    private static final int MAX_IMAGE_HEIGHT = 8192;
    private static final long MAX_IMAGE_PIXELS = 0x1000000L;
    private static final long RENDER_CLONE_IN_MEMORY_THRESHOLD = 0x1000000L;
    private static final ThreadLocal<BufferCache> BUFFER_CACHE = ThreadLocal.withInitial(BufferCache::new);

    private static int calculateSafeResolution(float pageWidthPts, float pageHeightPts, int resolution) {
        int projectedWidth = (int)Math.ceil((double)(pageWidthPts * (float)resolution) / 72.0);
        int projectedHeight = (int)Math.ceil((double)(pageHeightPts * (float)resolution) / 72.0);
        long projectedPixels = (long)projectedWidth * (long)projectedHeight;
        if (projectedWidth <= 8192 && projectedHeight <= 8192 && projectedPixels <= 0x1000000L) {
            return resolution;
        }
        double widthScale = 8192.0 / (double)projectedWidth;
        double heightScale = 8192.0 / (double)projectedHeight;
        double pixelScale = Math.sqrt(1.6777216E7 / (double)projectedPixels);
        double minScale = Math.min(Math.min(widthScale, heightScale), pixelScale);
        return (int)Math.max(72.0, (double)resolution * minScale);
    }

    private static int determineRenderResolution(ScannerEffectRequest request) {
        return request.getResolution();
    }

    private static BufferedImage renderPageSafely(PDFRenderer renderer, int pageIndex, int dpi) throws IOException {
        return (BufferedImage)ExceptionUtils.handleOomRendering((int)(pageIndex + 1), (int)dpi, () -> renderer.renderImageWithDPI(pageIndex, (float)dpi));
    }

    private static BufferedImage convertColorspace(BufferedImage image, ScannerEffectRequest.Colorspace colorspace) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = result.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        if (colorspace == ScannerEffectRequest.Colorspace.grayscale) {
            ScannerEffectController.convertToGrayscale((BufferedImage)result);
        }
        return result;
    }

    private static void convertToGrayscale(BufferedImage image) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < pixels.length; ++i) {
            int rgb = pixels[i];
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            int gray = (r + g + b) / 3;
            pixels[i] = gray << 16 | gray << 8 | gray;
        }
    }

    private static GradientConfig createRandomGradient() {
        boolean vertical = ThreadLocalRandom.current().nextBoolean();
        float startGrey = 0.6f + 0.3f * ThreadLocalRandom.current().nextFloat();
        float endGrey = 0.6f + 0.3f * ThreadLocalRandom.current().nextFloat();
        Color startColor = new Color(Math.round(startGrey * 255.0f), Math.round(startGrey * 255.0f), Math.round(startGrey * 255.0f));
        Color endColor = new Color(Math.round(endGrey * 255.0f), Math.round(endGrey * 255.0f), Math.round(endGrey * 255.0f));
        return new GradientConfig(vertical, startColor, endColor);
    }

    private static BufferedImage addBorderWithGradient(BufferedImage image, int borderPx, GradientConfig gradient) {
        int width = image.getWidth() + 2 * borderPx;
        int height = image.getHeight() + 2 * borderPx;
        int[] gradientLUT = ScannerEffectController.createGradientLUT((int)width, (int)height, (GradientConfig)gradient);
        BufferedImage result = new BufferedImage(width, height, image.getType());
        int[] pixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        ScannerEffectController.fillWithGradient((int[])pixels, (int)width, (int)height, (int[])gradientLUT, (boolean)gradient.vertical);
        Graphics2D g = result.createGraphics();
        g.drawImage((Image)image, borderPx, borderPx, null);
        g.dispose();
        return result;
    }

    private static int[] createGradientLUT(int width, int height, GradientConfig gradient) {
        int size = gradient.vertical ? height : width;
        int[] lut = new int[size];
        int rStart = gradient.startColor.getRed();
        int gStart = gradient.startColor.getGreen();
        int bStart = gradient.startColor.getBlue();
        int rDiff = gradient.endColor.getRed() - rStart;
        int gDiff = gradient.endColor.getGreen() - gStart;
        int bDiff = gradient.endColor.getBlue() - bStart;
        for (int i = 0; i < size; ++i) {
            float frac = (float)i / (float)Math.max(1, size - 1);
            int r = Math.round((float)rStart + (float)rDiff * frac);
            int g = Math.round((float)gStart + (float)gDiff * frac);
            int b = Math.round((float)bStart + (float)bDiff * frac);
            lut[i] = r << 16 | g << 8 | b;
        }
        return lut;
    }

    private static void fillWithGradient(int[] pixels, int width, int height, int[] gradientLUT, boolean vertical) {
        if (vertical) {
            for (int y = 0; y < height; ++y) {
                Arrays.fill(pixels, y * width, (y + 1) * width, gradientLUT[y]);
            }
        } else {
            for (int y = 0; y < height; ++y) {
                System.arraycopy(gradientLUT, 0, pixels, y * width, width);
            }
        }
    }

    private static double calculateRotation(int baseRotation, int rotateVariance) {
        if (baseRotation == 0 && rotateVariance == 0) {
            return 0.0;
        }
        return (double)baseRotation + (ThreadLocalRandom.current().nextDouble() * 2.0 - 1.0) * (double)rotateVariance;
    }

    private static BufferedImage rotateImage(BufferedImage image, double rotation, GradientConfig gradient) {
        if (rotation == 0.0) {
            return image;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        double radians = Math.toRadians(rotation);
        double sin = Math.abs(Math.sin(radians));
        double cos = Math.abs(Math.cos(radians));
        int rotW = (int)Math.floor((double)w * cos + (double)h * sin);
        int rotH = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage background = ScannerEffectController.createRotatedBackground((int)rotW, (int)rotH, (int)image.getType(), (GradientConfig)gradient);
        BufferedImage result = new BufferedImage(rotW, rotH, image.getType());
        Graphics2D g = result.createGraphics();
        g.drawImage((Image)background, 0, 0, null);
        AffineTransform transform = new AffineTransform();
        transform.translate((double)(rotW - w) / 2.0, (double)(rotH - h) / 2.0);
        transform.rotate(radians, (double)w / 2.0, (double)h / 2.0);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(image, transform, null);
        g.dispose();
        return result;
    }

    private static BufferedImage createRotatedBackground(int width, int height, int imageType, GradientConfig gradient) {
        BufferedImage background = new BufferedImage(width, height, imageType);
        int[] pixels = ((DataBufferInt)background.getRaster().getDataBuffer()).getData();
        int[] gradientLUT = ScannerEffectController.createGradientLUT((int)width, (int)height, (GradientConfig)gradient);
        ScannerEffectController.fillWithGradient((int[])pixels, (int)width, (int)height, (int[])gradientLUT, (boolean)gradient.vertical);
        return background;
    }

    private static BufferedImage applyAllEffectsSinglePass(BufferedImage image, float brightness, float contrast, boolean yellowish, double noise) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage output = new BufferedImage(width, height, 1);
        int[] srcPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] dstPixels = ((DataBufferInt)output.getRaster().getDataBuffer()).getData();
        double scaledStrength = noise * (double)Math.min(width, height) / 1000.0;
        boolean applyNoise = scaledStrength > 0.0;
        float contrastOffset = 128.0f - 128.0f * contrast;
        float inv765 = 0.0013071896f;
        for (int i = 0; i < srcPixels.length; ++i) {
            int rgb = srcPixels[i];
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            r = (int)(((float)r * contrast + contrastOffset) * brightness);
            g = (int)(((float)g * contrast + contrastOffset) * brightness);
            b = (int)(((float)b * contrast + contrastOffset) * brightness);
            r = Math.min(255, Math.max(0, r));
            g = Math.min(255, Math.max(0, g));
            b = Math.min(255, Math.max(0, b));
            if (yellowish) {
                float bright = (float)(r + g + b) * inv765;
                r = Math.min(255, (int)((float)r + (float)(255 - r) * 0.18f * bright));
                g = Math.min(255, (int)((float)g + (float)(255 - g) * 0.12f * bright));
                b = Math.max(0, (int)((float)b * (1.0f - 0.25f * bright)));
            }
            if (applyNoise) {
                r = Math.min(255, Math.max(0, r + (int)(ThreadLocalRandom.current().nextGaussian() * scaledStrength)));
                g = Math.min(255, Math.max(0, g + (int)(ThreadLocalRandom.current().nextGaussian() * scaledStrength)));
                b = Math.min(255, Math.max(0, b + (int)(ThreadLocalRandom.current().nextGaussian() * scaledStrength)));
            }
            dstPixels[i] = r << 16 | g << 8 | b;
        }
        return output;
    }

    private static BufferedImage softenEdges(BufferedImage image, int featherRadius, Color startColor, Color endColor, boolean vertical) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage output = new BufferedImage(width, height, image.getType());
        int[] srcPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] dstPixels = ((DataBufferInt)output.getRaster().getDataBuffer()).getData();
        int[] gradientLUT = ScannerEffectController.createGradientLUT((int)width, (int)height, (GradientConfig)new GradientConfig(vertical, startColor, endColor));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int dx = Math.min(x, width - 1 - x);
                int dy = Math.min(y, height - 1 - y);
                int d = Math.min(dx, dy);
                int bgVal = gradientLUT[vertical ? y : x];
                int fgVal = srcPixels[y * width + x];
                float alpha = d < featherRadius ? (float)d / (float)featherRadius : 1.0f;
                dstPixels[y * width + x] = ScannerEffectController.blendColors((int)fgVal, (int)bgVal, (float)alpha);
            }
        }
        return output;
    }

    private static int blendColors(int fg, int bg, float alpha) {
        int r = Math.round((float)(fg >> 16 & 0xFF) * alpha + (float)(bg >> 16 & 0xFF) * (1.0f - alpha));
        int g = Math.round((float)(fg >> 8 & 0xFF) * alpha + (float)(bg >> 8 & 0xFF) * (1.0f - alpha));
        int b = Math.round((float)(fg & 0xFF) * alpha + (float)(bg & 0xFF) * (1.0f - alpha));
        return r << 16 | g << 8 | b;
    }

    private static BufferedImage applyGaussianBlur(BufferedImage image, double sigma) {
        if (sigma <= 0.0) {
            return image;
        }
        double scaledSigma = sigma * (double)Math.min(image.getWidth(), image.getHeight()) / 1000.0;
        int radius = Math.max(1, (int)Math.ceil(scaledSigma * 2.0));
        int width = image.getWidth();
        int height = image.getHeight();
        int pixelCount = width * height;
        int[] srcPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        BufferCache cache = (BufferCache)BUFFER_CACHE.get();
        int[] tempPixels = cache.getTempBuffer(pixelCount);
        int[] dstPixels = cache.getDstBuffer(pixelCount);
        System.arraycopy(srcPixels, 0, tempPixels, 0, pixelCount);
        for (int pass = 0; pass < 2; ++pass) {
            ScannerEffectController.boxBlurHorizontal((int[])tempPixels, (int[])dstPixels, (int)width, (int)height, (int)radius);
            ScannerEffectController.boxBlurVertical((int[])dstPixels, (int[])tempPixels, (int)width, (int)height, (int)radius);
        }
        BufferedImage result = new BufferedImage(width, height, image.getType());
        int[] resultPixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        System.arraycopy(tempPixels, 0, resultPixels, 0, pixelCount);
        return result;
    }

    private static void boxBlurHorizontal(int[] src, int[] dst, int width, int height, int radius) {
        int diameter = radius * 2 + 1;
        float invDiameter = 1.0f / (float)diameter;
        for (int y = 0; y < height; ++y) {
            int x;
            int rowStart = y * width;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            for (x = -radius; x <= radius; ++x) {
                int px = Math.max(0, Math.min(width - 1, x));
                int rgb = src[rowStart + px];
                sumR += rgb >> 16 & 0xFF;
                sumG += rgb >> 8 & 0xFF;
                sumB += rgb & 0xFF;
            }
            for (x = 0; x < width; ++x) {
                int r = (int)((float)sumR * invDiameter);
                int g = (int)((float)sumG * invDiameter);
                int b = (int)((float)sumB * invDiameter);
                dst[rowStart + x] = r << 16 | g << 8 | b;
                int leftX = Math.max(0, x - radius);
                int rightX = Math.min(width - 1, x + radius + 1);
                int leftRgb = src[rowStart + leftX];
                int rightRgb = src[rowStart + rightX];
                sumR += (rightRgb >> 16 & 0xFF) - (leftRgb >> 16 & 0xFF);
                sumG += (rightRgb >> 8 & 0xFF) - (leftRgb >> 8 & 0xFF);
                sumB += (rightRgb & 0xFF) - (leftRgb & 0xFF);
            }
        }
    }

    private static void boxBlurVertical(int[] src, int[] dst, int width, int height, int radius) {
        int diameter = radius * 2 + 1;
        float invDiameter = 1.0f / (float)diameter;
        for (int x = 0; x < width; ++x) {
            int y;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            for (y = -radius; y <= radius; ++y) {
                int py = Math.max(0, Math.min(height - 1, y));
                int rgb = src[py * width + x];
                sumR += rgb >> 16 & 0xFF;
                sumG += rgb >> 8 & 0xFF;
                sumB += rgb & 0xFF;
            }
            for (y = 0; y < height; ++y) {
                int r = (int)((float)sumR * invDiameter);
                int g = (int)((float)sumG * invDiameter);
                int b = (int)((float)sumB * invDiameter);
                dst[y * width + x] = r << 16 | g << 8 | b;
                int topY = Math.max(0, y - radius);
                int bottomY = Math.min(height - 1, y + radius + 1);
                int topRgb = src[topY * width + x];
                int bottomRgb = src[bottomY * width + x];
                sumR += (bottomRgb >> 16 & 0xFF) - (topRgb >> 16 & 0xFF);
                sumG += (bottomRgb >> 8 & 0xFF) - (topRgb >> 8 & 0xFF);
                sumB += (bottomRgb & 0xFF) - (topRgb & 0xFF);
            }
        }
    }

    private static void writeProcessedPagesToDocument(List<ProcessedPage> pages, PDDocument document) throws IOException {
        for (ProcessedPage page : pages) {
            PDPage newPage = new PDPage(new PDRectangle(page.origW, page.origH));
            document.addPage(newPage);
            try (PDPageContentStream contentStream = new PDPageContentStream(document, newPage);){
                PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)page.image);
                contentStream.drawImage(pdImage, page.offsetX, page.offsetY, page.drawW, page.drawH);
            }
            page.image.flush();
        }
    }

    private static ProcessedPage processPage(int pageIndex, RenderingResources renderingResources, int baseRotation, int rotateVariance, int borderPx, float brightness, float contrast, float blur, float noise, boolean yellowish, int renderResolution, ScannerEffectRequest.Colorspace colorspace) throws ExceptionUtils.OutOfMemoryDpiException {
        try {
            PDRectangle pageSize = renderingResources.getPageMediaBox(pageIndex);
            float pageWidthPts = pageSize.getWidth();
            float pageHeightPts = pageSize.getHeight();
            int safeResolution = ScannerEffectController.calculateSafeResolution((float)pageWidthPts, (float)pageHeightPts, (int)renderResolution);
            BufferedImage image = renderingResources.renderPage(pageIndex, safeResolution);
            BufferedImage processed = ScannerEffectController.convertColorspace((BufferedImage)image, (ScannerEffectRequest.Colorspace)colorspace);
            image.flush();
            GradientConfig gradient = ScannerEffectController.createRandomGradient();
            BufferedImage composed = ScannerEffectController.addBorderWithGradient((BufferedImage)processed, (int)borderPx, (GradientConfig)gradient);
            processed.flush();
            double rotation = ScannerEffectController.calculateRotation((int)baseRotation, (int)rotateVariance);
            BufferedImage rotated = ScannerEffectController.rotateImage((BufferedImage)composed, (double)rotation, (GradientConfig)gradient);
            if (rotated != composed) {
                composed.flush();
            }
            float origW = pageSize.getWidth();
            float origH = pageSize.getHeight();
            int rotW = rotated.getWidth();
            int rotH = rotated.getHeight();
            float scale = Math.max(origW / (float)rotW, origH / (float)rotH);
            float drawW = (float)rotW * scale;
            float drawH = (float)rotH * scale;
            float offsetX = (origW - drawW) / 2.0f;
            float offsetY = (origH - drawH) / 2.0f;
            int featherRadius = Math.max(10, Math.round((float)Math.min(rotW, rotH) * 0.02f));
            BufferedImage softened = ScannerEffectController.softenEdges((BufferedImage)rotated, (int)featherRadius, (Color)gradient.startColor, (Color)gradient.endColor, (boolean)gradient.vertical);
            BufferedImage blurred = ScannerEffectController.applyGaussianBlur((BufferedImage)softened, (double)blur);
            BufferedImage adjusted = ScannerEffectController.applyAllEffectsSinglePass((BufferedImage)blurred, (float)brightness, (float)contrast, (boolean)yellowish, (double)noise);
            softened.flush();
            blurred.flush();
            if (rotated != composed) {
                rotated.flush();
            }
            return new ProcessedPage(adjusted, origW, origH, offsetX, offsetY, drawW, drawH);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapException((Exception)e, (String)("scanner effect processing for page " + (pageIndex + 1)));
        }
        catch (NegativeArraySizeException | OutOfMemoryError e) {
            throw ExceptionUtils.createOutOfMemoryDpiException((int)(pageIndex + 1), (int)renderResolution, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @PostMapping(value={"/scanner-effect"}, consumes={"multipart/form-data"})
    @Operation(summary="Apply scanner effect to PDF", description="Applies various effects to simulate a scanned document, including rotation, noise, and edge softening. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> scannerEffect(@Valid @ModelAttribute ScannerEffectRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public ScannerEffectController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }

    private static /* synthetic */ Callable lambda$scannerEffect$3(ThreadLocal renderingResources, int baseRotation, int rotateVariance, int borderPx, float brightness, float contrast, float blur, float noise, boolean yellowish, int renderResolution, ScannerEffectRequest.Colorspace colorspace, int i) {
        return () -> ScannerEffectController.processPage((int)i, (RenderingResources)((RenderingResources)renderingResources.get()), (int)baseRotation, (int)rotateVariance, (int)borderPx, (float)brightness, (float)contrast, (float)blur, (float)noise, (boolean)yellowish, (int)renderResolution, (ScannerEffectRequest.Colorspace)colorspace);
    }

    private /* synthetic */ RenderingResources lambda$scannerEffect$1(byte[] sharedPdfBytes, Path sharedPdfPath, Queue renderingResourcesToClose) {
        try {
            RenderingResources resources = sharedPdfBytes != null ? RenderingResources.fromBytes((CustomPDFDocumentFactory)this.pdfDocumentFactory, (byte[])sharedPdfBytes) : RenderingResources.fromPath((CustomPDFDocumentFactory)this.pdfDocumentFactory, (Path)sharedPdfPath);
            renderingResourcesToClose.add(resources);
            return resources;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to prepare rendering resources", e);
        }
    }
}

