/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import lombok.Generated;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import stirling.software.SPDF.model.api.misc.ReplaceAndInvertColorRequest;
import stirling.software.SPDF.service.misc.ReplaceAndInvertColorService;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class ReplaceAndInvertColorController {
    private final ReplaceAndInvertColorService replaceAndInvertColorService;

    @PostMapping(consumes={"multipart/form-data"}, value={"/replace-invert-pdf"})
    @Operation(summary="Replace-Invert Color PDF", description="This endpoint accepts a PDF file and provides options to invert all colors, replace text and background colors, or convert to CMYK color space for printing. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> replaceAndInvertColor(@ModelAttribute ReplaceAndInvertColorRequest request) throws IOException {
        InputStreamResource resource = this.replaceAndInvertColorService.replaceAndInvertColor(request.getFileInput(), request.getReplaceAndInvertOption(), request.getHighContrastColorCombination(), request.getBackGroundColor(), request.getTextColor());
        String filename = GeneralUtils.generateFilename((String)request.getFileInput().getOriginalFilename(), (String)"_inverted.pdf");
        return WebResponseUtils.bytesToWebResponse((byte[])resource.getContentAsByteArray(), (String)filename, (MediaType)MediaType.APPLICATION_PDF);
    }

    @Generated
    public ReplaceAndInvertColorController(ReplaceAndInvertColorService replaceAndInvertColorService) {
        this.replaceAndInvertColorService = replaceAndInvertColorService;
    }
}

