/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import lombok.Generated;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.misc.PrintFileRequest;
import stirling.software.common.util.ExceptionUtils;

@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class PrintFileController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrintFileController.class);

    public ResponseEntity<String> printFile(@ModelAttribute PrintFileRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        String originalFilename = file.getOriginalFilename();
        if (originalFilename != null && (originalFilename.contains("..") || Paths.get(originalFilename, new String[0]).isAbsolute())) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.invalid.filepath", (String)("Invalid file path detected: " + originalFilename), (Object[])new Object[0]);
        }
        String printerName = request.getPrinterName();
        String contentType = file.getContentType();
        try {
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            String normalizedPrinterName = printerName.toLowerCase(Locale.ROOT);
            PrintService selectedService = Arrays.stream(services).filter(service -> service.getName().toLowerCase(Locale.ROOT).contains(normalizedPrinterName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching printer found"));
            log.info("Selected Printer: {}", (Object)selectedService.getName());
            if ("application/pdf".equals(contentType)) {
                PDDocument document = Loader.loadPDF((byte[])file.getBytes());
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPrintService(selectedService);
                job.setPageable((Pageable)new PDFPageable(document));
                job.print();
                document.close();
            } else if (contentType.startsWith("image/")) {
                BufferedImage image = ImageIO.read(file.getInputStream());
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPrintService(selectedService);
                job.setPrintable((Printable)new /* Unavailable Anonymous Inner Class!! */);
                job.print();
            }
            return new ResponseEntity((Object)("File printed successfully to " + selectedService.getName()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            System.err.println("Failed to print: " + e.getMessage());
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }
}

