/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.misc.OverlayImageRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PdfUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class OverlayImageController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OverlayImageController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @PostMapping(consumes={"multipart/form-data"}, value={"/add-image"})
    @Operation(summary="Overlay image onto a PDF file", description="This endpoint overlays an image onto a PDF file at the specified coordinates. The image can be overlaid on every page of the PDF if specified.  Input:PDF/IMAGE Output:PDF Type:SISO")
    public ResponseEntity<byte[]> overlayImage(@ModelAttribute OverlayImageRequest request) {
        MultipartFile pdfFile = request.getFileInput();
        MultipartFile imageFile = request.getImageFile();
        float x = request.getX();
        float y = request.getY();
        boolean everyPage = Boolean.TRUE.equals(request.getEveryPage());
        try {
            byte[] pdfBytes = pdfFile.getBytes();
            byte[] imageBytes = imageFile.getBytes();
            byte[] result = PdfUtils.overlayImage((CustomPDFDocumentFactory)this.pdfDocumentFactory, (byte[])pdfBytes, (byte[])imageBytes, (float)x, (float)y, (boolean)everyPage);
            return WebResponseUtils.bytesToWebResponse((byte[])result, (String)GeneralUtils.generateFilename((String)pdfFile.getOriginalFilename(), (String)"_overlayed.pdf"));
        }
        catch (IOException e) {
            log.error("Failed to add image to PDF", (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Generated
    public OverlayImageController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

