/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.model.api.misc.ProcessPdfWithOcrRequest;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempDirectory;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;

@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class OCRController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OCRController.class);
    private final ApplicationProperties applicationProperties;
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;
    private final EndpointConfiguration endpointConfiguration;
    private final RuntimePathConfig runtimePathConfig;

    private boolean isOcrMyPdfEnabled() {
        return this.endpointConfiguration.isGroupEnabled("OCRmyPDF");
    }

    private boolean isTesseractEnabled() {
        return this.endpointConfiguration.isGroupEnabled("tesseract");
    }

    public List<String> getAvailableTesseractLanguages() {
        String tessdataDir = this.runtimePathConfig.getTessDataPath();
        File[] files = new File(tessdataDir).listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> file.getName().endsWith(".traineddata")).map(file -> file.getName().replace(".traineddata", "")).filter(lang -> !"osd".equalsIgnoreCase((String)lang)).toList();
    }

    /*
     * Exception decompiling
     */
    @PostMapping(consumes={"multipart/form-data"}, value={"/ocr-pdf"})
    @Operation(summary="Process a PDF file with OCR", description="This endpoint processes a PDF file using OCR (Optical Character Recognition). Users can specify languages, sidecar, deskew, clean, cleanFinal, ocrType, ocrRenderType, and removeImagesAfter options. Uses OCRmyPDF if available, falls back to Tesseract. Input:PDF Output:PDF Type:SI-Conditional")
    public ResponseEntity<byte[]> processPdfWithOCR(@ModelAttribute ProcessPdfWithOcrRequest request) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processWithOcrMyPdf(List<String> selectedLanguages, Boolean sidecar, Boolean deskew, Boolean clean, Boolean cleanFinal, String ocrType, String ocrRenderType, Boolean removeImagesAfter, Path tempInputFile, Path tempOutputFile, Path sidecarTextPath) throws IOException, InterruptedException {
        String languageOption = String.join((CharSequence)"+", selectedLanguages);
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.runtimePathConfig.getOcrMyPdfPath(), "--verbose", "2", "--output-type", "pdf", "--pdf-renderer", ocrRenderType));
        if (sidecar != null && sidecar.booleanValue() && sidecarTextPath != null) {
            command.add("--sidecar");
            command.add(sidecarTextPath.toString());
        }
        if (deskew != null && deskew.booleanValue()) {
            command.add("--deskew");
        }
        if (clean != null && clean.booleanValue()) {
            command.add("--clean");
        }
        if (cleanFinal != null && cleanFinal.booleanValue()) {
            command.add("--clean-final");
        }
        if (ocrType != null && !ocrType.isEmpty()) {
            if ("skip-text".equals(ocrType)) {
                command.add("--skip-text");
            } else if ("force-ocr".equals(ocrType)) {
                command.add("--force-ocr");
            }
        }
        command.addAll(Arrays.asList("--language", languageOption, tempInputFile.toString(), tempOutputFile.toString()));
        ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.OCR_MY_PDF).runCommandWithOutputHandling(command);
        if (result.getRc() != 0 && result.getMessages().contains("multiprocessing/synchronize.py") && result.getMessages().contains("OSError: [Errno 38] Function not implemented")) {
            command.add("--jobs");
            command.add("1");
            result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.OCR_MY_PDF).runCommandWithOutputHandling(command);
        }
        if (result.getRc() != 0) {
            throw ExceptionUtils.createOcrProcessingFailedException((int)result.getRc());
        }
        if (removeImagesAfter != null && removeImagesAfter.booleanValue()) {
            try (TempFile tempPdfWithoutImages = new TempFile(this.tempFileManager, "_no_images.pdf");){
                List<String> gsCommand = Arrays.asList("gs", "-sDEVICE=pdfwrite", "-dFILTERIMAGE", "-o", tempPdfWithoutImages.getPath().toString(), tempOutputFile.toString());
                ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(gsCommand);
                Files.copy(tempPdfWithoutImages.getPath(), tempOutputFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void processWithTesseract(List<String> selectedLanguages, String ocrType, Path tempInputFile, Path tempOutputFile) throws IOException, InterruptedException {
        try (TempDirectory tempDir = new TempDirectory(this.tempFileManager);){
            File tempOutputDir = new File(tempDir.getPath().toFile(), "output");
            File tempImagesDir = new File(tempDir.getPath().toFile(), "images");
            File finalOutputFile = new File(tempDir.getPath().toFile(), "final_output.pdf");
            tempOutputDir.mkdirs();
            tempImagesDir.mkdirs();
            PDFMergerUtility merger = new PDFMergerUtility();
            merger.setDestinationFileName(finalOutputFile.toString());
            try (PDDocument document = this.pdfDocumentFactory.load(tempInputFile.toFile());){
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                int pageCount = document.getNumberOfPages();
                for (int pageNum = 0; pageNum < pageCount; ++pageNum) {
                    boolean hasText;
                    PDPage page = document.getPage(pageNum);
                    try (PDDocument tempDoc = new PDDocument();){
                        tempDoc.addPage(page);
                        Object stripper = new PDFTextStripper();
                        hasText = !stripper.getText(tempDoc).trim().isEmpty();
                    }
                    boolean shouldOcr = switch (ocrType) {
                        case "skip-text" -> {
                            if (!hasText) {
                                yield true;
                            }
                            yield false;
                        }
                        case "force-ocr" -> true;
                        default -> true;
                    };
                    File pageOutputPath = new File(tempOutputDir, String.format(Locale.ROOT, "page_%d.pdf", pageNum));
                    if (shouldOcr) {
                        int renderDpi = 300;
                        if (this.applicationProperties != null && this.applicationProperties.getSystem() != null) {
                            renderDpi = this.applicationProperties.getSystem().getMaxDPI();
                        }
                        int dpi = renderDpi;
                        int currentPageNum = pageNum;
                        BufferedImage image = (BufferedImage)ExceptionUtils.handleOomRendering((int)(currentPageNum + 1), (int)dpi, () -> pdfRenderer.renderImageWithDPI(currentPageNum, (float)dpi));
                        File imagePath = new File(tempImagesDir, String.format(Locale.ROOT, "page_%d.png", pageNum));
                        ImageIO.write((RenderedImage)image, "png", imagePath);
                        ArrayList<String> command = new ArrayList<String>();
                        command.add("tesseract");
                        command.add(imagePath.toString());
                        command.add(new File(tempOutputDir, String.format(Locale.ROOT, "page_%d", pageNum)).toString());
                        command.add("-l");
                        command.add(String.join((CharSequence)"+", selectedLanguages));
                        command.add("pdf");
                        ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.TESSERACT).runCommandWithOutputHandling(command);
                        if (result.getRc() != 0) {
                            throw ExceptionUtils.createRuntimeException((String)"error.commandFailed", (String)"{0} command failed with exit code: {1}", null, (Object[])new Object[]{"Tesseract", result.getRc()});
                        }
                        merger.addSource(pageOutputPath);
                        continue;
                    }
                    try (PDDocument pageDoc = new PDDocument();){
                        pageDoc.addPage(page);
                        pageDoc.save(pageOutputPath);
                        merger.addSource(pageOutputPath);
                        continue;
                    }
                }
            }
            merger.mergeDocuments(null);
            Files.copy(finalOutputFile.toPath(), tempOutputFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Generated
    public OCRController(ApplicationProperties applicationProperties, CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager, EndpointConfiguration endpointConfiguration, RuntimePathConfig runtimePathConfig) {
        this.applicationProperties = applicationProperties;
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
        this.endpointConfiguration = endpointConfiguration;
        this.runtimePathConfig = runtimePathConfig;
    }
}

