/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class DecompressPdfController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecompressPdfController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @PostMapping(value={"/decompress-pdf"}, consumes={"multipart/form-data"})
    @Operation(summary="Decompress PDF streams", description="Fully decompresses all PDF streams including text content")
    public ResponseEntity<byte[]> decompressPdf(@ModelAttribute PDFFile request) throws IOException {
        MultipartFile file = request.getFileInput();
        try (PDDocument document = this.pdfDocumentFactory.load(file);){
            this.processAllObjects(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.save((OutputStream)baos, CompressParameters.NO_COMPRESSION);
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])baos.toByteArray(), (String)GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_decompressed.pdf"));
            return responseEntity;
        }
    }

    private void processAllObjects(PDDocument document) {
        HashSet processed = new HashSet();
        COSDocument cosDoc = document.getDocument();
        for (COSObjectKey key : cosDoc.getXrefTable().keySet()) {
            COSObject obj = cosDoc.getObjectFromPool(key);
            this.processObject((COSBase)obj, processed);
        }
    }

    private void processObject(COSBase obj, Set<COSBase> processed) {
        if (obj == null || processed.contains(obj)) {
            return;
        }
        processed.add(obj);
        if (obj instanceof COSObject) {
            COSObject cosObj = (COSObject)obj;
            this.processObject(cosObj.getObject(), processed);
        } else if (obj instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)obj;
            this.processDictionary(dict, processed);
        } else if (obj instanceof COSArray) {
            COSArray array = (COSArray)obj;
            this.processArray(array, processed);
        }
    }

    private void processDictionary(COSDictionary dict, Set<COSBase> processed) {
        for (COSName key : dict.keySet()) {
            this.processObject(dict.getDictionaryObject(key), processed);
        }
        if (dict instanceof COSStream) {
            COSStream stream = (COSStream)dict;
            this.decompressStream(stream);
        }
    }

    private void processArray(COSArray array, Set<COSBase> processed) {
        for (int i = 0; i < array.size(); ++i) {
            this.processObject(array.get(i), processed);
        }
    }

    private void decompressStream(COSStream stream) {
        block14: {
            try {
                byte[] decompressedBytes;
                log.debug("Processing stream: {}", (Object)stream);
                if (!stream.containsKey(COSName.FILTER) && !stream.containsKey(COSName.DECODE_PARMS) && !stream.containsKey(COSName.D)) break block14;
                try (COSInputStream is = stream.createInputStream();){
                    decompressedBytes = IOUtils.toByteArray((InputStream)is);
                }
                stream.removeItem(COSName.FILTER);
                stream.removeItem(COSName.DECODE_PARMS);
                stream.removeItem(COSName.D);
                try (OutputStream out = stream.createRawOutputStream();){
                    out.write(decompressedBytes);
                }
                stream.setInt(COSName.LENGTH, decompressedBytes.length);
            }
            catch (IOException e) {
                ExceptionUtils.logException((String)"stream decompression", (Exception)e);
            }
        }
    }

    @Generated
    public DecompressPdfController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

