/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.misc.RemoveBlankPagesRequest;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ApplicationContextProvider;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PdfUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class BlankPageController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlankPageController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    public static boolean isBlankImage(BufferedImage image, int threshold, double whitePercent, int blurSize) {
        if (image == null) {
            log.info("Error: Image is null");
            return false;
        }
        int whitePixels = 0;
        int totalPixels = image.getWidth() * image.getHeight();
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = image.getRGB(j, i) & 0xFF;
                if (color < 255 - threshold) continue;
                ++whitePixels;
            }
        }
        double whitePixelPercentage = (double)whitePixels / (double)totalPixels * 100.0;
        log.info(String.format(Locale.ROOT, "Page has white pixel percent of %.2f%%", whitePixelPercentage));
        return whitePixelPercentage >= whitePercent;
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/remove-blanks"})
    @Operation(summary="Remove blank pages from a PDF file", description="This endpoint removes blank pages from a given PDF file. Users can specify the threshold and white percentage to tune the detection of blank pages. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> removeBlankPages(@ModelAttribute RemoveBlankPagesRequest request) throws IOException, InterruptedException {
        ResponseEntity responseEntity;
        block19: {
            MultipartFile inputFile = request.getFileInput();
            int threshold = request.getThreshold();
            float whitePercent = request.getWhitePercent();
            PDDocument document = this.pdfDocumentFactory.load(inputFile);
            try {
                PDPageTree pages = document.getDocumentCatalog().getPages();
                PDFTextStripper textStripper = new PDFTextStripper();
                ArrayList<PDPage> nonBlankPages = new ArrayList<PDPage>();
                ArrayList<PDPage> blankPages = new ArrayList<PDPage>();
                int pageIndex = 0;
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                pdfRenderer.setSubsamplingAllowed(true);
                for (PDPage page : pages) {
                    log.info("checking page {}", (Object)pageIndex);
                    textStripper.setStartPage(pageIndex + 1);
                    textStripper.setEndPage(pageIndex + 1);
                    String pageText = textStripper.getText(document);
                    boolean hasText = !pageText.trim().isEmpty();
                    boolean blank = true;
                    if (hasText) {
                        log.info("page {} has text, not blank", (Object)pageIndex);
                        blank = false;
                    } else {
                        boolean hasImages = PdfUtils.hasImagesOnPage((PDPage)page);
                        if (hasImages) {
                            log.info("page {} has image, running blank detection", (Object)pageIndex);
                            int renderDpi = 30;
                            ApplicationProperties properties = (ApplicationProperties)ApplicationContextProvider.getBean(ApplicationProperties.class);
                            if (properties != null && properties.getSystem() != null) {
                                renderDpi = properties.getSystem().getMaxDPI();
                            }
                            int dpi = renderDpi;
                            int currentPageIndex = pageIndex;
                            BufferedImage image = (BufferedImage)ExceptionUtils.handleOomRendering((int)(currentPageIndex + 1), (int)dpi, () -> pdfRenderer.renderImageWithDPI(currentPageIndex, (float)dpi));
                            blank = BlankPageController.isBlankImage((BufferedImage)image, (int)threshold, (double)whitePercent, (int)threshold);
                        }
                    }
                    if (blank) {
                        log.info("Skipping, Image was  blank for page #{}", (Object)pageIndex);
                        blankPages.add(page);
                    } else {
                        log.info("page {} has image which is not blank", (Object)pageIndex);
                        nonBlankPages.add(page);
                    }
                    ++pageIndex;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                String filename = GeneralUtils.removeExtension((String)Filenames.toSimpleFileName((String)inputFile.getOriginalFilename()));
                if (!nonBlankPages.isEmpty()) {
                    this.createZipEntry(zos, nonBlankPages, filename + "_nonBlankPages.pdf");
                } else {
                    this.createZipEntry(zos, blankPages, filename + "_allBlankPages.pdf");
                }
                if (!nonBlankPages.isEmpty() && !blankPages.isEmpty()) {
                    this.createZipEntry(zos, blankPages, filename + "_blankPages.pdf");
                }
                zos.close();
                log.info("Returning ZIP file: {}", (Object)(filename + "_processed.zip"));
                responseEntity = WebResponseUtils.baosToWebResponse((ByteArrayOutputStream)baos, (String)(filename + "_processed.zip"), (MediaType)MediaType.APPLICATION_OCTET_STREAM);
                if (document == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExceptionUtils.OutOfMemoryDpiException e) {
                    throw e;
                }
                catch (IOException e) {
                    log.error("exception", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            document.close();
        }
        return responseEntity;
    }

    public void createZipEntry(ZipOutputStream zos, List<PDPage> pages, String entryName) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.createNewDocument();){
            for (PDPage page : pages) {
                document.addPage(page);
            }
            ZipEntry zipEntry = new ZipEntry(entryName);
            zos.putNextEntry(zipEntry);
            document.save((OutputStream)zos);
            zos.closeEntry();
        }
    }

    @Generated
    public BlankPageController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

