/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.misc.AutoSplitPdfRequest;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ApplicationContextProvider;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class AutoSplitPdfController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoSplitPdfController.class);
    private static final Set<String> VALID_QR_CONTENTS = new HashSet<String>(Set.of("https://github.com/Stirling-Tools/Stirling-PDF", "https://github.com/Frooodle/Stirling-PDF", "https://stirlingpdf.com"));
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    private static String decodeQRCode(BufferedImage bufferedImage) {
        PlanarYUVLuminanceSource source;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
            pixels = dataBufferByte.getData();
            source = new PlanarYUVLuminanceSource((byte[])pixels, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        } else {
            pixels = bufferedImage.getRaster().getDataBuffer();
            if (pixels instanceof DataBufferInt) {
                DataBufferInt dataBufferInt = (DataBufferInt)pixels;
                pixels = dataBufferInt.getData();
                byte[] newPixels = new byte[((Object)pixels).length];
                for (int i = 0; i < ((Object)pixels).length; ++i) {
                    newPixels[i] = (byte)(pixels[i] & 0xFF);
                }
                source = new PlanarYUVLuminanceSource(newPixels, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), false);
            } else {
                throw new IllegalArgumentException("BufferedImage must have 8-bit gray scale, 24-bit RGB, 32-bit ARGB (packed int), byte gray, or 3-byte/4-byte RGB image data");
            }
        }
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        try {
            Result result = new MultiFormatReader().decode(bitmap);
            return result.getText();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @PostMapping(value={"/auto-split-pdf"}, consumes={"multipart/form-data"})
    @Operation(summary="Auto split PDF pages into separate documents", description="This endpoint accepts a PDF file, scans each page for a specific QR code, and splits the document at the QR code boundaries. The output is a zip file containing each separate PDF document. Input:PDF Output:ZIP-PDF Type:SISO")
    public ResponseEntity<byte[]> autoSplitPdf(@ModelAttribute AutoSplitPdfRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        boolean duplexMode = Boolean.TRUE.equals(request.getDuplexMode());
        PDDocument document = null;
        ArrayList<PDDocument> splitDocuments = new ArrayList<PDDocument>();
        TempFile outputTempFile = null;
        try {
            outputTempFile = new TempFile(this.tempFileManager, ".zip");
            document = this.pdfDocumentFactory.load(file.getInputStream());
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            pdfRenderer.setSubsamplingAllowed(true);
            for (int page = 0; page < document.getNumberOfPages(); ++page) {
                int renderDpi = 150;
                ApplicationProperties properties = (ApplicationProperties)ApplicationContextProvider.getBean(ApplicationProperties.class);
                if (properties != null && properties.getSystem() != null) {
                    renderDpi = properties.getSystem().getMaxDPI();
                }
                int dpi = renderDpi;
                int pageNum = page;
                BufferedImage bim = (BufferedImage)ExceptionUtils.handleOomRendering((int)(pageNum + 1), (int)dpi, () -> pdfRenderer.renderImageWithDPI(pageNum, (float)dpi));
                String result = AutoSplitPdfController.decodeQRCode((BufferedImage)bim);
                boolean isValidQrCode = VALID_QR_CONTENTS.contains(result);
                log.debug("detected qr code {}, code is vale={}", (Object)result, (Object)isValidQrCode);
                if (isValidQrCode && page != 0) {
                    splitDocuments.add(new PDDocument());
                }
                if (!splitDocuments.isEmpty() && !isValidQrCode) {
                    ((PDDocument)splitDocuments.get(splitDocuments.size() - 1)).addPage(document.getPage(page));
                } else if (page == 0) {
                    PDDocument firstDocument = new PDDocument();
                    firstDocument.addPage(document.getPage(page));
                    splitDocuments.add(firstDocument);
                }
                if (!duplexMode || !isValidQrCode) continue;
                ++page;
            }
            splitDocuments.removeIf(pdDocument -> pdDocument.getNumberOfPages() == 0);
            String filename = GeneralUtils.removeExtension((String)Filenames.toSimpleFileName((String)file.getOriginalFilename()));
            try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(outputTempFile.getPath(), new OpenOption[0]));){
                for (int i = 0; i < splitDocuments.size(); ++i) {
                    String fileName = filename + "_" + (i + 1) + ".pdf";
                    PDDocument splitDocument = (PDDocument)splitDocuments.get(i);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    splitDocument.save((OutputStream)baos);
                    byte[] pdf = baos.toByteArray();
                    ZipEntry pdfEntry = new ZipEntry(fileName);
                    zipOut.putNextEntry(pdfEntry);
                    zipOut.write(pdf);
                    zipOut.closeEntry();
                }
            }
            byte[] data = Files.readAllBytes(outputTempFile.getPath());
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])data, (String)(filename + ".zip"), (MediaType)MediaType.APPLICATION_OCTET_STREAM);
            return responseEntity;
        }
        catch (Exception e) {
            log.error("Error in auto split", (Throwable)e);
            throw e;
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    log.error("Error closing main PDDocument", (Throwable)e);
                }
            }
            for (PDDocument splitDoc : splitDocuments) {
                try {
                    splitDoc.close();
                }
                catch (IOException e) {
                    log.error("Error closing split PDDocument", (Throwable)e);
                }
            }
            if (outputTempFile != null) {
                outputTempFile.close();
            }
        }
    }

    @Generated
    public AutoSplitPdfController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

