/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.misc.AutoRenameController;
import stirling.software.SPDF.model.api.misc.ExtractHeaderRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class AutoRenameController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoRenameController.class);
    private static final int LINE_LIMIT = 200;
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @PostMapping(consumes={"multipart/form-data"}, value={"/auto-rename"})
    @Operation(summary="Extract header from PDF file", description="This endpoint accepts a PDF file and attempts to extract its title or header based on heuristics. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> extractHeader(@ModelAttribute ExtractHeaderRequest request) throws Exception {
        PDDocument document;
        MultipartFile file = request.getFileInput();
        boolean useFirstTextAsFallback = Boolean.TRUE.equals(request.getUseFirstTextAsFallback());
        1 reader = new /* Unavailable Anonymous Inner Class!! */;
        String header = reader.getText(document = this.pdfDocumentFactory.load(file));
        if (header != null && header.length() < 255) {
            header = RegexPatternUtils.getInstance().getSafeFilenamePattern().matcher(header).replaceAll("").trim();
            return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)(header + ".pdf"));
        }
        log.info("File has no good title to be found");
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)Filenames.toSimpleFileName((String)file.getOriginalFilename()));
    }

    @Generated
    public AutoRenameController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

