/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.misc.AddAttachmentRequest;
import stirling.software.SPDF.model.api.misc.ExtractAttachmentsRequest;
import stirling.software.SPDF.service.AttachmentServiceInterface;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class AttachmentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final AttachmentServiceInterface pdfAttachmentService;

    @PostMapping(consumes={"multipart/form-data"}, value={"/add-attachments"})
    @Operation(summary="Add attachments to PDF", description="This endpoint adds attachments to a PDF. Input:PDF, Output:PDF Type:MISO")
    public ResponseEntity<byte[]> addAttachments(@ModelAttribute AddAttachmentRequest request) throws IOException {
        MultipartFile fileInput = request.getFileInput();
        List attachments = request.getAttachments();
        PDDocument document = this.pdfAttachmentService.addAttachment(this.pdfDocumentFactory.load(fileInput, false), attachments);
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)Filenames.toSimpleFileName((String)fileInput.getOriginalFilename()), (String)"_with_attachments.pdf"));
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/extract-attachments"})
    @Operation(summary="Extract attachments from PDF", description="This endpoint extracts all embedded attachments from a PDF into a ZIP archive. Input:PDF Output:ZIP Type:SISO")
    public ResponseEntity<byte[]> extractAttachments(@ModelAttribute ExtractAttachmentsRequest request) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request, true);){
            Optional extracted = this.pdfAttachmentService.extractAttachments(document);
            if (extracted.isEmpty()) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.noAttachmentsFound", (String)"No embedded attachments found in the provided PDF", (Object[])new Object[0]);
            }
            MultipartFile fileInput = request.getFileInput();
            String sourceName = fileInput != null ? fileInput.getOriginalFilename() : request.getFileId();
            String outputName = Filenames.toSimpleFileName((String)GeneralUtils.generateFilename((String)sourceName, (String)"_attachments.zip"));
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])((byte[])extracted.get()), (String)outputName, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
            return responseEntity;
        }
    }

    @Generated
    public AttachmentController(CustomPDFDocumentFactory pdfDocumentFactory, AttachmentServiceInterface pdfAttachmentService) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.pdfAttachmentService = pdfAttachmentService;
    }
}

