/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import stirling.software.SPDF.model.api.converters.UrlToPdfRequest;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@Tag(name="Convert", description="Convert APIs")
@RequestMapping(value={"/api/v1/convert"})
public class ConvertWebsiteToPDF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertWebsiteToPDF.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final RuntimePathConfig runtimePathConfig;
    private final ApplicationProperties applicationProperties;
    private static final Pattern FILE_SCHEME_PATTERN = Pattern.compile("(?<![a-z0-9_])file\\s*:(?:/{1,3}|%2f|%5c|%3a|&#x2f;|&#47;)");
    private static final Pattern NUMERIC_HTML_ENTITY_PATTERN = Pattern.compile("&#(x?[0-9a-f]+);");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(consumes={"multipart/form-data"}, value={"/url/pdf"})
    @Operation(summary="Convert a URL to a PDF", description="This endpoint fetches content from a URL and converts it to a PDF format. Input:N/A Output:PDF Type:SISO")
    public ResponseEntity<?> urlToPdf(@ModelAttribute UrlToPdfRequest request) throws IOException, InterruptedException {
        ResponseEntity responseEntity;
        Path tempOutputFile;
        block35: {
            ResponseEntity response;
            Path tempHtmlInput;
            block33: {
                ResponseEntity responseEntity2;
                block34: {
                    String htmlContent;
                    PDDocument doc;
                    String URL2;
                    block31: {
                        ResponseEntity responseEntity3;
                        block32: {
                            URL2 = request.getUrlInput();
                            UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path("/url-to-pdf");
                            URI location = null;
                            HttpStatus status = HttpStatus.SEE_OTHER;
                            if (!this.applicationProperties.getSystem().isEnableUrlToPDF()) {
                                location = uriComponentsBuilder.queryParam("error", new Object[]{"error.endpointDisabled"}).build().toUri();
                            } else {
                                boolean patternValid = RegexPatternUtils.getInstance().getHttpUrlPattern().matcher(URL2).matches();
                                boolean generalValid = GeneralUtils.isValidURL((String)URL2);
                                if (!patternValid && !generalValid) {
                                    location = uriComponentsBuilder.queryParam("error", new Object[]{"error.invalidUrlFormat"}).build().toUri();
                                } else if (!GeneralUtils.isURLReachable((String)URL2)) {
                                    location = uriComponentsBuilder.queryParam("error", new Object[]{"error.urlNotReachable"}).build().toUri();
                                }
                            }
                            if (location != null) {
                                log.info("Redirecting to: {}", (Object)location.toString());
                                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).location(location)).build();
                            }
                            tempOutputFile = null;
                            tempHtmlInput = null;
                            doc = null;
                            try {
                                htmlContent = this.fetchRemoteHtml(URL2);
                                if (!this.containsDisallowedUriScheme(htmlContent)) break block31;
                                URI rejectionLocation = uriComponentsBuilder.queryParam("error", new Object[]{"error.disallowedUrlContent"}).build().toUri();
                                log.warn("Rejected URL to PDF conversion due to disallowed content references");
                                responseEntity3 = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).location(rejectionLocation)).build();
                                if (tempHtmlInput == null) break block32;
                            }
                            catch (Throwable throwable) {
                                if (tempHtmlInput != null) {
                                    try {
                                        Files.deleteIfExists(tempHtmlInput);
                                    }
                                    catch (IOException e) {
                                        log.error("Error deleting temporary HTML input file", (Throwable)e);
                                    }
                                }
                                if (tempOutputFile != null) {
                                    try {
                                        Files.deleteIfExists(tempOutputFile);
                                    }
                                    catch (IOException e) {
                                        log.error("Error deleting temporary output file", (Throwable)e);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                Files.deleteIfExists(tempHtmlInput);
                            }
                            catch (IOException e) {
                                log.error("Error deleting temporary HTML input file", (Throwable)e);
                            }
                        }
                        if (tempOutputFile != null) {
                            try {
                                Files.deleteIfExists(tempOutputFile);
                            }
                            catch (IOException e) {
                                log.error("Error deleting temporary output file", (Throwable)e);
                            }
                        }
                        return responseEntity3;
                    }
                    tempHtmlInput = Files.createTempFile("url_input_", ".html", new FileAttribute[0]);
                    Files.writeString(tempHtmlInput, (CharSequence)htmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
                    tempOutputFile = Files.createTempFile("output_", ".pdf", new FileAttribute[0]);
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(this.runtimePathConfig.getWeasyPrintPath());
                    command.add(tempHtmlInput.toString());
                    command.add("--base-url");
                    command.add(URL2);
                    command.add("--pdf-forms");
                    command.add(tempOutputFile.toString());
                    ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.WEASYPRINT).runCommandWithOutputHandling(command);
                    doc = this.pdfDocumentFactory.load(tempOutputFile.toFile());
                    String outputFilename = this.convertURLToFileName(URL2);
                    response = WebResponseUtils.pdfDocToWebResponse((PDDocument)doc, (String)outputFilename);
                    if (response != null) break block33;
                    responseEntity2 = ResponseEntity.ok((Object)new byte[0]);
                    if (tempHtmlInput == null) break block34;
                    try {
                        Files.deleteIfExists(tempHtmlInput);
                    }
                    catch (IOException e) {
                        log.error("Error deleting temporary HTML input file", (Throwable)e);
                    }
                }
                if (tempOutputFile != null) {
                    try {
                        Files.deleteIfExists(tempOutputFile);
                    }
                    catch (IOException e) {
                        log.error("Error deleting temporary output file", (Throwable)e);
                    }
                }
                return responseEntity2;
            }
            responseEntity = response;
            if (tempHtmlInput == null) break block35;
            try {
                Files.deleteIfExists(tempHtmlInput);
            }
            catch (IOException e) {
                log.error("Error deleting temporary HTML input file", (Throwable)e);
            }
        }
        if (tempOutputFile != null) {
            try {
                Files.deleteIfExists(tempOutputFile);
            }
            catch (IOException e) {
                log.error("Error deleting temporary output file", (Throwable)e);
            }
        }
        return responseEntity;
    }

    private String fetchRemoteHtml(String url) throws IOException, InterruptedException {
        HttpRequest request;
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).build();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(20L)).GET().header("User-Agent", "Stirling-PDF/URL-to-PDF").build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (response.statusCode() >= 400 || response.body() == null) {
            throw ExceptionUtils.createIOException((String)"error.httpRequestFailed", (String)"Failed to retrieve remote HTML. Status: {0}", null, (Object[])new Object[]{response.statusCode()});
        }
        return response.body();
    }

    private boolean containsDisallowedUriScheme(String htmlContent) {
        if (htmlContent == null || htmlContent.isEmpty()) {
            return false;
        }
        String normalized = this.normalizeForSchemeDetection(htmlContent);
        return FILE_SCHEME_PATTERN.matcher(normalized).find();
    }

    private String normalizeForSchemeDetection(String htmlContent) {
        String lowerCaseContent = htmlContent.toLowerCase(Locale.ROOT);
        String decodedHtmlEntities = this.decodeNumericHtmlEntities(lowerCaseContent);
        decodedHtmlEntities = decodedHtmlEntities.replace("&colon;", ":").replace("&sol;", "/").replace("&frasl;", "/");
        return this.percentDecode(decodedHtmlEntities);
    }

    private String percentDecode(String content) {
        StringBuilder result = new StringBuilder(content.length());
        for (int i = 0; i < content.length(); ++i) {
            char current = content.charAt(i);
            if (current == '%' && i + 2 < content.length()) {
                String hex = content.substring(i + 1, i + 3);
                try {
                    int value = Integer.parseInt(hex, 16);
                    result.append((char)value);
                    i += 2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            result.append(current);
        }
        return result.toString();
    }

    private String decodeNumericHtmlEntities(String content) {
        Matcher matcher = NUMERIC_HTML_ENTITY_PATTERN.matcher(content);
        StringBuffer decoded = new StringBuffer();
        while (matcher.find()) {
            String entityBody = matcher.group(1);
            try {
                int radix = entityBody.startsWith("x") ? 16 : 10;
                int codePoint = Integer.parseInt(radix == 16 ? entityBody.substring(1) : entityBody, radix);
                matcher.appendReplacement(decoded, Matcher.quoteReplacement(Character.toString((char)codePoint)));
            }
            catch (NumberFormatException ex) {
                matcher.appendReplacement(decoded, matcher.group(0));
            }
        }
        matcher.appendTail(decoded);
        return decoded.toString();
    }

    private String convertURLToFileName(String url) {
        String safeName = GeneralUtils.convertToFileName((String)url);
        if (safeName == null || safeName.isBlank()) {
            try {
                URI uri = URI.create(url);
                String hostPart = uri.getHost();
                if (hostPart == null || hostPart.isBlank()) {
                    hostPart = "document";
                }
                safeName = RegexPatternUtils.getInstance().getNonAlnumUnderscorePattern().matcher(hostPart).replaceAll("_");
            }
            catch (Exception e) {
                safeName = "document";
            }
        }
        RegexPatternUtils patterns = RegexPatternUtils.getInstance();
        safeName = patterns.getNonAlnumUnderscorePattern().matcher(safeName).replaceAll("_");
        safeName = patterns.getMultipleUnderscoresPattern().matcher(safeName).replaceAll("_");
        safeName = patterns.getLeadingUnderscoresPattern().matcher(safeName).replaceAll("");
        safeName = patterns.getTrailingUnderscoresPattern().matcher(safeName).replaceAll("");
        if (safeName.isEmpty()) {
            safeName = "document";
        }
        if (safeName.length() > 50) {
            safeName = safeName.substring(0, 50);
        }
        return GeneralUtils.generateFilename((String)safeName, (String)".pdf");
    }

    @Generated
    public ConvertWebsiteToPDF(CustomPDFDocumentFactory pdfDocumentFactory, RuntimePathConfig runtimePathConfig, ApplicationProperties applicationProperties) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.runtimePathConfig = runtimePathConfig;
        this.applicationProperties = applicationProperties;
    }
}

