/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.api.GeneralFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.CustomHtmlSanitizer;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@Tag(name="Convert", description="Convert APIs")
@RequestMapping(value={"/api/v1/convert"})
public class ConvertOfficeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertOfficeController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final RuntimePathConfig runtimePathConfig;
    private final CustomHtmlSanitizer customHtmlSanitizer;
    private final EndpointConfiguration endpointConfiguration;

    private boolean isUnoconvertAvailable() {
        return this.endpointConfiguration.isGroupEnabled("Unoconvert") || this.endpointConfiguration.isGroupEnabled("Python");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File convertToPdf(MultipartFile inputFile) throws IOException, InterruptedException {
        String originalFilename = Filenames.toSimpleFileName((String)inputFile.getOriginalFilename());
        if (originalFilename == null || originalFilename.isBlank()) {
            throw ExceptionUtils.createFileNoNameException();
        }
        String extension = FilenameUtils.getExtension((String)originalFilename);
        if (extension == null || !this.isValidFileExtension(extension)) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.invalid.extension", (String)("Invalid file extension: " + extension), (Object[])new Object[0]);
        }
        String extensionLower = extension.toLowerCase(Locale.ROOT);
        String baseName = FilenameUtils.getBaseName((String)originalFilename);
        if (baseName == null || baseName.isBlank()) {
            baseName = "input";
        }
        Path workDir = Files.createTempDirectory("office2pdf_", new FileAttribute[0]);
        Path inputPath = workDir.resolve(baseName + "." + extensionLower);
        Path outputPath = workDir.resolve(baseName + ".pdf");
        if ("html".equals(extensionLower) || "htm".equals(extensionLower)) {
            String htmlContent = new String(inputFile.getBytes(), StandardCharsets.UTF_8);
            String sanitizedHtml = this.customHtmlSanitizer.sanitize(htmlContent);
            Files.writeString(inputPath, (CharSequence)sanitizedHtml, StandardCharsets.UTF_8, new OpenOption[0]);
        } else {
            Files.copy(inputFile.getInputStream(), inputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        Path libreOfficeProfile = null;
        try {
            ProcessExecutor.ProcessExecutorResult result;
            if (this.isUnoconvertAvailable()) {
                command = new ArrayList<Object>();
                command.add(this.runtimePathConfig.getUnoConvertPath());
                command.add("--port");
                command.add("2003");
                command.add("--convert-to");
                command.add("pdf");
                command.add(inputPath.toString());
                command.add(outputPath.toString());
                result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.LIBRE_OFFICE).runCommandWithOutputHandling(command);
            } else {
                libreOfficeProfile = Files.createTempDirectory("libreoffice_profile_", new FileAttribute[0]);
                command = new ArrayList();
                command.add(this.runtimePathConfig.getSOfficePath());
                command.add("-env:UserInstallation=" + libreOfficeProfile.toUri().toString());
                command.add("--headless");
                command.add("--nologo");
                command.add("--convert-to");
                command.add("pdf:writer_pdf_Export");
                command.add("--outdir");
                command.add(workDir.toString());
                command.add(inputPath.toString());
                result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.LIBRE_OFFICE).runCommandWithOutputHandling(command);
            }
            if (result == null) {
                throw new IllegalStateException("Converter returned no result");
            }
            if (result.getRc() != 0) {
                throw new IllegalStateException("Conversion failed (exit " + result.getRc() + ")");
            }
            if (!Files.exists(outputPath, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(workDir);){
                    Path fallback = stream.filter(p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".pdf")).findFirst().orElse(null);
                    if (fallback == null) {
                        throw new IllegalStateException("No PDF produced.");
                    }
                    Files.move(fallback, outputPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            if (Files.size(outputPath) == 0L) {
                throw new IllegalStateException("Produced PDF is empty");
            }
            File file = outputPath.toFile();
            return file;
        }
        finally {
            try {
                Files.deleteIfExists(inputPath);
            }
            catch (IOException e) {
                log.warn("Failed to delete temp input file: {}", (Object)inputPath, (Object)e);
            }
            if (libreOfficeProfile != null) {
                FileUtils.deleteQuietly((File)libreOfficeProfile.toFile());
            }
        }
    }

    private boolean isValidFileExtension(String fileExtension) {
        return RegexPatternUtils.getInstance().getFileExtensionValidationPattern().matcher(fileExtension).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(consumes={"multipart/form-data"}, value={"/file/pdf"})
    @Operation(summary="Convert a file to a PDF using LibreOffice", description="This endpoint converts a given file to a PDF using LibreOffice API  Input:ANY Output:PDF Type:SISO")
    public ResponseEntity<byte[]> processFileToPDF(@ModelAttribute GeneralFile generalFile) throws Exception {
        MultipartFile inputFile = generalFile.getFileInput();
        File file = null;
        try {
            file = this.convertToPdf(inputFile);
            PDDocument doc = this.pdfDocumentFactory.load(file);
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)doc, (String)GeneralUtils.generateFilename((String)inputFile.getOriginalFilename(), (String)"_convertedToPDF.pdf"));
            return responseEntity;
        }
        finally {
            if (file != null && file.getParent() != null) {
                FileUtils.deleteDirectory((File)file.getParentFile());
            }
        }
    }

    @Generated
    public ConvertOfficeController(CustomPDFDocumentFactory pdfDocumentFactory, RuntimePathConfig runtimePathConfig, CustomHtmlSanitizer customHtmlSanitizer, EndpointConfiguration endpointConfiguration) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.runtimePathConfig = runtimePathConfig;
        this.customHtmlSanitizer = customHtmlSanitizer;
        this.endpointConfiguration = endpointConfiguration;
    }
}

