/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.converters.TableAttributeProvider;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.api.GeneralFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.CustomHtmlSanitizer;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.FileToPdf;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@RestController
@Tag(name="Convert", description="Convert APIs")
@RequestMapping(value={"/api/v1/convert"})
public class ConvertMarkdownToPdf {
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final RuntimePathConfig runtimePathConfig;
    private final TempFileManager tempFileManager;
    private final CustomHtmlSanitizer customHtmlSanitizer;

    @PostMapping(consumes={"multipart/form-data"}, value={"/markdown/pdf"})
    @Operation(summary="Convert a Markdown file to PDF", description="This endpoint takes a Markdown file input, converts it to HTML, and then to PDF format. Input:MARKDOWN Output:PDF Type:SISO")
    public ResponseEntity<byte[]> markdownToPdf(@ModelAttribute GeneralFile generalFile) throws Exception {
        MultipartFile fileInput = generalFile.getFileInput();
        if (fileInput == null) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.fileFormatRequired", (String)"File must be in {0} format", (Object[])new Object[]{"Markdown"});
        }
        String originalFilename = Filenames.toSimpleFileName((String)fileInput.getOriginalFilename());
        if (originalFilename == null || !originalFilename.endsWith(".md")) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.fileFormatRequired", (String)"File must be in {0} format", (Object[])new Object[]{".md"});
        }
        List<Extension> extensions = List.of(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        Node document = parser.parse(new String(fileInput.getBytes()));
        HtmlRenderer renderer = HtmlRenderer.builder().attributeProviderFactory(context -> new TableAttributeProvider()).extensions(extensions).build();
        String htmlContent = renderer.render(document);
        byte[] pdfBytes = FileToPdf.convertHtmlToPdf((String)this.runtimePathConfig.getWeasyPrintPath(), null, (byte[])htmlContent.getBytes(), (String)"converted.html", (TempFileManager)this.tempFileManager, (CustomHtmlSanitizer)this.customHtmlSanitizer);
        pdfBytes = this.pdfDocumentFactory.createNewBytesBasedOnOldDocument(pdfBytes);
        String outputFilename = GeneralUtils.generateFilename((String)originalFilename, (String)".pdf");
        return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)outputFilename);
    }

    @Generated
    public ConvertMarkdownToPdf(CustomPDFDocumentFactory pdfDocumentFactory, RuntimePathConfig runtimePathConfig, TempFileManager tempFileManager, CustomHtmlSanitizer customHtmlSanitizer) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.runtimePathConfig = runtimePathConfig;
        this.tempFileManager = tempFileManager;
        this.customHtmlSanitizer = customHtmlSanitizer;
    }
}

