/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.api.converters.HTMLToPdfRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.CustomHtmlSanitizer;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.FileToPdf;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@RestController
@Tag(name="Convert", description="Convert APIs")
@RequestMapping(value={"/api/v1/convert"})
public class ConvertHtmlToPDF {
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final RuntimePathConfig runtimePathConfig;
    private final TempFileManager tempFileManager;
    private final CustomHtmlSanitizer customHtmlSanitizer;

    @PostMapping(consumes={"multipart/form-data"}, value={"/html/pdf"})
    @Operation(summary="Convert an HTML or ZIP (containing HTML and CSS) to PDF", description="This endpoint takes an HTML or ZIP file input and converts it to a PDF format. Input:HTML Output:PDF Type:SISO")
    public ResponseEntity<byte[]> HtmlToPdf(@ModelAttribute HTMLToPdfRequest request) throws Exception {
        MultipartFile fileInput = request.getFileInput();
        if (fileInput == null) {
            throw ExceptionUtils.createHtmlFileRequiredException();
        }
        String originalFilename = Filenames.toSimpleFileName((String)fileInput.getOriginalFilename());
        if (originalFilename == null || !originalFilename.endsWith(".html") && !originalFilename.endsWith(".zip")) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.fileFormatRequired", (String)"File must be in {0} format", (Object[])new Object[]{".html or .zip"});
        }
        byte[] pdfBytes = FileToPdf.convertHtmlToPdf((String)this.runtimePathConfig.getWeasyPrintPath(), (HTMLToPdfRequest)request, (byte[])fileInput.getBytes(), (String)originalFilename, (TempFileManager)this.tempFileManager, (CustomHtmlSanitizer)this.customHtmlSanitizer);
        pdfBytes = this.pdfDocumentFactory.createNewBytesBasedOnOldDocument(pdfBytes);
        String outputFilename = GeneralUtils.generateFilename((String)originalFilename, (String)".pdf");
        return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)outputFilename);
    }

    @Generated
    public ConvertHtmlToPDF(CustomPDFDocumentFactory pdfDocumentFactory, RuntimePathConfig runtimePathConfig, TempFileManager tempFileManager, CustomHtmlSanitizer customHtmlSanitizer) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.runtimePathConfig = runtimePathConfig;
        this.tempFileManager = tempFileManager;
        this.customHtmlSanitizer = customHtmlSanitizer;
    }
}

