/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.general.SplitPdfBySizeOrCountRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/general"})
@Tag(name="General", description="General APIs")
public class SplitPdfBySizeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SplitPdfBySizeController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    @PostMapping(value={"/split-by-size-or-count"}, consumes={"multipart/form-data"})
    @Operation(summary="Auto split PDF pages into separate documents based on size or count", description="split PDF into multiple paged documents based on size/count, ie if 20 pages and split into 5, it does 5 documents each 4 pages\r\n if 10MB and each page is 1MB and you enter 2MB then 5 docs each 2MB (rounded so that it accepts 1.9MB but not 2.1MB) Input:PDF Output:ZIP-PDF Type:SISO")
    public ResponseEntity<byte[]> autoSplitPdf(@ModelAttribute SplitPdfBySizeOrCountRequest request) throws Exception {
        log.debug("Starting PDF split process with request: {}", (Object)request);
        MultipartFile file = request.getFileInput();
        String filename = GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"");
        log.debug("Base filename for output: {}", (Object)filename);
        try (TempFile zipTempFile = new TempFile(this.tempFileManager, ".zip");){
            Path managedZipPath = zipTempFile.getPath();
            log.debug("Created temporary managed zip file: {}", (Object)managedZipPath);
            try {
                log.debug("Reading input file bytes");
                byte[] pdfBytes = file.getBytes();
                log.debug("Successfully read {} bytes from input file", (Object)pdfBytes.length);
                log.debug("Creating ZIP output stream");
                try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(managedZipPath, new OpenOption[0]));){
                    log.debug("Loading PDF document");
                    try (PDDocument sourceDocument = this.pdfDocumentFactory.load(pdfBytes);){
                        log.debug("Successfully loaded PDF with {} pages", (Object)sourceDocument.getNumberOfPages());
                        int type = request.getSplitType();
                        String value = request.getSplitValue();
                        log.debug("Split type: {}, Split value: {}", (Object)type, (Object)value);
                        if (type == 0) {
                            log.debug("Processing split by size");
                            long maxBytes = GeneralUtils.convertSizeToBytes((String)value);
                            log.debug("Max bytes per document: {}", (Object)maxBytes);
                            this.handleSplitBySize(sourceDocument, maxBytes, zipOut, filename);
                        } else if (type == 1) {
                            log.debug("Processing split by page count");
                            int pageCount = Integer.parseInt(value);
                            log.debug("Pages per document: {}", (Object)pageCount);
                            this.handleSplitByPageCount(sourceDocument, pageCount, zipOut, filename);
                        } else if (type == 2) {
                            log.debug("Processing split by document count");
                            int documentCount = Integer.parseInt(value);
                            log.debug("Total number of documents: {}", (Object)documentCount);
                            this.handleSplitByDocCount(sourceDocument, documentCount, zipOut, filename);
                        } else {
                            log.error("Invalid split type: {}", (Object)type);
                            throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidArgument", (String)"Invalid argument: {0}", (Object[])new Object[]{"split type: " + type});
                        }
                        log.debug("PDF splitting completed successfully");
                    }
                }
                byte[] data = Files.readAllBytes(managedZipPath);
                log.debug("Successfully read {} bytes from ZIP file", (Object)data.length);
                log.debug("Returning response with {} bytes of data", (Object)data.length);
                ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])data, (String)(filename + ".zip"), (MediaType)MediaType.APPLICATION_OCTET_STREAM);
                return responseEntity;
            }
            catch (Exception e) {
                ExceptionUtils.logException((String)"PDF splitting process", (Exception)e);
                throw e;
            }
        }
    }

    private void handleSplitBySize(PDDocument sourceDocument, long maxBytes, ZipOutputStream zipOut, String baseFilename) throws IOException {
        log.debug("Starting handleSplitBySize with maxBytes={}", (Object)maxBytes);
        PDDocument currentDoc = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
        int fileIndex = 1;
        int totalPages = sourceDocument.getNumberOfPages();
        int pageAdded = 0;
        int baseCheckFrequency = 5;
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            int i;
            int pagesToLookAhead;
            boolean shouldCheckSize;
            PDPage page = sourceDocument.getPage(pageIndex);
            log.debug("Processing page {} of {}", (Object)(pageIndex + 1), (Object)totalPages);
            PDPage newPage = new PDPage(page.getCOSObject());
            currentDoc.addPage(newPage);
            boolean bl = shouldCheckSize = ++pageAdded % baseCheckFrequency == 0 || pageIndex == totalPages - 1 || pageAdded >= 20;
            if (!shouldCheckSize) continue;
            log.debug("Performing size check after {} pages", (Object)pageAdded);
            ByteArrayOutputStream checkSizeStream = new ByteArrayOutputStream();
            currentDoc.save((OutputStream)checkSizeStream);
            long actualSize = checkSizeStream.size();
            log.debug("Current document size: {} bytes (max: {} bytes)", (Object)actualSize, (Object)maxBytes);
            if (actualSize > maxBytes) {
                if (currentDoc.getNumberOfPages() > 1) {
                    currentDoc.removePage(currentDoc.getNumberOfPages() - 1);
                    --pageIndex;
                    log.debug("Size limit exceeded - removed last page");
                }
                log.debug("Saving document with {} pages as part {}", (Object)currentDoc.getNumberOfPages(), (Object)fileIndex);
                this.saveDocumentToZip(currentDoc, zipOut, baseFilename, fileIndex++);
                currentDoc = new PDDocument();
                pageAdded = 0;
                continue;
            }
            if (pageIndex >= totalPages - 1 || !((double)actualSize < (double)maxBytes * 0.75) || pageAdded <= 0 || (pagesToLookAhead = Math.min(5, totalPages - pageIndex - 1)) <= 0) continue;
            log.debug("Testing {} upcoming pages for potential addition", (Object)pagesToLookAhead);
            PDDocument testDoc = new PDDocument();
            for (int i2 = 0; i2 < currentDoc.getNumberOfPages(); ++i2) {
                testDoc.addPage(new PDPage(currentDoc.getPage(i2).getCOSObject()));
            }
            int extraPagesAdded = 0;
            for (i = 0; i < pagesToLookAhead; ++i) {
                int testPageIndex = pageIndex + 1 + i;
                PDPage testPage = sourceDocument.getPage(testPageIndex);
                testDoc.addPage(new PDPage(testPage.getCOSObject()));
                ByteArrayOutputStream testStream = new ByteArrayOutputStream();
                testDoc.save((OutputStream)testStream);
                long testSize = testStream.size();
                if (testSize <= maxBytes) {
                    ++extraPagesAdded;
                } else {
                    log.debug("Test: Cannot add page {} (size would be {})", (Object)(testPageIndex + 1), (Object)testSize);
                    break;
                }
                log.debug("Test: Can add page {} (size would be {})", (Object)(testPageIndex + 1), (Object)testSize);
            }
            testDoc.close();
            if (extraPagesAdded <= 0) continue;
            log.debug("Adding {} verified pages ahead", (Object)extraPagesAdded);
            for (i = 0; i < extraPagesAdded; ++i) {
                int extraPageIndex = pageIndex + 1 + i;
                PDPage extraPage = sourceDocument.getPage(extraPageIndex);
                currentDoc.addPage(new PDPage(extraPage.getCOSObject()));
            }
            pageIndex += extraPagesAdded;
            pageAdded += extraPagesAdded;
        }
        if (currentDoc.getNumberOfPages() > 0) {
            log.debug("Saving final document with {} pages as part {}", (Object)currentDoc.getNumberOfPages(), (Object)fileIndex);
            this.saveDocumentToZip(currentDoc, zipOut, baseFilename, fileIndex++);
        }
        log.debug("Completed handleSplitBySize with {} document parts created", (Object)(fileIndex - 1));
    }

    private void handleSplitByPageCount(PDDocument sourceDocument, int pageCount, ZipOutputStream zipOut, String baseFilename) throws IOException {
        int fileIndex;
        block23: {
            PDDocument currentDoc;
            log.debug("Starting handleSplitByPageCount with pageCount={}", (Object)pageCount);
            int currentPageCount = 0;
            log.debug("Creating initial output document");
            try {
                currentDoc = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
                log.debug("Successfully created initial output document");
            }
            catch (Exception e) {
                ExceptionUtils.logException((String)"initial output document creation", (Exception)e);
                throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
            }
            fileIndex = 1;
            int pageIndex = 0;
            int totalPages = sourceDocument.getNumberOfPages();
            log.debug("Processing {} pages", (Object)totalPages);
            try {
                for (PDPage page : sourceDocument.getPages()) {
                    log.debug("Processing page {} of {}", (Object)(++pageIndex), (Object)totalPages);
                    try {
                        log.debug("Adding page {} to current document", (Object)pageIndex);
                        currentDoc.addPage(page);
                        log.debug("Successfully added page {} to current document", (Object)pageIndex);
                    }
                    catch (Exception e) {
                        log.error("Error adding page {} to current document", (Object)pageIndex, (Object)e);
                        throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
                    }
                    log.debug("Current page count: {}/{}", (Object)(++currentPageCount), (Object)pageCount);
                    if (currentPageCount != pageCount) continue;
                    log.debug("Reached target page count ({}), saving current document as part {}", (Object)pageCount, (Object)fileIndex);
                    try {
                        this.saveDocumentToZip(currentDoc, zipOut, baseFilename, fileIndex++);
                        log.debug("Successfully saved document part {}", (Object)(fileIndex - 1));
                    }
                    catch (Exception e) {
                        log.error("Error saving document part {}", (Object)(fileIndex - 1), (Object)e);
                        throw e;
                    }
                    try {
                        log.debug("Creating new document for next part");
                        currentDoc = new PDDocument();
                        log.debug("Successfully created new document");
                    }
                    catch (Exception e) {
                        log.error("Error creating new document for next part", (Throwable)e);
                        throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
                    }
                    currentPageCount = 0;
                    log.debug("Reset current page count to 0");
                }
            }
            catch (Exception e) {
                log.error("Error iterating through pages", (Throwable)e);
                throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
            }
            try {
                if (currentDoc.getPages().getCount() != 0) {
                    log.debug("Saving final document with {} pages as part {}", (Object)currentDoc.getPages().getCount(), (Object)fileIndex);
                    try {
                        this.saveDocumentToZip(currentDoc, zipOut, baseFilename, fileIndex++);
                        log.debug("Successfully saved final document part {}", (Object)(fileIndex - 1));
                        break block23;
                    }
                    catch (Exception e) {
                        log.error("Error saving final document part {}", (Object)(fileIndex - 1), (Object)e);
                        throw e;
                    }
                }
                log.debug("Final document has no pages, skipping");
            }
            catch (Exception e) {
                log.error("Error checking or saving final document", (Throwable)e);
                throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
            }
            finally {
                try {
                    log.debug("Closing final document");
                    currentDoc.close();
                    log.debug("Successfully closed final document");
                }
                catch (Exception e) {
                    log.error("Error closing final document", (Throwable)e);
                }
            }
        }
        log.debug("Completed handleSplitByPageCount with {} document parts created", (Object)(fileIndex - 1));
    }

    private void handleSplitByDocCount(PDDocument sourceDocument, int documentCount, ZipOutputStream zipOut, String baseFilename) throws IOException {
        log.debug("Starting handleSplitByDocCount with documentCount={}", (Object)documentCount);
        int totalPageCount = sourceDocument.getNumberOfPages();
        log.debug("Total pages in source document: {}", (Object)totalPageCount);
        int pagesPerDocument = totalPageCount / documentCount;
        int extraPages = totalPageCount % documentCount;
        log.debug("Pages per document: {}, Extra pages: {}", (Object)pagesPerDocument, (Object)extraPages);
        int currentPageIndex = 0;
        int fileIndex = 1;
        for (int i = 0; i < documentCount; ++i) {
            PDDocument currentDoc;
            log.debug("Creating document {} of {}", (Object)(i + 1), (Object)documentCount);
            try {
                currentDoc = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
                log.debug("Successfully created document {} of {}", (Object)(i + 1), (Object)documentCount);
            }
            catch (Exception e) {
                log.error("Error creating document {} of {}", new Object[]{i + 1, documentCount, e});
                throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
            }
            int pagesToAdd = pagesPerDocument + (i < extraPages ? 1 : 0);
            log.debug("Adding {} pages to document {}", (Object)pagesToAdd, (Object)(i + 1));
            for (int j = 0; j < pagesToAdd; ++j) {
                try {
                    log.debug("Adding page {} (index {}) to document {}", new Object[]{j + 1, currentPageIndex, i + 1});
                    currentDoc.addPage(sourceDocument.getPage(currentPageIndex));
                    log.debug("Successfully added page {} to document {}", (Object)(j + 1), (Object)(i + 1));
                    ++currentPageIndex;
                    continue;
                }
                catch (Exception e) {
                    log.error("Error adding page {} to document {}", new Object[]{j + 1, i + 1, e});
                    throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
                }
            }
            try {
                log.debug("Saving document {} with {} pages", (Object)(i + 1), (Object)pagesToAdd);
                this.saveDocumentToZip(currentDoc, zipOut, baseFilename, fileIndex++);
                log.debug("Successfully saved document {}", (Object)(i + 1));
                continue;
            }
            catch (Exception e) {
                log.error("Error saving document {}", (Object)(i + 1), (Object)e);
                throw e;
            }
        }
        log.debug("Completed handleSplitByDocCount with {} documents created", (Object)documentCount);
    }

    private void saveDocumentToZip(PDDocument document, ZipOutputStream zipOut, String baseFilename, int index) throws IOException {
        log.debug("Starting saveDocumentToZip for document part {}", (Object)index);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            log.debug("Saving document part {} to byte array", (Object)index);
            document.save((OutputStream)outStream);
            log.debug("Successfully saved document part {} ({} bytes)", (Object)index, (Object)outStream.size());
        }
        catch (Exception e) {
            log.error("Error saving document part {} to byte array", (Object)index, (Object)e);
            throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
        }
        try {
            log.debug("Closing document part {}", (Object)index);
            document.close();
            log.debug("Successfully closed document part {}", (Object)index);
        }
        catch (Exception e) {
            log.error("Error closing document part {}", (Object)index, (Object)e);
        }
        try {
            String entryName = baseFilename + "_" + index + ".pdf";
            log.debug("Creating ZIP entry: {}", (Object)entryName);
            ZipEntry zipEntry = new ZipEntry(entryName);
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = outStream.toByteArray();
            log.debug("Writing {} bytes to ZIP entry", (Object)bytes.length);
            zipOut.write(bytes);
            log.debug("Closing ZIP entry");
            zipOut.closeEntry();
            log.debug("Successfully added document part {} to ZIP", (Object)index);
        }
        catch (Exception e) {
            log.error("Error adding document part {} to ZIP", (Object)index, (Object)e);
            throw ExceptionUtils.createFileProcessingException((String)"split", (Exception)e);
        }
    }

    @Generated
    public SplitPdfBySizeController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

