/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.Bookmark;
import stirling.software.SPDF.model.api.SplitPdfByChaptersRequest;
import stirling.software.common.model.PdfMetadata;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.service.PdfMetadataService;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/general"})
@Tag(name="General", description="General APIs")
public class SplitPdfByChaptersController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SplitPdfByChaptersController.class);
    private final PdfMetadataService pdfMetadataService;
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    private static List<Bookmark> extractOutlineItems(PDDocument sourceDocument, PDOutlineItem current, List<Bookmark> bookmarks, PDOutlineItem nextParent, int level, int maxLevel) throws Exception {
        while (current != null) {
            String currentTitle = current.getTitle().replace("/", "");
            int firstPage = sourceDocument.getPages().indexOf(current.findDestinationPage(sourceDocument));
            PDOutlineItem child = current.getFirstChild();
            PDOutlineItem nextSibling = current.getNextSibling();
            int endPage = child != null && level < maxLevel ? sourceDocument.getPages().indexOf(child.findDestinationPage(sourceDocument)) : (nextSibling != null ? sourceDocument.getPages().indexOf(nextSibling.findDestinationPage(sourceDocument)) : (nextParent != null ? sourceDocument.getPages().indexOf(nextParent.findDestinationPage(sourceDocument)) : -2));
            if (!bookmarks.isEmpty() && bookmarks.get(bookmarks.size() - 1).getEndPage() == -2 && firstPage >= bookmarks.get(bookmarks.size() - 1).getStartPage()) {
                Bookmark previousBookmark = bookmarks.get(bookmarks.size() - 1);
                previousBookmark.setEndPage(firstPage);
            }
            bookmarks.add(new Bookmark(currentTitle, firstPage, endPage));
            if (child != null && level < maxLevel) {
                SplitPdfByChaptersController.extractOutlineItems((PDDocument)sourceDocument, (PDOutlineItem)child, bookmarks, (PDOutlineItem)nextSibling, (int)(level + 1), (int)maxLevel);
            }
            current = nextSibling;
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/split-pdf-by-chapters"}, consumes={"multipart/form-data"})
    @Operation(summary="Split PDFs by Chapters", description="Splits a PDF into chapters and returns a ZIP file.")
    public ResponseEntity<byte[]> splitPdf(@ModelAttribute SplitPdfByChaptersRequest request) throws Exception {
        ResponseEntity responseEntity;
        MultipartFile file = request.getFileInput();
        PDDocument sourceDocument = null;
        Path zipFile = null;
        boolean includeMetadata = Boolean.TRUE.equals(request.getIncludeMetadata());
        Integer bookmarkLevel = request.getBookmarkLevel();
        if (bookmarkLevel < 0) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidArgument", (String)"Invalid argument: {0}", (Object[])new Object[]{"bookmark level"});
        }
        sourceDocument = this.pdfDocumentFactory.load(file);
        PDDocumentOutline outline = sourceDocument.getDocumentCatalog().getDocumentOutline();
        if (outline == null) {
            log.warn("No outline found for {}", (Object)file.getOriginalFilename());
            throw ExceptionUtils.createIllegalArgumentException((String)"error.pdfBookmarksNotFound", (String)"No PDF bookmarks/outline found in document", (Object[])new Object[0]);
        }
        List bookmarks = new ArrayList();
        try {
            bookmarks = SplitPdfByChaptersController.extractOutlineItems((PDDocument)sourceDocument, (PDOutlineItem)outline.getFirstChild(), bookmarks, (PDOutlineItem)outline.getFirstChild().getNextSibling(), (int)0, (int)bookmarkLevel);
            ((Bookmark)bookmarks.get(bookmarks.size() - 1)).setEndPage(sourceDocument.getNumberOfPages());
            Bookmark bookmark = (Bookmark)bookmarks.get(bookmarks.size() - 1);
        }
        catch (Exception e) {
            ExceptionUtils.logException((String)"outline extraction", (Exception)e);
            ResponseEntity responseEntity2 = ResponseEntity.internalServerError().body((Object)"Unable to extract outline items".getBytes());
            try {
                if (sourceDocument != null) {
                    sourceDocument.close();
                }
                if (zipFile != null) {
                    Files.deleteIfExists(zipFile);
                }
            }
            catch (Exception e2) {
                log.error("Error while cleaning up resources", (Throwable)e2);
            }
            return responseEntity2;
        }
        try {
            boolean allowDuplicates = Boolean.TRUE.equals(request.getAllowDuplicates());
            if (!allowDuplicates) {
                bookmarks = this.mergeBookmarksThatCorrespondToSamePage(bookmarks);
            }
            for (Bookmark bookmark : bookmarks) {
                log.info("{}::::{} to {}", new Object[]{bookmark.getTitle(), bookmark.getStartPage(), bookmark.getEndPage()});
            }
            List splitDocumentsBoas = this.getSplitDocumentsBoas(sourceDocument, bookmarks, includeMetadata);
            zipFile = this.createZipFile(bookmarks, splitDocumentsBoas);
            byte[] data = Files.readAllBytes(zipFile);
            Files.deleteIfExists(zipFile);
            String filename = GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"");
            sourceDocument.close();
            responseEntity = WebResponseUtils.bytesToWebResponse((byte[])data, (String)(filename + ".zip"), (MediaType)MediaType.APPLICATION_OCTET_STREAM);
        }
        catch (Throwable throwable) {
            try {
                if (sourceDocument != null) {
                    sourceDocument.close();
                }
                if (zipFile != null) {
                    Files.deleteIfExists(zipFile);
                }
            }
            catch (Exception e) {
                log.error("Error while cleaning up resources", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (sourceDocument != null) {
                sourceDocument.close();
            }
            if (zipFile != null) {
                Files.deleteIfExists(zipFile);
            }
        }
        catch (Exception e) {
            log.error("Error while cleaning up resources", (Throwable)e);
        }
        return responseEntity;
    }

    private List<Bookmark> mergeBookmarksThatCorrespondToSamePage(List<Bookmark> bookmarks) {
        Object mergedTitle = "";
        ArrayList<Bookmark> chaptersToBeRemoved = new ArrayList<Bookmark>();
        for (Bookmark bookmark : bookmarks) {
            if (bookmark.getStartPage() == bookmark.getEndPage()) {
                mergedTitle = ((String)mergedTitle).concat(bookmark.getTitle().concat(" "));
                chaptersToBeRemoved.add(bookmark);
                continue;
            }
            if (!((String)mergedTitle).isEmpty()) {
                if (((String)mergedTitle).length() > 255) {
                    mergedTitle = ((String)mergedTitle).substring(0, 253) + "...";
                }
                bookmarks.set(bookmarks.indexOf(bookmark), new Bookmark((String)mergedTitle, bookmark.getStartPage(), bookmark.getEndPage()));
            }
            mergedTitle = "";
        }
        bookmarks.removeAll(chaptersToBeRemoved);
        return bookmarks;
    }

    private Path createZipFile(List<Bookmark> bookmarks, List<ByteArrayOutputStream> splitDocumentsBoas) throws Exception {
        Path zipFile = Files.createTempFile("split_documents", ".zip", new FileAttribute[0]);
        String fileNumberFormatter = "%0" + Integer.toString(bookmarks.size()).length() + "d ";
        try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            for (int i = 0; i < splitDocumentsBoas.size(); ++i) {
                String fileName = String.format(Locale.ROOT, fileNumberFormatter, i) + bookmarks.get(i).getTitle() + ".pdf";
                ByteArrayOutputStream baos = splitDocumentsBoas.get(i);
                byte[] pdf = baos.toByteArray();
                ZipEntry pdfEntry = new ZipEntry(fileName);
                zipOut.putNextEntry(pdfEntry);
                zipOut.write(pdf);
                zipOut.closeEntry();
                log.debug("Wrote split document {} to zip file", (Object)fileName);
            }
        }
        catch (Exception e) {
            log.error("Failed writing to zip", (Throwable)e);
            throw e;
        }
        log.info("Successfully created zip file with split documents: {}", (Object)zipFile);
        return zipFile;
    }

    public List<ByteArrayOutputStream> getSplitDocumentsBoas(PDDocument sourceDocument, List<Bookmark> bookmarks, boolean includeMetadata) throws Exception {
        ArrayList<ByteArrayOutputStream> splitDocumentsBoas = new ArrayList<ByteArrayOutputStream>();
        PdfMetadata metadata = null;
        if (includeMetadata) {
            metadata = this.pdfMetadataService.extractMetadataFromPdf(sourceDocument);
        }
        for (Bookmark bookmark : bookmarks) {
            try (PDDocument splitDocument = new PDDocument();){
                boolean isSinglePage = bookmark.getStartPage() == bookmark.getEndPage();
                for (int i = bookmark.getStartPage(); i < bookmark.getEndPage() + (isSinglePage ? 1 : 0); ++i) {
                    PDPage page = sourceDocument.getPage(i);
                    splitDocument.addPage(page);
                    log.debug("Adding page {} to split document", (Object)i);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (includeMetadata) {
                    this.pdfMetadataService.setMetadataToPdf(splitDocument, metadata);
                }
                splitDocument.save((OutputStream)baos);
                splitDocumentsBoas.add(baos);
            }
            catch (Exception e) {
                ExceptionUtils.logException((String)"document splitting and saving", (Exception)e);
                throw e;
            }
        }
        return splitDocumentsBoas;
    }

    @Generated
    public SplitPdfByChaptersController(PdfMetadataService pdfMetadataService, CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfMetadataService = pdfMetadataService;
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

