/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.common.configuration.InstallationPathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.util.GeneralUtils;

@Controller
@Tag(name="Settings", description="Settings APIs")
@RequestMapping(value={"/api/v1/settings"})
@Hidden
public class SettingsController {
    private final ApplicationProperties applicationProperties;
    private final EndpointConfiguration endpointConfiguration;

    @PostMapping(value={"/update-enable-analytics"})
    @Hidden
    public ResponseEntity<String> updateApiKey(@RequestBody Boolean enabled) throws IOException {
        if (this.applicationProperties.getSystem().getEnableAnalytics() != null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ALREADY_REPORTED).body((Object)("Setting has already been set, To adjust please edit " + InstallationPathConfig.getSettingsPath()));
        }
        GeneralUtils.saveKeyToSettings((String)"system.enableAnalytics", (Object)enabled);
        this.applicationProperties.getSystem().setEnableAnalytics(enabled);
        return ResponseEntity.ok((Object)"Updated");
    }

    @GetMapping(value={"/get-endpoints-status"})
    @Hidden
    public ResponseEntity<Map<String, Boolean>> getDisabledEndpoints() {
        return ResponseEntity.ok((Object)this.endpointConfiguration.getEndpointStatuses());
    }

    @Generated
    public SettingsController(ApplicationProperties applicationProperties, EndpointConfiguration endpointConfiguration) {
        this.applicationProperties = applicationProperties;
        this.endpointConfiguration = endpointConfiguration;
    }
}

