/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import stirling.software.SPDF.model.api.general.MergePdfsRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PdfErrorUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/general"})
@Tag(name="General", description="General APIs")
public class MergeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    public PDDocument mergeDocuments(List<PDDocument> documents) throws IOException {
        PDDocument mergedDoc = this.pdfDocumentFactory.createNewDocument();
        for (PDDocument doc : documents) {
            for (PDPage page : doc.getPages()) {
                mergedDoc.addPage(page);
            }
        }
        return mergedDoc;
    }

    private static MultipartFile[] reorderFilesByProvidedOrder(MultipartFile[] files, String fileOrder) {
        String[] desired = RegexPatternUtils.getInstance().getNewlineSplitPattern().split(fileOrder);
        ArrayList<MultipartFile> remaining = new ArrayList<MultipartFile>(Arrays.asList(files));
        ArrayList<MultipartFile> ordered = new ArrayList<MultipartFile>(files.length);
        for (String name : desired) {
            if ((name = name.trim()).isEmpty()) {
                log.debug("Skipping empty entry");
                continue;
            }
            int idx = MergeController.indexOfByOriginalFilename(remaining, (String)name);
            if (idx >= 0) {
                ordered.add((MultipartFile)remaining.remove(idx));
                continue;
            }
            log.debug("Filename from order list not found in uploaded files: {}", (Object)name);
        }
        ordered.addAll(remaining);
        return ordered.toArray(new MultipartFile[0]);
    }

    private Comparator<MultipartFile> getSortComparator(String sortType) {
        return switch (sortType) {
            case "byFileName" -> Comparator.comparing(mf -> {
                String name = mf.getOriginalFilename();
                return name == null ? "" : name;
            }, String.CASE_INSENSITIVE_ORDER);
            case "byDateModified" -> (file1, file2) -> {
                long t1 = this.getPdfDateTimeSafe(file1);
                long t2 = this.getPdfDateTimeSafe(file2);
                return Long.compare(t2, t1);
            };
            case "byDateCreated" -> (file1, file2) -> {
                long t1 = this.getPdfDateTimeSafe(file1);
                long t2 = this.getPdfDateTimeSafe(file2);
                return Long.compare(t2, t1);
            };
            case "byPDFTitle" -> (file1, file2) -> {
                try (PDDocument doc1 = this.pdfDocumentFactory.load(file1);){
                    int n;
                    block26: {
                        String title2;
                        String title1;
                        PDDocument doc2;
                        block24: {
                            int n2;
                            block25: {
                                block22: {
                                    int n3;
                                    block23: {
                                        block20: {
                                            int n4;
                                            block21: {
                                                doc2 = this.pdfDocumentFactory.load(file2);
                                                try {
                                                    title1 = doc1.getDocumentInformation() != null ? doc1.getDocumentInformation().getTitle() : null;
                                                    String string = title2 = doc2.getDocumentInformation() != null ? doc2.getDocumentInformation().getTitle() : null;
                                                    if (title1 != null || title2 != null) break block20;
                                                    n4 = 0;
                                                    if (doc2 == null) break block21;
                                                }
                                                catch (Throwable throwable) {
                                                    if (doc2 != null) {
                                                        try {
                                                            doc2.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                    }
                                                    throw throwable;
                                                }
                                                doc2.close();
                                            }
                                            return n4;
                                        }
                                        if (title1 != null) break block22;
                                        n3 = 1;
                                        if (doc2 == null) break block23;
                                        doc2.close();
                                    }
                                    return n3;
                                }
                                if (title2 != null) break block24;
                                n2 = -1;
                                if (doc2 == null) break block25;
                                doc2.close();
                            }
                            return n2;
                        }
                        n = title1.compareToIgnoreCase(title2);
                        if (doc2 == null) break block26;
                        doc2.close();
                    }
                    return n;
                }
                catch (IOException e) {
                    return 0;
                }
            };
            case "orderProvided" -> (file1, file2) -> 0;
            default -> (file1, file2) -> 0;
        };
    }

    private void addTableOfContents(PDDocument mergedDocument, MultipartFile[] files) {
        PDDocumentOutline outline = new PDDocumentOutline();
        mergedDocument.getDocumentCatalog().setDocumentOutline(outline);
        int pageIndex = 0;
        for (MultipartFile file : files) {
            String filename = file.getOriginalFilename();
            String title = GeneralUtils.removeExtension((String)filename);
            PDOutlineItem item = new PDOutlineItem();
            item.setTitle(title);
            if (pageIndex < mergedDocument.getNumberOfPages()) {
                PDPage page = mergedDocument.getPage(pageIndex);
                item.setDestination(page);
            }
            outline.addLast(item);
            try (PDDocument doc = this.pdfDocumentFactory.load(file);){
                pageIndex += doc.getNumberOfPages();
            }
            catch (IOException e) {
                ExceptionUtils.logException((String)"document loading for TOC generation", (Exception)e);
                ++pageIndex;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private long getPdfDateTimeSafe(MultipartFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int indexOfByOriginalFilename(List<MultipartFile> list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            MultipartFile f = list.get(i);
            if (!name.equals(f.getOriginalFilename())) continue;
            return i;
        }
        return -1;
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/merge-pdfs"})
    @Operation(summary="Merge multiple PDF files into one", description="This endpoint merges multiple PDF files into a single PDF file. The merged file will contain all pages from the input files in the order they were provided. Input:PDF Output:PDF Type:MISO")
    public ResponseEntity<StreamingResponseBody> mergePdfs(@ModelAttribute MergePdfsRequest request, @RequestParam(value="fileOrder", required=false) String fileOrder) throws IOException {
        ArrayList<File> filesToDelete = new ArrayList<File>();
        TempFile outputTempFile = null;
        boolean removeCertSign = Boolean.TRUE.equals(request.getRemoveCertSign());
        boolean generateToc = request.isGenerateToc();
        MultipartFile[] files = request.getFileInput();
        if (files == null) {
            files = new MultipartFile[]{};
        }
        if (fileOrder != null && !fileOrder.isBlank()) {
            log.info("Reordering files based on fileOrder parameter");
            files = MergeController.reorderFilesByProvidedOrder((MultipartFile[])files, (String)fileOrder);
        } else {
            log.info("Sorting files based on sortType: {}", (Object)request.getSortType());
            Arrays.sort(files, this.getSortComparator(request.getSortType()));
        }
        try (TempFile mt = new TempFile(this.tempFileManager, ".pdf");){
            PDFMergerUtility mergerUtility = new PDFMergerUtility();
            long totalSize = 0L;
            for (MultipartFile multipartFile : files) {
                totalSize += multipartFile.getSize();
                File tempFile = this.tempFileManager.convertMultipartFileToFile(multipartFile);
                filesToDelete.add(tempFile);
                mergerUtility.addSource(tempFile);
            }
            mergerUtility.setDestinationFileName(mt.getFile().getAbsolutePath());
            try {
                mergerUtility.mergeDocuments(this.pdfDocumentFactory.getStreamCacheFunction(totalSize));
            }
            catch (IOException e) {
                ExceptionUtils.logException((String)"PDF merge", (Exception)e);
                if (PdfErrorUtils.isCorruptedPdfError((IOException)e)) {
                    throw ExceptionUtils.createMultiplePdfCorruptedException((Exception)e);
                }
                throw e;
            }
            try (PDDocument mergedDocument = this.pdfDocumentFactory.load(mt.getFile());){
                PDDocumentCatalog catalog;
                PDAcroForm acroForm;
                if (removeCertSign && (acroForm = (catalog = mergedDocument.getDocumentCatalog()).getAcroForm()) != null) {
                    List<PDField> fieldsToRemove = acroForm.getFields().stream().filter(PDSignatureField.class::isInstance).toList();
                    if (!fieldsToRemove.isEmpty()) {
                        acroForm.flatten(fieldsToRemove, false);
                    }
                }
                if (generateToc && files.length > 0) {
                    this.addTableOfContents(mergedDocument, files);
                }
                outputTempFile = new TempFile(this.tempFileManager, ".pdf");
                mergedDocument.save(outputTempFile.getFile());
            }
        }
        catch (Exception ex) {
            if (ex instanceof IOException && PdfErrorUtils.isCorruptedPdfError((IOException)((IOException)ex))) {
                log.warn("Corrupted PDF detected in merge pdf process: {}", (Object)ex.getMessage());
            } else {
                log.error("Error in merge pdf process", (Throwable)ex);
            }
            throw ex;
        }
        finally {
            for (File file : filesToDelete) {
                this.tempFileManager.deleteTempFile(file);
            }
        }
        String firstFilename = files.length > 0 ? files[0].getOriginalFilename() : null;
        String mergedFileName = GeneralUtils.generateFilename((String)firstFilename, (String)"_merged_unsigned.pdf");
        ResponseEntity response = WebResponseUtils.pdfFileToWebResponse((TempFile)outputTempFile, (String)mergedFileName);
        return response;
    }

    @Generated
    public MergeController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

