/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import stirling.software.SPDF.controller.api.CropController;
import stirling.software.SPDF.model.api.general.CropPdfForm;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/general"})
@Tag(name="General", description="General APIs")
public class CropController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CropController.class);
    private static final int DEFAULT_RENDER_DPI = 150;
    private static final int WHITE_THRESHOLD = 250;
    private static final String TEMP_INPUT_PREFIX = "crop_input";
    private static final String TEMP_OUTPUT_PREFIX = "crop_output";
    private static final String PDF_EXTENSION = ".pdf";
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    private static int[] detectContentBounds(BufferedImage image) {
        int x;
        int width = image.getWidth();
        int height = image.getHeight();
        if (width < 1 || height < 1) {
            return new int[]{0, 0, width - 1, height - 1};
        }
        int step = width > 2000 || height > 2000 ? 2 : 1;
        int top = 0;
        boolean found = false;
        block0: for (int y = 0; y < height && !found; y += step) {
            for (int x2 = 0; x2 < width; x2 += step) {
                if (CropController.isWhite((int)image.getRGB(x2, y), (int)250)) continue;
                top = y;
                found = true;
                continue block0;
            }
        }
        int bottom = height - 1;
        found = false;
        block2: for (int y = height - 1; y >= 0 && !found; y -= step) {
            for (x = 0; x < width; x += step) {
                if (CropController.isWhite((int)image.getRGB(x, y), (int)250)) continue;
                bottom = y;
                found = true;
                continue block2;
            }
        }
        int left = 0;
        found = false;
        block4: for (x = 0; x < width && !found; x += step) {
            for (int y = top; y <= bottom; y += step) {
                if (CropController.isWhite((int)image.getRGB(x, y), (int)250)) continue;
                left = x;
                found = true;
                continue block4;
            }
        }
        int right = width - 1;
        found = false;
        block6: for (int x3 = width - 1; x3 >= 0 && !found; x3 -= step) {
            for (int y = top; y <= bottom; y += step) {
                if (CropController.isWhite((int)image.getRGB(x3, y), (int)250)) continue;
                right = x3;
                found = true;
                continue block6;
            }
        }
        return new int[]{left, height - bottom - 1, right, height - top - 1};
    }

    private static boolean isWhite(int rgb, int threshold) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return r >= threshold && g >= threshold && b >= threshold;
    }

    @PostMapping(value={"/crop"}, consumes={"multipart/form-data"})
    @Operation(summary="Crops a PDF document", description="This operation takes an input PDF file and crops it according to the given coordinates. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> cropPdf(@ModelAttribute CropPdfForm request) throws IOException {
        if (request.isAutoCrop()) {
            return this.cropWithAutomaticDetection(request);
        }
        if (request.getX() == null || request.getY() == null || request.getWidth() == null || request.getHeight() == null) {
            throw new IllegalArgumentException("Crop coordinates (x, y, width, height) are required when auto-crop is not enabled");
        }
        if (request.isRemoveDataOutsideCrop()) {
            return this.cropWithGhostscript(request);
        }
        return this.cropWithPDFBox(request);
    }

    private ResponseEntity<byte[]> cropWithAutomaticDetection(@ModelAttribute CropPdfForm request) throws IOException {
        try (PDDocument sourceDocument = this.pdfDocumentFactory.load((PDFFile)request);){
            ResponseEntity responseEntity;
            block19: {
                PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
                try {
                    PDFRenderer renderer = new PDFRenderer(sourceDocument);
                    LayerUtility layerUtility = new LayerUtility(newDocument);
                    for (int i = 0; i < sourceDocument.getNumberOfPages(); ++i) {
                        PDPage sourcePage = sourceDocument.getPage(i);
                        PDRectangle mediaBox = sourcePage.getMediaBox();
                        BufferedImage image = renderer.renderImageWithDPI(i, 150.0f);
                        int[] bounds = CropController.detectContentBounds((BufferedImage)image);
                        float scaleX = mediaBox.getWidth() / (float)image.getWidth();
                        float scaleY = mediaBox.getHeight() / (float)image.getHeight();
                        CropBounds cropBounds = CropBounds.fromPixels((int[])bounds, (float)scaleX, (float)scaleY);
                        PDPage newPage = new PDPage(mediaBox);
                        newDocument.addPage(newPage);
                        try (PDPageContentStream contentStream = new PDPageContentStream(newDocument, newPage, PDPageContentStream.AppendMode.OVERWRITE, true, true);){
                            PDFormXObject formXObject = layerUtility.importPageAsForm(sourceDocument, i);
                            contentStream.saveGraphicsState();
                            contentStream.addRect(cropBounds.x, cropBounds.y, cropBounds.width, cropBounds.height);
                            contentStream.clip();
                            contentStream.drawForm(formXObject);
                            contentStream.restoreGraphicsState();
                        }
                        newPage.setMediaBox(new PDRectangle(cropBounds.x, cropBounds.y, cropBounds.width, cropBounds.height));
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    newDocument.save((OutputStream)baos);
                    byte[] pdfContent = baos.toByteArray();
                    responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)GeneralUtils.generateFilename((String)request.getFileInput().getOriginalFilename(), (String)"_cropped.pdf"));
                    if (newDocument == null) break block19;
                }
                catch (Throwable throwable) {
                    if (newDocument != null) {
                        try {
                            newDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                newDocument.close();
            }
            return responseEntity;
        }
    }

    private ResponseEntity<byte[]> cropWithPDFBox(@ModelAttribute CropPdfForm request) throws IOException {
        try (PDDocument sourceDocument = this.pdfDocumentFactory.load((PDFFile)request);){
            ResponseEntity responseEntity;
            block19: {
                PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
                try {
                    int totalPages = sourceDocument.getNumberOfPages();
                    LayerUtility layerUtility = new LayerUtility(newDocument);
                    for (int i = 0; i < totalPages; ++i) {
                        PDPage sourcePage = sourceDocument.getPage(i);
                        PDPage newPage = new PDPage(sourcePage.getMediaBox());
                        newDocument.addPage(newPage);
                        try (PDPageContentStream contentStream = new PDPageContentStream(newDocument, newPage, PDPageContentStream.AppendMode.OVERWRITE, true, true);){
                            PDFormXObject formXObject = layerUtility.importPageAsForm(sourceDocument, i);
                            contentStream.saveGraphicsState();
                            contentStream.addRect(request.getX().floatValue(), request.getY().floatValue(), request.getWidth().floatValue(), request.getHeight().floatValue());
                            contentStream.clip();
                            contentStream.drawForm(formXObject);
                            contentStream.restoreGraphicsState();
                        }
                        newPage.setMediaBox(new PDRectangle(request.getX().floatValue(), request.getY().floatValue(), request.getWidth().floatValue(), request.getHeight().floatValue()));
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    newDocument.save((OutputStream)baos);
                    byte[] pdfContent = baos.toByteArray();
                    responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)GeneralUtils.generateFilename((String)request.getFileInput().getOriginalFilename(), (String)"_cropped.pdf"));
                    if (newDocument == null) break block19;
                }
                catch (Throwable throwable) {
                    if (newDocument != null) {
                        try {
                            newDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                newDocument.close();
            }
            return responseEntity;
        }
    }

    /*
     * Loose catch block
     */
    private ResponseEntity<byte[]> cropWithGhostscript(@ModelAttribute CropPdfForm request) throws IOException {
        ResponseEntity responseEntity;
        PDDocument sourceDocument;
        Path tempOutputFile;
        Path tempInputFile;
        block15: {
            block14: {
                tempInputFile = null;
                tempOutputFile = null;
                sourceDocument = this.pdfDocumentFactory.load((PDFFile)request);
                for (int i = 0; i < sourceDocument.getNumberOfPages(); ++i) {
                    PDPage page = sourceDocument.getPage(i);
                    PDRectangle cropBox = new PDRectangle(request.getX().floatValue(), request.getY().floatValue(), request.getWidth().floatValue(), request.getHeight().floatValue());
                    page.setCropBox(cropBox);
                }
                tempInputFile = Files.createTempFile("crop_input", ".pdf", new FileAttribute[0]);
                tempOutputFile = Files.createTempFile("crop_output", ".pdf", new FileAttribute[0]);
                sourceDocument.save(tempInputFile.toFile());
                ProcessExecutor processExecutor = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT);
                List<String> command = List.of("gs", "-sDEVICE=pdfwrite", "-dUseCropBox", "-o", tempOutputFile.toString(), tempInputFile.toString());
                processExecutor.runCommandWithOutputHandling(command);
                byte[] pdfContent = Files.readAllBytes(tempOutputFile);
                responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)GeneralUtils.generateFilename((String)request.getFileInput().getOriginalFilename(), (String)"_cropped.pdf"));
                if (sourceDocument == null) break block14;
                sourceDocument.close();
            }
            if (tempInputFile == null) break block15;
            Files.deleteIfExists(tempInputFile);
        }
        if (tempOutputFile != null) {
            Files.deleteIfExists(tempOutputFile);
        }
        return responseEntity;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (sourceDocument != null) {
                            try {
                                sourceDocument.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ExceptionUtils.createProcessingInterruptedException((String)"Ghostscript", (InterruptedException)e);
                    }
                }
                catch (Throwable throwable3) {
                    if (tempInputFile != null) {
                        Files.deleteIfExists(tempInputFile);
                    }
                    if (tempOutputFile != null) {
                        Files.deleteIfExists(tempOutputFile);
                    }
                    throw throwable3;
                }
            }
        }
    }

    @Generated
    public CropController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

