/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;

@RestController
@RequestMapping(value={"/api/v1/analysis"})
@Tag(name="Analysis", description="Analysis APIs")
public class AnalysisController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @PostMapping(value={"/page-count"}, consumes={"multipart/form-data"})
    @Operation(summary="Get PDF page count", description="Returns total number of pages in PDF. Input:PDF Output:JSON Type:SISO")
    public Map<String, Integer> getPageCount(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput());){
            Map<String, Integer> map = Map.of("pageCount", document.getNumberOfPages());
            return map;
        }
    }

    @PostMapping(value={"/basic-info"}, consumes={"multipart/form-data"})
    @Operation(summary="Get basic PDF information", description="Returns page count, version, file size. Input:PDF Output:JSON Type:SISO")
    public Map<String, Object> getBasicInfo(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput());){
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("pageCount", document.getNumberOfPages());
            info.put("pdfVersion", Float.valueOf(document.getVersion()));
            info.put("fileSize", file.getFileInput().getSize());
            HashMap<String, Object> hashMap = info;
            return hashMap;
        }
    }

    @PostMapping(value={"/document-properties"}, consumes={"multipart/form-data"})
    @Operation(summary="Get PDF document properties", description="Returns title, author, subject, etc. Input:PDF Output:JSON Type:SISO")
    public Map<String, String> getDocumentProperties(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput(), true);){
            PDDocumentInformation info = document.getDocumentInformation();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("title", info.getTitle());
            properties.put("author", info.getAuthor());
            properties.put("subject", info.getSubject());
            properties.put("keywords", info.getKeywords());
            properties.put("creator", info.getCreator());
            properties.put("producer", info.getProducer());
            properties.put("creationDate", info.getCreationDate().toString());
            properties.put("modificationDate", info.getModificationDate().toString());
            HashMap<String, String> hashMap = properties;
            return hashMap;
        }
    }

    @PostMapping(value={"/page-dimensions"}, consumes={"multipart/form-data"})
    @Operation(summary="Get page dimensions for all pages", description="Returns width and height of each page. Input:PDF Output:JSON Type:SISO")
    public List<Map<String, Float>> getPageDimensions(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput());){
            ArrayList dimensions = new ArrayList();
            PDPageTree pages = document.getPages();
            for (PDPage page : pages) {
                HashMap<String, Float> pageDim = new HashMap<String, Float>();
                pageDim.put("width", Float.valueOf(page.getBBox().getWidth()));
                pageDim.put("height", Float.valueOf(page.getBBox().getHeight()));
                dimensions.add(pageDim);
            }
            ArrayList arrayList = dimensions;
            return arrayList;
        }
    }

    @PostMapping(value={"/form-fields"}, consumes={"multipart/form-data"})
    @Operation(summary="Get form field information", description="Returns count and details of form fields. Input:PDF Output:JSON Type:SISO")
    public Map<String, Object> getFormFields(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput());){
            HashMap<String, Object> formInfo = new HashMap<String, Object>();
            PDAcroForm form = document.getDocumentCatalog().getAcroForm();
            if (form != null) {
                formInfo.put("fieldCount", form.getFields().size());
                formInfo.put("hasXFA", form.hasXFA());
                formInfo.put("isSignaturesExist", form.isSignaturesExist());
            } else {
                formInfo.put("fieldCount", 0);
                formInfo.put("hasXFA", false);
                formInfo.put("isSignaturesExist", false);
            }
            HashMap<String, Object> hashMap = formInfo;
            return hashMap;
        }
    }

    @PostMapping(value={"/annotation-info"}, consumes={"multipart/form-data"})
    @Operation(summary="Get annotation information", description="Returns count and types of annotations. Input:PDF Output:JSON Type:SISO")
    public Map<String, Object> getAnnotationInfo(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput());){
            HashMap<String, Serializable> annotInfo = new HashMap<String, Serializable>();
            int totalAnnotations = 0;
            HashMap<String, Integer> annotationTypes = new HashMap<String, Integer>();
            for (PDPage page : document.getPages()) {
                for (PDAnnotation annot : page.getAnnotations()) {
                    ++totalAnnotations;
                    String subType = annot.getSubtype();
                    annotationTypes.merge(subType, 1, Integer::sum);
                }
            }
            annotInfo.put("totalCount", Integer.valueOf(totalAnnotations));
            annotInfo.put("typeBreakdown", annotationTypes);
            HashMap<String, Serializable> hashMap = annotInfo;
            return hashMap;
        }
    }

    @PostMapping(value={"/font-info"}, consumes={"multipart/form-data"})
    @Operation(summary="Get font information", description="Returns list of fonts used in the document. Input:PDF Output:JSON Type:SISO")
    public Map<String, Object> getFontInfo(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput());){
            HashMap<String, Serializable> fontInfo = new HashMap<String, Serializable>();
            HashSet<String> fontNames = new HashSet<String>();
            for (PDPage page : document.getPages()) {
                for (COSName font : page.getResources().getFontNames()) {
                    fontNames.add(font.getName());
                }
            }
            fontInfo.put("fontCount", Integer.valueOf(fontNames.size()));
            fontInfo.put("fonts", fontNames);
            HashMap<String, Serializable> hashMap = fontInfo;
            return hashMap;
        }
    }

    @PostMapping(value={"/security-info"}, consumes={"multipart/form-data"})
    @Operation(summary="Get security information", description="Returns encryption and permission details. Input:PDF Output:JSON Type:SISO")
    public Map<String, Object> getSecurityInfo(@ModelAttribute PDFFile file) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(file.getFileInput());){
            HashMap<String, Object> securityInfo = new HashMap<String, Object>();
            PDEncryption encryption = document.getEncryption();
            if (encryption != null) {
                securityInfo.put("isEncrypted", true);
                securityInfo.put("keyLength", encryption.getLength());
                HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
                permissions.put("preventPrinting", !document.getCurrentAccessPermission().canPrint());
                permissions.put("preventModify", !document.getCurrentAccessPermission().canModify());
                permissions.put("preventExtractContent", !document.getCurrentAccessPermission().canExtractContent());
                permissions.put("preventModifyAnnotations", !document.getCurrentAccessPermission().canModifyAnnotations());
                securityInfo.put("permissions", permissions);
            } else {
                securityInfo.put("isEncrypted", false);
            }
            HashMap<String, Object> hashMap = securityInfo;
            return hashMap;
        }
    }

    @Generated
    public AnalysisController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

