/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import stirling.software.common.model.ApplicationProperties;

@Configuration
public class OpenApiConfig {
    private final ApplicationProperties applicationProperties;
    private static final String DEFAULT_TITLE = "Stirling PDF API";
    private static final String DEFAULT_DESCRIPTION = "API documentation for all Server-Side processing.\nPlease note some functionality might be UI only and missing from here.";

    @Bean
    public OpenAPI customOpenAPI() {
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version == null) {
            version = "1.0.0";
        }
        Info info = new Info().title(DEFAULT_TITLE).version(version).license(new License().name("MIT").url("https://raw.githubusercontent.com/Stirling-Tools/Stirling-PDF/refs/heads/main/LICENSE").identifier("MIT")).termsOfService("https://www.stirlingpdf.com/terms").contact(new Contact().name("Stirling Software").url("https://www.stirlingpdf.com").email("contact@stirlingpdf.com")).description(DEFAULT_DESCRIPTION);
        if (!this.applicationProperties.getSecurity().isEnableLogin()) {
            return new OpenAPI().components(new Components()).info(info);
        }
        SecurityScheme apiKeyScheme = new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name("X-API-KEY");
        return new OpenAPI().components(new Components().addSecuritySchemes("apiKey", apiKeyScheme)).info(info).addSecurityItem(new SecurityRequirement().addList("apiKey"));
    }

    @Generated
    public OpenApiConfig(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }
}

