/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import stirling.software.common.util.RequestUriUtils;

@Component
public class MetricsFilter
extends OncePerRequestFilter {
    private final MeterRegistry meterRegistry;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String uri = request.getRequestURI();
        if (RequestUriUtils.isTrackableResource((String)request.getContextPath(), (String)uri)) {
            HttpSession session = request.getSession(false);
            String sessionId = session != null ? session.getId() : "no-session";
            Counter counter = Counter.builder((String)"http.requests").tag("session", sessionId).tag("method", request.getMethod()).tag("uri", uri).register(this.meterRegistry);
            counter.increment();
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public MetricsFilter(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

