/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class EndpointInspector
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointInspector.class);
    private final ApplicationContext applicationContext;
    private final Set<String> validGetEndpoints = new HashSet();
    private boolean endpointsDiscovered = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.endpointsDiscovered) {
            this.discoverEndpoints();
            this.endpointsDiscovered = true;
        }
    }

    private void discoverEndpoints() {
        try {
            Map mappings = this.applicationContext.getBeansOfType(RequestMappingHandlerMapping.class);
            for (Map.Entry entry : mappings.entrySet()) {
                RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)entry.getValue();
                Map handlerMethods = mapping.getHandlerMethods();
                for (Map.Entry handlerEntry : handlerMethods.entrySet()) {
                    RequestMappingInfo mappingInfo = (RequestMappingInfo)handlerEntry.getKey();
                    HandlerMethod handlerMethod = (HandlerMethod)handlerEntry.getValue();
                    boolean isGetHandler = false;
                    try {
                        Set methods = mappingInfo.getMethodsCondition().getMethods();
                        isGetHandler = methods.isEmpty() || methods.contains(RequestMethod.GET);
                    }
                    catch (Exception e) {
                        isGetHandler = true;
                    }
                    if (!isGetHandler) continue;
                    Set patterns = this.extractPatternsUsingDirectPaths(mappingInfo);
                    if (patterns.isEmpty()) {
                        patterns = this.extractPatternsFromString(mappingInfo);
                    }
                    this.validGetEndpoints.addAll(patterns);
                }
            }
            if (this.validGetEndpoints.isEmpty()) {
                log.warn("No endpoints discovered. Adding common endpoints as fallback.");
                this.validGetEndpoints.add("/");
                this.validGetEndpoints.add("/api/**");
                this.validGetEndpoints.add("/**");
            }
        }
        catch (Exception e) {
            log.error("Error discovering endpoints", (Throwable)e);
        }
    }

    private Set<String> extractPatternsUsingDirectPaths(RequestMappingInfo mappingInfo) {
        HashSet<String> patterns = new HashSet<String>();
        try {
            Method getDirectPathsMethod = mappingInfo.getClass().getMethod("getDirectPaths", new Class[0]);
            Object result = getDirectPathsMethod.invoke((Object)mappingInfo, new Object[0]);
            if (result instanceof Set) {
                Set resultSet = (Set)result;
                patterns.addAll(resultSet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return patterns;
    }

    private Set<String> extractPatternsFromString(RequestMappingInfo mappingInfo) {
        HashSet<String> patterns = new HashSet<String>();
        try {
            String infoString = mappingInfo.toString();
            if (infoString.contains("{")) {
                String patternsSection = infoString.substring(infoString.indexOf("{") + 1, infoString.indexOf("}"));
                for (String pattern : patternsSection.split(",")) {
                    if ((pattern = pattern.trim()).isEmpty()) continue;
                    patterns.add(pattern);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return patterns;
    }

    public boolean isValidGetEndpoint(String uri) {
        if (!this.endpointsDiscovered) {
            this.discoverEndpoints();
            this.endpointsDiscovered = true;
        }
        if (this.validGetEndpoints.contains(uri)) {
            return true;
        }
        if (this.matchesWildcardOrPathVariable(uri)) {
            return true;
        }
        return this.matchesPathSegments(uri);
    }

    private boolean matchesWildcardOrPathVariable(String uri) {
        for (String pattern : this.validGetEndpoints) {
            if (!pattern.contains("*") && !pattern.contains("{")) continue;
            int wildcardIndex = pattern.indexOf(42);
            int variableIndex = pattern.indexOf(123);
            int cutoffIndex = wildcardIndex < 0 ? variableIndex : (variableIndex < 0 ? wildcardIndex : Math.min(wildcardIndex, variableIndex));
            String staticPrefix = pattern.substring(0, cutoffIndex);
            if (!uri.startsWith(staticPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPathSegments(String uri) {
        for (String pattern : this.validGetEndpoints) {
            if (pattern.contains("*") || pattern.contains("{")) continue;
            String[] patternSegments = pattern.split("/");
            String[] uriSegments = uri.split("/");
            if (uriSegments.length < patternSegments.length) continue;
            boolean match = true;
            for (int i = 0; i < patternSegments.length; ++i) {
                if (patternSegments[i].equals(uriSegments[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public Set<String> getValidGetEndpoints() {
        if (!this.endpointsDiscovered) {
            this.discoverEndpoints();
            this.endpointsDiscovered = true;
        }
        return new HashSet<String>(this.validGetEndpoints);
    }

    private void logAllEndpoints() {
        TreeSet sortedEndpoints = new TreeSet(this.validGetEndpoints);
        log.info("=== BEGIN: All discovered GET endpoints ===");
        for (String endpoint : sortedEndpoints) {
            log.info("Endpoint: {}", (Object)endpoint);
        }
        log.info("=== END: All discovered GET endpoints ===");
    }

    @Generated
    public EndpointInspector(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

