/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import stirling.software.common.model.ApplicationProperties;

@Service
public class EndpointConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointConfiguration.class);
    private static final String REMOVE_BLANKS = "remove-blanks";
    private final ApplicationProperties applicationProperties;
    private Map<String, Boolean> endpointStatuses = new ConcurrentHashMap();
    private Map<String, Set<String>> endpointGroups = new ConcurrentHashMap();
    private Set<String> disabledGroups = new HashSet();
    private Map<String, Set<String>> endpointAlternatives = new ConcurrentHashMap();
    private final boolean runningProOrHigher;

    public EndpointConfiguration(ApplicationProperties applicationProperties, @Qualifier(value="runningProOrHigher") boolean runningProOrHigher) {
        this.applicationProperties = applicationProperties;
        this.runningProOrHigher = runningProOrHigher;
        this.init();
        this.processEnvironmentConfigs();
    }

    public void enableEndpoint(String endpoint) {
        this.endpointStatuses.put(endpoint, true);
        log.debug("Enabled endpoint: {}", (Object)endpoint);
    }

    public void disableEndpoint(String endpoint) {
        if (!Boolean.FALSE.equals(this.endpointStatuses.get(endpoint))) {
            log.debug("Disabling endpoint: {}", (Object)endpoint);
        }
        this.endpointStatuses.put(endpoint, false);
    }

    public boolean isEndpointEnabled(String endpoint) {
        Boolean explicitStatus;
        String original = endpoint;
        if (endpoint.startsWith("/")) {
            endpoint = endpoint.substring(1);
        }
        if (Boolean.FALSE.equals(explicitStatus = (Boolean)this.endpointStatuses.get(endpoint))) {
            log.debug("isEndpointEnabled('{}') -> false (explicitly disabled)", (Object)original);
            return false;
        }
        for (String group : this.endpointGroups.keySet()) {
            if (!this.disabledGroups.contains(group) || !((Set)this.endpointGroups.get(group)).contains(endpoint) || this.isToolGroup(group)) continue;
            log.debug("isEndpointEnabled('{}') -> false (functional group '{}' disabled)", (Object)original, (Object)group);
            return false;
        }
        Set alternatives = (Set)this.endpointAlternatives.get(endpoint);
        if (alternatives != null && !alternatives.isEmpty()) {
            boolean hasEnabledToolGroup = alternatives.stream().anyMatch(toolGroup -> !this.disabledGroups.contains(toolGroup));
            log.debug("isEndpointEnabled('{}') -> {} (tool groups check)", (Object)original, (Object)hasEnabledToolGroup);
            return hasEnabledToolGroup;
        }
        for (String group : this.endpointGroups.keySet()) {
            if (!this.isToolGroup(group) || !this.disabledGroups.contains(group) || !((Set)this.endpointGroups.get(group)).contains(endpoint)) continue;
            log.debug("isEndpointEnabled('{}') -> false (single tool group '{}' disabled, no alternatives)", (Object)original, (Object)group);
            return false;
        }
        boolean enabled = !Boolean.FALSE.equals(explicitStatus);
        log.debug("isEndpointEnabled('{}') -> {} (default)", (Object)original, (Object)enabled);
        return enabled;
    }

    public boolean isGroupEnabled(String group) {
        if (this.disabledGroups.contains(group)) {
            log.debug("isGroupEnabled('{}') -> false (explicitly disabled)", (Object)group);
            return false;
        }
        Set endpoints = (Set)this.endpointGroups.get(group);
        if (endpoints == null || endpoints.isEmpty()) {
            log.debug("isGroupEnabled('{}') -> false (no endpoints)", (Object)group);
            return false;
        }
        if (this.isToolGroup(group)) {
            log.debug("isGroupEnabled('{}') -> true (tool group not disabled)", (Object)group);
            return true;
        }
        for (String endpoint : endpoints) {
            if (this.isEndpointEnabledDirectly(endpoint)) continue;
            log.debug("isGroupEnabled('{}') -> false (endpoint '{}' disabled)", (Object)group, (Object)endpoint);
            return false;
        }
        log.debug("isGroupEnabled('{}') -> true (all endpoints enabled)", (Object)group);
        return true;
    }

    public void addEndpointToGroup(String group, String endpoint) {
        this.endpointGroups.computeIfAbsent(group, k -> new HashSet()).add(endpoint);
    }

    public void addEndpointAlternative(String endpoint, String toolGroup) {
        this.endpointAlternatives.computeIfAbsent(endpoint, k -> new HashSet()).add(toolGroup);
    }

    public void disableGroup(String group) {
        Set endpoints;
        if (this.disabledGroups.add(group)) {
            if (this.isToolGroup(group)) {
                log.debug("Disabling tool group: {} (endpoints with alternatives remain available)", (Object)group);
            } else {
                log.debug("Disabling functional group: {} (will disable all endpoints in group)", (Object)group);
            }
        }
        if (!this.isToolGroup(group) && (endpoints = (Set)this.endpointGroups.get(group)) != null) {
            endpoints.forEach(arg_0 -> this.disableEndpoint(arg_0));
        }
    }

    public void enableGroup(String group) {
        Set endpoints;
        if (this.disabledGroups.remove(group)) {
            log.debug("Enabling group: {}", (Object)group);
        }
        if ((endpoints = (Set)this.endpointGroups.get(group)) != null) {
            endpoints.forEach(arg_0 -> this.enableEndpoint(arg_0));
        }
    }

    public Set<String> getDisabledGroups() {
        return new HashSet<String>(this.disabledGroups);
    }

    public void logDisabledEndpointsSummary() {
        Set allEndpoints = this.endpointGroups.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        List<String> functionallyDisabledEndpoints = allEndpoints.stream().filter(endpoint -> !this.isEndpointEnabled(endpoint)).sorted().toList();
        List<String> disabledToolGroups = this.disabledGroups.stream().filter(arg_0 -> this.isToolGroup(arg_0)).sorted().toList();
        List<String> disabledFunctionalGroups = this.disabledGroups.stream().filter(group -> !this.isToolGroup(group)).sorted().toList();
        if (!disabledToolGroups.isEmpty()) {
            log.info("Disabled tool groups: {} (endpoints may have alternative implementations)", (Object)String.join((CharSequence)", ", disabledToolGroups));
        }
        if (!disabledFunctionalGroups.isEmpty()) {
            log.info("Disabled functional groups: {}", (Object)String.join((CharSequence)", ", disabledFunctionalGroups));
        }
        if (!functionallyDisabledEndpoints.isEmpty()) {
            log.info("Total disabled endpoints: {}. Disabled endpoints: {}", (Object)functionallyDisabledEndpoints.size(), (Object)String.join((CharSequence)", ", functionallyDisabledEndpoints));
        } else if (!disabledToolGroups.isEmpty()) {
            log.info("No endpoints disabled despite missing tools - fallback implementations available");
        }
    }

    public void init() {
        this.addEndpointToGroup("PageOps", "remove-pages");
        this.addEndpointToGroup("PageOps", "merge-pdfs");
        this.addEndpointToGroup("PageOps", "split-pdfs");
        this.addEndpointToGroup("PageOps", "pdf-organizer");
        this.addEndpointToGroup("PageOps", "rotate-pdf");
        this.addEndpointToGroup("PageOps", "multi-page-layout");
        this.addEndpointToGroup("PageOps", "scale-pages");
        this.addEndpointToGroup("PageOps", "crop");
        this.addEndpointToGroup("PageOps", "extract-page");
        this.addEndpointToGroup("PageOps", "pdf-to-single-page");
        this.addEndpointToGroup("PageOps", "auto-split-pdf");
        this.addEndpointToGroup("PageOps", "split-by-size-or-count");
        this.addEndpointToGroup("PageOps", "overlay-pdf");
        this.addEndpointToGroup("PageOps", "split-pdf-by-sections");
        this.addEndpointToGroup("PageOps", "split-pdf-by-chapters");
        this.addEndpointToGroup("Convert", "pdf-to-img");
        this.addEndpointToGroup("Convert", "img-to-pdf");
        this.addEndpointToGroup("Convert", "pdf-to-pdfa");
        this.addEndpointToGroup("Convert", "file-to-pdf");
        this.addEndpointToGroup("Convert", "pdf-to-word");
        this.addEndpointToGroup("Convert", "pdf-to-presentation");
        this.addEndpointToGroup("Convert", "pdf-to-text");
        this.addEndpointToGroup("Convert", "pdf-to-html");
        this.addEndpointToGroup("Convert", "pdf-to-xml");
        this.addEndpointToGroup("Convert", "html-to-pdf");
        this.addEndpointToGroup("Convert", "url-to-pdf");
        this.addEndpointToGroup("Convert", "markdown-to-pdf");
        this.addEndpointToGroup("Convert", "ebook-to-pdf");
        this.addEndpointToGroup("Convert", "pdf-to-epub");
        this.addEndpointToGroup("Convert", "pdf-to-csv");
        this.addEndpointToGroup("Convert", "pdf-to-markdown");
        this.addEndpointToGroup("Convert", "eml-to-pdf");
        this.addEndpointToGroup("Convert", "pdf-to-vector");
        this.addEndpointToGroup("Convert", "vector-to-pdf");
        this.addEndpointToGroup("Convert", "pdf-to-video");
        this.addEndpointToGroup("Security", "add-password");
        this.addEndpointToGroup("Security", "remove-password");
        this.addEndpointToGroup("Security", "change-permissions");
        this.addEndpointToGroup("Security", "add-watermark");
        this.addEndpointToGroup("Security", "cert-sign");
        this.addEndpointToGroup("Security", "remove-cert-sign");
        this.addEndpointToGroup("Security", "sanitize-pdf");
        this.addEndpointToGroup("Security", "auto-redact");
        this.addEndpointToGroup("Security", "redact");
        this.addEndpointToGroup("Security", "validate-signature");
        this.addEndpointToGroup("Security", "stamp");
        this.addEndpointToGroup("Security", "sign");
        this.addEndpointToGroup("Other", "ocr-pdf");
        this.addEndpointToGroup("Other", "add-image");
        this.addEndpointToGroup("Other", "extract-images");
        this.addEndpointToGroup("Other", "change-metadata");
        this.addEndpointToGroup("Other", "flatten");
        this.addEndpointToGroup("Other", "unlock-pdf-forms");
        this.addEndpointToGroup("Other", REMOVE_BLANKS);
        this.addEndpointToGroup("Other", "remove-annotations");
        this.addEndpointToGroup("Other", "compare");
        this.addEndpointToGroup("Other", "add-page-numbers");
        this.addEndpointToGroup("Other", "get-info-on-pdf");
        this.addEndpointToGroup("Other", "remove-image-pdf");
        this.addEndpointToGroup("Other", "add-attachments");
        this.addEndpointToGroup("Other", "view-pdf");
        this.addEndpointToGroup("Other", "replace-and-invert-color-pdf");
        this.addEndpointToGroup("Other", "multi-tool");
        this.addEndpointToGroup("Advance", "adjust-contrast");
        this.addEndpointToGroup("Advance", "compress-pdf");
        this.addEndpointToGroup("Advance", "extract-image-scans");
        this.addEndpointToGroup("Advance", "repair");
        this.addEndpointToGroup("Advance", "auto-rename");
        this.addEndpointToGroup("Advance", "pipeline");
        this.addEndpointToGroup("Advance", "scanner-effect");
        this.addEndpointToGroup("Advance", "auto-split-pdf");
        this.addEndpointToGroup("Advance", "show-javascript");
        this.addEndpointToGroup("Advance", "split-by-size-or-count");
        this.addEndpointToGroup("Advance", "overlay-pdf");
        this.addEndpointToGroup("Advance", "split-pdf-by-sections");
        this.addEndpointToGroup("Advance", "edit-table-of-contents");
        this.addEndpointToGroup("Advance", "split-pdf-by-chapters");
        this.addEndpointToGroup("CLI", "compress-pdf");
        this.addEndpointToGroup("CLI", "extract-image-scans");
        this.addEndpointToGroup("CLI", "repair");
        this.addEndpointToGroup("CLI", "pdf-to-pdfa");
        this.addEndpointToGroup("CLI", "file-to-pdf");
        this.addEndpointToGroup("CLI", "pdf-to-word");
        this.addEndpointToGroup("CLI", "pdf-to-presentation");
        this.addEndpointToGroup("CLI", "pdf-to-html");
        this.addEndpointToGroup("CLI", "pdf-to-xml");
        this.addEndpointToGroup("CLI", "ocr-pdf");
        this.addEndpointToGroup("CLI", "html-to-pdf");
        this.addEndpointToGroup("CLI", "url-to-pdf");
        this.addEndpointToGroup("CLI", "pdf-to-rtf");
        this.addEndpointToGroup("Python", "extract-image-scans");
        this.addEndpointToGroup("Python", "html-to-pdf");
        this.addEndpointToGroup("Python", "url-to-pdf");
        this.addEndpointToGroup("Python", "file-to-pdf");
        this.addEndpointToGroup("OpenCV", "extract-image-scans");
        this.addEndpointToGroup("LibreOffice", "file-to-pdf");
        this.addEndpointToGroup("LibreOffice", "pdf-to-word");
        this.addEndpointToGroup("LibreOffice", "pdf-to-presentation");
        this.addEndpointToGroup("LibreOffice", "pdf-to-rtf");
        this.addEndpointToGroup("LibreOffice", "pdf-to-html");
        this.addEndpointToGroup("LibreOffice", "pdf-to-xml");
        this.addEndpointToGroup("LibreOffice", "pdf-to-pdfa");
        this.addEndpointToGroup("Unoconvert", "file-to-pdf");
        this.addEndpointToGroup("Java", "merge-pdfs");
        this.addEndpointToGroup("Java", "remove-pages");
        this.addEndpointToGroup("Java", "split-pdfs");
        this.addEndpointToGroup("Java", "pdf-organizer");
        this.addEndpointToGroup("Java", "rotate-pdf");
        this.addEndpointToGroup("Java", "pdf-to-img");
        this.addEndpointToGroup("Java", "img-to-pdf");
        this.addEndpointToGroup("Java", "add-password");
        this.addEndpointToGroup("Java", "remove-password");
        this.addEndpointToGroup("Java", "change-permissions");
        this.addEndpointToGroup("Java", "add-watermark");
        this.addEndpointToGroup("Java", "add-image");
        this.addEndpointToGroup("Java", "extract-images");
        this.addEndpointToGroup("Java", "change-metadata");
        this.addEndpointToGroup("Java", "cert-sign");
        this.addEndpointToGroup("Java", "remove-cert-sign");
        this.addEndpointToGroup("Java", "multi-page-layout");
        this.addEndpointToGroup("Java", "scale-pages");
        this.addEndpointToGroup("Java", "add-page-numbers");
        this.addEndpointToGroup("Java", "auto-rename");
        this.addEndpointToGroup("Java", "auto-split-pdf");
        this.addEndpointToGroup("Java", "sanitize-pdf");
        this.addEndpointToGroup("Java", "crop");
        this.addEndpointToGroup("Java", "get-info-on-pdf");
        this.addEndpointToGroup("Java", "extract-page");
        this.addEndpointToGroup("Java", "pdf-to-single-page");
        this.addEndpointToGroup("Java", "markdown-to-pdf");
        this.addEndpointToGroup("Java", "vector-to-pdf");
        this.addEndpointToGroup("Java", "pdf-to-vector");
        this.addEndpointToGroup("Java", "show-javascript");
        this.addEndpointToGroup("Java", "auto-redact");
        this.addEndpointToGroup("Java", "redact");
        this.addEndpointToGroup("Java", "pdf-to-csv");
        this.addEndpointToGroup("Java", "split-by-size-or-count");
        this.addEndpointToGroup("Java", "overlay-pdf");
        this.addEndpointToGroup("Java", "split-pdf-by-sections");
        this.addEndpointToGroup("Java", REMOVE_BLANKS);
        this.addEndpointToGroup("Java", "pdf-to-text");
        this.addEndpointToGroup("Java", "remove-image-pdf");
        this.addEndpointToGroup("Java", "pdf-to-markdown");
        this.addEndpointToGroup("Java", "add-attachments");
        this.addEndpointToGroup("Java", "compress-pdf");
        this.addEndpointToGroup("rar", "pdf-to-cbr");
        this.addEndpointToGroup("Java", "pdf-to-video");
        this.addEndpointToGroup("Javascript", "pdf-organizer");
        this.addEndpointToGroup("Javascript", "sign");
        this.addEndpointToGroup("Javascript", "compare");
        this.addEndpointToGroup("Javascript", "adjust-contrast");
        this.addEndpointToGroup("qpdf", "repair");
        this.addEndpointToGroup("qpdf", "compress-pdf");
        this.addEndpointToGroup("Ghostscript", "repair");
        this.addEndpointToGroup("Ghostscript", "compress-pdf");
        this.addEndpointToGroup("Ghostscript", "crop");
        this.addEndpointToGroup("Ghostscript", "replace-invert-pdf");
        this.addEndpointToGroup("Ghostscript", "pdf-to-vector");
        this.addEndpointToGroup("Ghostscript", "vector-to-pdf");
        this.addEndpointToGroup("tesseract", "ocr-pdf");
        this.addEndpointToGroup("OCRmyPDF", "ocr-pdf");
        this.addEndpointAlternative("repair", "qpdf");
        this.addEndpointAlternative("repair", "Ghostscript");
        this.addEndpointAlternative("compress-pdf", "qpdf");
        this.addEndpointAlternative("compress-pdf", "Ghostscript");
        this.addEndpointAlternative("compress-pdf", "Java");
        this.addEndpointAlternative("ocr-pdf", "tesseract");
        this.addEndpointAlternative("ocr-pdf", "OCRmyPDF");
        this.addEndpointAlternative("file-to-pdf", "LibreOffice");
        this.addEndpointAlternative("file-to-pdf", "Unoconvert");
        this.addEndpointAlternative("pdf-to-html", "LibreOffice");
        this.addEndpointAlternative("pdf-to-html", "Pdftohtml");
        this.addEndpointAlternative("pdf-to-markdown", "Pdftohtml");
        this.addEndpointAlternative("markdown-to-pdf", "Weasyprint");
        this.addEndpointAlternative("markdown-to-pdf", "Java");
        this.addEndpointToGroup("Weasyprint", "html-to-pdf");
        this.addEndpointToGroup("Weasyprint", "url-to-pdf");
        this.addEndpointToGroup("Weasyprint", "markdown-to-pdf");
        this.addEndpointToGroup("Weasyprint", "eml-to-pdf");
        this.addEndpointToGroup("Calibre", "ebook-to-pdf");
        this.addEndpointToGroup("Calibre", "pdf-to-epub");
        this.addEndpointToGroup("Pdftohtml", "pdf-to-html");
        this.addEndpointToGroup("Pdftohtml", "pdf-to-markdown");
        this.addEndpointToGroup("FFmpeg", "pdf-to-video");
    }

    private void processEnvironmentConfigs() {
        if (this.applicationProperties != null && this.applicationProperties.getEndpoints() != null) {
            List endpointsToRemove = this.applicationProperties.getEndpoints().getToRemove();
            List groupsToRemove = this.applicationProperties.getEndpoints().getGroupsToRemove();
            if (endpointsToRemove != null) {
                for (String endpoint : endpointsToRemove) {
                    this.disableEndpoint(endpoint.trim());
                }
            }
            if (groupsToRemove != null) {
                for (String group : groupsToRemove) {
                    this.disableGroup(group.trim());
                }
            }
        }
        if (!this.runningProOrHigher) {
            this.disableGroup("enterprise");
        }
        if (!this.applicationProperties.getSystem().isEnableUrlToPDF()) {
            this.disableEndpoint("url-to-pdf");
        }
    }

    public Set<String> getEndpointsForGroup(String group) {
        return this.endpointGroups.getOrDefault(group, new HashSet());
    }

    private boolean isToolGroup(String group) {
        return "qpdf".equals(group) || "OCRmyPDF".equals(group) || "Ghostscript".equals(group) || "LibreOffice".equals(group) || "tesseract".equals(group) || "CLI".equals(group) || "Python".equals(group) || "OpenCV".equals(group) || "Unoconvert".equals(group) || "Java".equals(group) || "Javascript".equals(group) || "Weasyprint".equals(group) || "Pdftohtml".equals(group) || "Calibre".equals(group) || "rar".equals(group) || "FFmpeg".equals(group);
    }

    private boolean isEndpointEnabledDirectly(String endpoint) {
        Boolean explicitStatus;
        if (endpoint.startsWith("/")) {
            endpoint = endpoint.substring(1);
        }
        if (Boolean.FALSE.equals(explicitStatus = (Boolean)this.endpointStatuses.get(endpoint))) {
            return false;
        }
        for (String group : this.endpointGroups.keySet()) {
            if (!this.disabledGroups.contains(group) || !((Set)this.endpointGroups.get(group)).contains(endpoint) || this.isToolGroup(group)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public Map<String, Boolean> getEndpointStatuses() {
        return this.endpointStatuses;
    }
}

